/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import mvc.IFZLBorder;

public class CompoundBorder
implements IFZLBorder {
    IFZLBorder outer;
    IFZLBorder inner;
    JPanel panel;

    public CompoundBorder(IFZLBorder b1, IFZLBorder b2) {
        this.outer = b1;
        this.inner = b2;
        this.panel = new JPanel();
    }

    @Override
    public void drawBorder(Component c, Graphics g) {
        this.outer.drawBorder(c, g);
        Insets o = this.outer.getBorderInsets(c);
        int w = c.getWidth() - o.left - o.right;
        int h = c.getHeight() - o.top - o.bottom;
        this.panel.setSize(w, h);
        g.translate(o.left, o.top);
        this.inner.drawBorder(this.panel, g);
        g.translate(-o.left, -o.top);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets o = this.outer.getBorderInsets(c);
        Insets i = this.inner.getBorderInsets(c);
        int t = i.top + o.top;
        int r = i.right + o.right;
        int b = i.bottom + o.bottom;
        int l = i.left + o.left;
        return new Insets(t, r, b, l);
    }

    @Override
    public void setColor(Color c) {
        this.outer.setColor(c);
        this.inner.setColor(c);
    }
}

