/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lattice.Ray;
import math.VecMath;
import mvc.Controller;
import mvc.Model;

class AnimateRotation<T extends Number>
implements Runnable {
    public static final Boolean INTERPOLATE = true;
    private List<T[]> sincoskdphi;
    private List<T> kdphi;
    final Controller<T> ctrl;
    protected int pause;
    protected List<String> descr;
    protected boolean stopOnEmptyCache;
    protected boolean skipIfOverloaded;
    protected List<Ray<T>> rayCache;
    protected boolean run;

    public AnimateRotation(Controller<T> c) {
        this.ctrl = c;
        this.run = false;
        this.stopOnEmptyCache = false;
        this.skipIfOverloaded = true;
        this.rayCache = new LinkedList<Ray<T>>();
        this.descr = new LinkedList<String>();
        this.sincoskdphi = new ArrayList<T[]>();
        this.kdphi = new ArrayList<T>();
    }

    @Override
    public synchronized void run() {
        Model<T> model = this.ctrl.getModel();
        model.updateWhileCalc(false);
        boolean interpolate = false;
        while (this.run) {
            this.ctrl.stopCalculation();
            int sleep = this.pause;
            int qs = this.ctrl.getView().getReflectionVisualizer().getQueueSize();
            int steps = 2;
            if (this.skipIfOverloaded) {
                steps = (int)(Math.pow(qs, 2.0) / 50.0 + 2.0);
            } else if (interpolate || this.rayCache.size() > 0 && this.rayCache.get(0).getAttribute() == INTERPOLATE) {
                steps = 1;
                interpolate = !interpolate;
            }
            sleep *= steps;
            while (this.kdphi.size() < steps) {
                Number[] sckdphi = (Number[])this.sincoskdphi.get(this.sincoskdphi.size() - 1);
                Number[] scdphi = (Number[])this.sincoskdphi.get(0);
                this.sincoskdphi.add(this.sinCosKPlusOneDphi(sckdphi, scdphi));
                Number dphik = (Number)this.kdphi.get(this.kdphi.size() - 1);
                Number dphi = (Number)this.kdphi.get(0);
                this.kdphi.add(model.getMath().add(dphi, dphik));
            }
            this.ctrl.waitForCalculatorRelease();
            if (this.rayCache.size() > 0) {
                String s = this.descr.size() > 0 ? this.descr.remove(0) : null;
                model.setRay(this.rayCache.remove(0), s, (byte)0);
            } else {
                model.setCalcMode((byte)0);
            }
            model.rotateGrid((Number)this.kdphi.get(steps - 1), (Number[])this.sincoskdphi.get(steps - 1));
            if (this.stopOnEmptyCache && this.rayCache.size() == 0) {
                model.updateWhileCalc(true);
            }
            this.ctrl.startCalculation();
            if (this.stopOnEmptyCache && this.rayCache.size() == 0) {
                this.ctrl.waitForCalculatorRelease();
                this.run = false;
                continue;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.rayCache.clear();
        this.descr.clear();
        this.sincoskdphi.clear();
        this.kdphi.clear();
        model.updateWhileCalc(true);
    }

    private T[] sinCosKPlusOneDphi(T[] sckdphi, T[] scdphi) {
        VecMath<T> mt = this.ctrl.getModel().getMath();
        Number[] retVal = mt.util.array(2);
        retVal[0] = mt.add(mt.mul(sckdphi[0], scdphi[1]), mt.mul(sckdphi[1], scdphi[0]));
        retVal[1] = mt.sub(mt.mul(sckdphi[1], scdphi[1]), mt.mul(sckdphi[0], scdphi[0]));
        return retVal;
    }

    public void setPhi(float phi) {
        VecMath<T> math = this.ctrl.getModel().getMath();
        this.kdphi.add(math.util.copy(math.util.cast(phi / 2.0f), math.PRECISION));
        this.sincoskdphi.add(math.sincos((Number)this.kdphi.get(0)));
    }

    public void setPhi(T phi) {
        VecMath<T> math = this.ctrl.getModel().getMath();
        phi = math.div(phi, math.TWO);
        this.kdphi.add(math.util.copy(phi, math.PRECISION));
        this.sincoskdphi.add(math.sincos((Number)this.kdphi.get(0)));
    }

    public float getPhi() {
        if (this.kdphi.size() > 1) {
            return ((Number)this.kdphi.get(1)).floatValue();
        }
        return 0.0f;
    }
}

