/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.Globals;
import common.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lattice.IBox;
import lattice.IShape;
import lattice.Ray;
import lattice.RayPolygon;
import lattice.ReflectionEngine;
import lattice.ShapeContainer;
import math.VecMath;
import mvc.AnimateRotation;
import mvc.Controller;
import mvc.MainMenuBar;
import mvc.Model;
import pattern.BaseLightPattern;
import pattern.LightCharPattern;

public final class AnimatePatterns<T extends Number>
extends AnimateRotation<T> {
    public static long ANIM_SHOW_TIME = 8000L;
    public static final byte ANIM_PAT_VERY_SLOW = 0;
    public static final byte ANIM_PAT_SLOW = 1;
    public static final byte ANIM_PAT_MEDIUM = 2;
    public static final byte ANIM_PAT_FAST = 3;
    public static final byte ANIM_PAT_VERY_FAST = 4;
    public static final byte[] ANIM_PAT_SPEEDS = new byte[]{0, 1, 2, 3, 4};
    private List<BaseLightPattern<T>> patterns;
    boolean run2;
    int idx;
    byte speed;

    public AnimatePatterns(Controller<T> c, int startIdx, short gridSize) {
        super(c);
        this.stopOnEmptyCache = true;
        this.skipIfOverloaded = false;
        this.speed = (byte)2;
        this.pause = 25;
        this.patterns = this.ctrl.getModel().getLightPatterns();
        Iterator<BaseLightPattern<T>> it = this.patterns.iterator();
        while (it.hasNext()) {
            BaseLightPattern<T> blp = it.next();
            if (!(blp instanceof LightCharPattern)) continue;
            it.remove();
        }
        Collections.sort(this.patterns, new Comparator<BaseLightPattern<T>>(){

            @Override
            public int compare(BaseLightPattern<T> p1, BaseLightPattern<T> p2) {
                if (p1.getCellSequence().size() < p2.getCellSequence().size()) {
                    return -1;
                }
                if (p1.getCellSequence().size() > p2.getCellSequence().size()) {
                    return 1;
                }
                return 0;
            }
        });
        Collections.sort(this.patterns, new Comparator<BaseLightPattern<T>>(){

            @Override
            public int compare(BaseLightPattern<T> p1, BaseLightPattern<T> p2) {
                if (p1.getGridSize() < p2.getGridSize()) {
                    return -1;
                }
                if (p1.getGridSize() > p2.getGridSize()) {
                    return 1;
                }
                return 0;
            }
        });
        this.idx = 0;
        if (startIdx > -1) {
            this.idx = startIdx;
        } else if (gridSize > 1) {
            this.idx = 0;
            while (this.idx < this.patterns.size() && this.patterns.get(this.idx).getGridSize() != gridSize) {
                ++this.idx;
            }
        }
    }

    @Override
    public synchronized void run() {
        Model model = this.ctrl.getModel();
        IBox gib = model.getGridInitBound();
        Number[] corner = (Number[])gib.getCorner().clone();
        VecMath mt = model.getMath();
        model.setGridRotation((Number)mt.ZERO, mt.getBase((byte)1, (byte)2));
        long t1 = 0L;
        long t2 = 0L;
        while (this.run2) {
            if (this.idx == this.patterns.size()) {
                this.idx = 0;
            }
            while (this.idx < this.patterns.size() && this.run2) {
                BaseLightPattern<T> blp = this.patterns.get(this.idx);
                Object gap = model.calcGap(blp.getGridSize());
                Object r = model.calcShapeSize(blp.getGridSize());
                T maxSize = mt.mul(blp.getMaxShapeSize(), gap);
                if (mt.cmp(r, maxSize = mt.div(maxSize, mt.util.cast(200))) > 0) {
                    Log.getIstc().log("Skipped pattern " + blp.getName() + " :" + " Selected radius " + "is greater than max. pattern radius.\n");
                } else {
                    blp.setParameters(corner, (Number)gap, (Number)r);
                    short curPrec = Globals.PRECISIONS[Globals.IDX_PREC];
                    int maxAc = blp.getAccuracyUpperBound();
                    if (curPrec < maxAc) {
                        Log.getIstc().log("Skipped pattern " + blp.getName() + " :" + " Selected precision " + "is to low.\n");
                    } else {
                        int k2;
                        Object phi = mt.util.copy(blp.getRotation(), mt.PRECISION);
                        Object phiCur = model.getGridRotation();
                        Number[] sinCosPhi = model.getMath().sincos((Number)phi);
                        Number worldX = model.getWorldBox().getCorner()[0];
                        worldX = mt.add(worldX, model.getWorldBox().getLengths()[0]);
                        Number[] start = blp.getStart(worldX, (Number)phi, sinCosPhi);
                        Object delta = mt.mod(mt.sub(phi, phiCur), mt.PI_OVER_TWO);
                        phi = mt.cmp(mt.abs(delta), mt.EPSILON10) <= 0 ? (mt.sign(delta) >= 0 ? mt.add(phiCur, mt.PI_OVER_TWO) : mt.sub(phiCur, mt.PI_OVER_TWO)) : mt.add(phiCur, delta);
                        this.calcPath(model, this.rayCache, start, (Number)phi, blp.getGridSize(), this.speed);
                        int stp = 0;
                        for (int l = 0; l < this.rayCache.size(); ++l) {
                            if (((Ray)this.rayCache.get(l)).getAttribute() != null) continue;
                            ++stp;
                        }
                        Object steps = mt.util.cast(stp);
                        Object dPhi = mt.div(mt.sub(phi, phiCur), steps);
                        this.setPhi((Number)dPhi);
                        for (k2 = 0; k2 < this.rayCache.size(); ++k2) {
                            this.descr.add("");
                        }
                        this.descr.set(this.descr.size() - 1, blp.getName());
                        t2 = System.currentTimeMillis();
                        if (t2 - t1 < ANIM_SHOW_TIME) {
                            try {
                                Thread.sleep(ANIM_SHOW_TIME - (t2 - t1));
                            }
                            catch (InterruptedException k2) {
                                // empty catch block
                            }
                        }
                        if (model.getGridSize() != blp.getGridSize()) {
                            k2 = Globals.getIndex(blp.getGridSize(), Globals.GRID_SIZES);
                            Globals.IDX_GRID_SIZE = (byte)k2;
                            MainMenuBar mb = this.ctrl.getView().getMainMenuBar();
                            if (mb != null) {
                                if (this.idx != -1) {
                                    mb.setSelectedIdx((short)k2, mb.gridSizeMenu, false);
                                } else {
                                    mb.rebuildGridSizeMenu(blp.getGridSize(), false);
                                }
                            }
                            model.setGridSize(blp.getGridSize());
                        }
                        this.run = this.run2;
                        super.run();
                        t1 = System.currentTimeMillis();
                    }
                }
                ++this.idx;
            }
        }
    }

    private void calcPath(Model<T> model, List<Ray<T>> rays, T[] pos, T phi, short size, byte speeeed) {
        ShapeContainer<Double> fltCtr = model.getShapeContainerDouble();
        fltCtr.setPoints((short)(size + 1));
        VecMath<T> tmath = model.getMath();
        VecMath<Double> dmath = model.getDoubleMath();
        Number[] st = model.getRay().getStart();
        Number[] pt1 = tmath.util.cast2DoubleArray(st);
        Number[] pt2 = tmath.util.cast2DoubleArray((Number[])pos);
        fltCtr.world2LocalPoint(pt1, pt1);
        double dphi = ((Number)phi).doubleValue() - ((Number)model.getGridRotation()).doubleValue();
        fltCtr.rotate((Number[])dmath.ZERO2D, null, dphi);
        fltCtr.world2LocalPoint(pt2, pt2);
        IShape shape = fltCtr.getShape();
        shape.setSize(shape.getSize() * (double)1.1f);
        fltCtr.setShape(shape);
        if (fltCtr.getShapeLocal(pt1) != null || fltCtr.getShapeLocal(pt2) != null) {
            shape.setSize(shape.getSize() / (double)1.1f);
        }
        ArrayList<Object> starts = new ArrayList<Object>();
        IBox<T> gib = model.getGridInitBound();
        double l = ((Number)gib.getLength((byte)1)).doubleValue();
        double dx = ((Double)pt2[0] - (Double)pt1[0]) / l;
        double dy = ((Double)pt2[1] - (Double)pt1[1]) / l;
        double dp = dphi / Math.PI;
        double div = 0.002;
        switch (speeeed) {
            case 0: {
                div = 5.0E-4;
                break;
            }
            case 1: {
                div = 0.001;
                break;
            }
            case 2: {
                div = 0.002;
                break;
            }
            case 3: {
                div = 0.004;
                break;
            }
            case 4: {
                div = 0.008;
            }
        }
        int s = (int)(Math.sqrt(dx * dx + dy * dy + dp * dp) / div);
        Number[] dv = new Double[]{((Double)pt2[0] - (Double)pt1[0]) / (double)s, ((Double)pt2[1] - (Double)pt1[1]) / (double)s};
        Number[] tmp = (Double[])pt1.clone();
        for (int k = 0; k < s; ++k) {
            dmath.add(tmp, dv, tmp);
            starts.add(tmp.clone());
        }
        Iterator it = starts.iterator();
        while (it.hasNext() && fltCtr.getShapeLocal((Number[])it.next()) != null) {
            it.remove();
        }
        ArrayList<Integer> isctIdxs = new ArrayList<Integer>();
        ArrayList shapes = new ArrayList();
        boolean in1 = false;
        for (int i = 0; i < starts.size(); ++i) {
            Double[] ctr2;
            Number[] pt = (Double[])starts.get(i);
            Double[] ctr1 = in1 ? (Double[])((Double[])shape.getCenter()).clone() : null;
            shape = fltCtr.getShapeLocal(pt);
            boolean in2 = shape != null;
            Double[] doubleArray = ctr2 = in2 ? (Double[])shape.getCenter() : null;
            if (in1 && in2 && (ctr1[0] != ctr2[0] || ctr1[1] != ctr2[1])) {
                isctIdxs.add(i);
                isctIdxs.add(i - 1);
                shapes.add(shape.copy());
            } else if (in1 != in2) {
                if (in2) {
                    isctIdxs.add(i - 1);
                    shapes.add(shape.copy());
                } else {
                    isctIdxs.add(i);
                }
            }
            in1 = in2;
        }
        ArrayList<Object> starts2 = new ArrayList<Object>();
        int idxEnd = 0;
        for (int i = 0; i < isctIdxs.size(); i += 2) {
            int idx1 = (Integer)isctIdxs.get(i);
            int idx2 = (Integer)isctIdxs.get(i + 1);
            shape = (IShape)shapes.get(i / 2);
            double r = (Double)shape.getSize();
            pt1 = (Double[])starts.get(idx1);
            pt2 = (Double[])starts.get(idx2);
            Number[] ctr = (Double[])shape.getCenter();
            Double[] dn = new Double[]{(Double)pt2[1] - (Double)pt1[1], -((Double)pt2[0] - (Double)pt1[0])};
            Double[] ptm = new Double[]{((Double)pt2[0] + (Double)pt1[0]) / 2.0, ((Double)pt2[1] + (Double)pt1[1]) / 2.0};
            Number[] du = new Double[]{ctr[0] - ptm[0], ctr[1] - ptm[1]};
            double dbeta = (Double)dmath.norm(dv) / r;
            double betaMax = 2.0 * Math.acos((Double)dmath.norm(du) / r);
            betaMax = Math.abs(betaMax);
            if ((ctr[0] - ptm[0]) * dn[0] + (ctr[1] - ptm[1]) * dn[1] > 0.0) {
                dbeta = -dbeta;
            }
            tmp = (Double[])pt1.clone();
            Double[] sinCos = (Double[])dmath.sincos(dbeta);
            starts2.addAll(starts.subList(idxEnd, idx1 + 1));
            idxEnd = idx2;
            double beta = 0.0;
            while (Math.abs(beta) < betaMax) {
                dmath.rotate2D(tmp, ctr, sinCos[0], sinCos[1]);
                starts2.add(tmp.clone());
                beta += dbeta;
            }
        }
        starts2.addAll(starts.subList(idxEnd, starts.size()));
        fltCtr.rotate((Number[])dmath.ZERO2D, null, -dphi);
        double dalpha = dphi / (double)starts2.size();
        ReflectionEngine<Double> fEng = new ReflectionEngine<Double>(dmath, 4, 2);
        fEng.setOutputType((byte)0);
        RayPolygon fpoly = new RayPolygon(dmath.util, 3);
        Number[] dir = new Double[]{-1.0, 0.0};
        int rcnt = -1;
        for (int i = 0; i < starts2.size() - 1; ++i) {
            fltCtr.rotate((Number[])dmath.ZERO2D, null, dalpha);
            fltCtr.local2WorldPoint((Number[])starts2.get(i), tmp);
            Ray testRay = new Ray(tmp, dir, dmath.util);
            fEng.calcStatic(testRay, fltCtr, fpoly, null);
            if ((rcnt > -1 && fpoly.size() >= 1 || rcnt > 0) && (rcnt < 3 && fpoly.size() < 4 || rcnt < 4 && fpoly.size() < 3)) {
                fltCtr.rotate((Number[])dmath.ZERO2D, null, -dalpha / 2.0);
                Number[] pt = new Double[]{(((Double[])starts2.get(i))[0] + ((Double[])starts2.get(i - 1))[0]) / 2.0, (((Double[])starts2.get(i))[1] + ((Double[])starts2.get(i - 1))[1]) / 2.0};
                fltCtr.local2WorldPoint((Number[])pt.clone(), pt);
                Number[] start = tmath.util.cast((Double[])pt);
                start[0] = tmath.util.copy(start[0], tmath.PRECISION);
                start[1] = tmath.util.copy(start[1], tmath.PRECISION);
                Ray iRay = new Ray(start, model.LIGHT_SOURCE_DIR, tmath.util);
                iRay.setAttribute(INTERPOLATE);
                rays.add(iRay);
                fltCtr.rotate((Number[])dmath.ZERO2D, null, dalpha / 2.0);
            }
            rcnt = fpoly.size();
            Number[] start = tmath.util.cast((Double[])tmp);
            start[0] = tmath.util.copy(start[0], tmath.PRECISION);
            start[1] = tmath.util.copy(start[1], tmath.PRECISION);
            rays.add(new Ray(start, model.LIGHT_SOURCE_DIR, tmath.util));
        }
        rays.add(new Ray(pos, model.LIGHT_SOURCE_DIR, tmath.util));
    }
}

