/*
 * Decompiled with CFR 0.152.
 */
package math;

import common.Log;
import math.UtilApfloat;
import math.VecMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;

public final class VecMathApfloat
extends VecMath<Apfloat> {
    private Apfloat ONE_P;

    public VecMathApfloat(short precision) {
        this(precision, true);
    }

    public VecMathApfloat(short precision, boolean useTables) {
        super(new UtilApfloat(), precision, useTables, true);
        this.ONE_P = this.limit((Apfloat)this.ONE);
    }

    @Override
    public Apfloat add(Apfloat x, Apfloat y) {
        return x.add(y);
    }

    @Override
    public Apfloat sub(Apfloat x, Apfloat y) {
        return x.subtract(y);
    }

    @Override
    public Apfloat mul(Apfloat x, Apfloat y) {
        return x.multiply(y);
    }

    @Override
    public Apfloat mul(Apfloat x, int i) {
        return this.mul(x, (Apfloat)this.util.cast(i));
    }

    @Override
    public Apfloat div(Apfloat x, Apfloat y) {
        return x.divide(y);
    }

    @Override
    public Apfloat sqrt(Apfloat x) {
        return ApfloatMath.sqrt(x);
    }

    @Override
    public Apfloat sqrt(Apfloat x, int p) {
        if (x.precision() > (long)this.PRECISION) {
            x = this.util.copy(x, p);
        }
        return ApfloatMath.sqrt(x);
    }

    @Override
    public Apfloat neg(Apfloat x) {
        return x.negate();
    }

    @Override
    public Apfloat cos(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.cos(x);
        VecMathApfloat.log("cos", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat acos(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.acos(x);
        VecMathApfloat.log("acos", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat sin(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.sin(x);
        VecMathApfloat.log("sin", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat asin(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.asin(x);
        VecMathApfloat.log("asin", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat tan(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.tan(x);
        VecMathApfloat.log("tan", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat atan(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.atan(x);
        VecMathApfloat.log("atan", x.precision(), t);
        return retVal;
    }

    @Override
    public Apfloat log(Apfloat x) {
        long t = System.currentTimeMillis();
        Apfloat retVal = ApfloatMath.log(x);
        VecMathApfloat.log("log", x.precision(), t);
        return retVal;
    }

    private static void log(String f, long p, long t) {
        t = System.currentTimeMillis() - t;
        String pr = p == Long.MAX_VALUE ? "Infinite" : p + "";
        Log.getIstc().logln(f + "(x): Precision = " + pr + ", Time = " + t + " ms");
    }

    @Override
    public byte cmp(Apfloat x, Apfloat y) {
        return (byte)x.compareTo(y);
    }

    @Override
    public Apfloat inv(Apfloat x) {
        return this.ONE_P.divide(x);
    }

    @Override
    public Apfloat abs(Apfloat x) {
        return ApfloatMath.abs(x);
    }

    @Override
    public Apfloat mod(Apfloat x, Apfloat y) {
        return x.mod(y);
    }

    @Override
    public Apfloat pow(Apfloat x, int ex) {
        return ApfloatMath.pow(x, ex);
    }

    @Override
    public Apfloat pow(Apfloat x, Apfloat y) {
        return ApfloatMath.pow(x, y);
    }

    @Override
    public byte sign(Apfloat x) {
        return (byte)x.signum();
    }

    @Override
    public void setPrecision(int p) {
        super.setPrecision(p);
        this.ONE_P = this.limit((Apfloat)this.ONE);
    }

    private Apfloat limit(Apfloat x) {
        long p = x.precision();
        if (p == Long.MAX_VALUE) {
            return x.precision(this.PRECISION + 10);
        }
        return x;
    }
}

