/*
 * Decompiled with CFR 0.152.
 */
package math;

import common.Log;
import java.util.HashMap;
import math.IBasicOperations;
import math.IFunction;
import math.Util;

public abstract class VecMath<T extends Number>
implements IBasicOperations<T> {
    public final T ZERO;
    public final T ONE;
    public final T MINUS_ONE;
    public final T TWO;
    public final T THREE;
    public final T FOUR;
    public final T FIVE;
    public final T TEN;
    public final T HUNDRED;
    public final T THOUSAND;
    public final T MINUS_TEN;
    public final T ONE_OVER_TWO;
    public final T ONE_OVER_TEN;
    public final T ONE_OVER_HUNDRED;
    public final T ONE_OVER_THOUSAND;
    public final T[] BASE3D_X;
    public final T[] BASE3D_Y;
    public final T[] BASE3D_Z;
    public final T[][] BASE3D;
    public final T[] BASE2D_X;
    public final T[] BASE2D_Y;
    public final T[][] BASE2D;
    public final T[] ZERO2D;
    public final T[] DIAG_HALF2D;
    public final T[] DIAG_HALF3D;
    public final T[] ZERO3D;
    public int PRECISION;
    public T EPSILON;
    public T EPSILON10;
    public T PI;
    public T PI_TIMES_TWO;
    public T PI_OVER_TWO;
    public T PI_OVER_FOUR;
    public T PI_OVER_EIGHT;
    public T E;
    public T[] sinTab;
    public final Util<T> util;
    private int tablePrec;
    private boolean tables;
    private boolean log;

    public VecMath(Util<T> util, int precision, boolean tables, boolean lg) {
        this.PRECISION = precision;
        this.util = util;
        this.tablePrec = -1;
        this.tables = tables;
        this.log = lg;
        this.ZERO = util.cast(0);
        this.ONE = util.cast(1);
        this.MINUS_ONE = util.cast(-1);
        this.TWO = util.cast(2);
        this.THREE = util.cast(3);
        this.FOUR = util.cast(4);
        this.FIVE = util.cast(5);
        this.TEN = util.cast(10);
        this.MINUS_TEN = util.cast(-10);
        this.HUNDRED = util.cast(100);
        this.THOUSAND = util.cast(1000);
        this.ONE_OVER_TWO = this.div(this.ONE, this.TWO);
        this.ONE_OVER_TEN = this.div(this.ONE, this.TEN);
        this.ONE_OVER_HUNDRED = this.div(this.ONE, this.HUNDRED);
        this.ONE_OVER_THOUSAND = this.div(this.ONE, this.THOUSAND);
        this.BASE3D_X = util.array(3);
        this.BASE3D_X[0] = this.ONE;
        this.BASE3D_X[1] = this.ZERO;
        this.BASE3D_X[2] = this.ZERO;
        this.BASE3D_Y = util.array(3);
        this.BASE3D_Y[0] = this.ZERO;
        this.BASE3D_Y[1] = this.ONE;
        this.BASE3D_Y[2] = this.ZERO;
        this.BASE3D_Z = util.array(3);
        this.BASE3D_Z[0] = this.ZERO;
        this.BASE3D_Z[1] = this.ZERO;
        this.BASE3D_Z[2] = this.ONE;
        this.BASE3D = util.array(3, 3);
        this.BASE3D[0] = this.BASE3D_X;
        this.BASE3D[1] = this.BASE3D_Y;
        this.BASE3D[2] = this.BASE3D_Z;
        this.BASE2D_X = util.array(2);
        this.BASE2D_X[0] = this.ONE;
        this.BASE2D_X[1] = this.ZERO;
        this.BASE2D_Y = util.array(2);
        this.BASE2D_Y[0] = this.ZERO;
        this.BASE2D_Y[1] = this.ONE;
        this.BASE2D = util.array(2, 2);
        this.BASE2D[0] = this.BASE2D_X;
        this.BASE2D[1] = this.BASE2D_Y;
        this.ZERO2D = util.array(2);
        this.ZERO2D[0] = this.ZERO;
        this.ZERO2D[1] = this.ZERO;
        this.DIAG_HALF2D = util.array(2);
        this.DIAG_HALF2D[0] = this.ONE_OVER_TWO;
        this.DIAG_HALF2D[1] = this.ONE_OVER_TWO;
        this.DIAG_HALF3D = util.array(3);
        this.DIAG_HALF3D[0] = this.ONE_OVER_TWO;
        this.DIAG_HALF3D[1] = this.ONE_OVER_TWO;
        this.DIAG_HALF3D[2] = this.ONE_OVER_TWO;
        this.ZERO3D = util.array(3);
        this.ZERO3D[0] = this.ZERO;
        this.ZERO3D[1] = this.ZERO;
        this.ZERO3D[2] = this.ZERO;
        this.calcPrecisionDependentValues();
    }

    public void setPrecision(int precision) {
        this.PRECISION = precision;
        this.calcPrecisionDependentValues();
    }

    public void enableTables() {
        this.tables = true;
        this.updateTables();
    }

    private void calcPrecisionDependentValues() {
        long t = 0L;
        if (this.log) {
            Log.getIstc().logln("Calculating pi & e in precision " + this.PRECISION + "...");
            t = System.currentTimeMillis();
        }
        this.PI = this.util.getPi(this.PRECISION);
        this.E = this.util.getE(this.PRECISION);
        if (this.log) {
            Log.getIstc().logln("... pi & e finished (" + -(t -= System.currentTimeMillis()) + " ms)");
        }
        this.PI_TIMES_TWO = this.mul(this.PI, this.TWO);
        this.PI_OVER_TWO = this.div(this.PI, this.TWO);
        this.PI_OVER_FOUR = this.div(this.PI, this.FOUR);
        this.PI_OVER_EIGHT = this.div(this.PI_OVER_FOUR, this.TWO);
        this.EPSILON = this.pow(this.ONE_OVER_TEN, this.PRECISION);
        this.EPSILON10 = this.pow(this.ONE_OVER_TEN, this.PRECISION - 10);
        this.updateTables();
    }

    private void updateTables() {
        if (this.tables && this.tablePrec < this.PRECISION) {
            Log.getIstc().logln("Calculating sine tables in precision " + this.PRECISION + "...");
            long t = System.currentTimeMillis();
            this.tablePrec = this.PRECISION;
            this.sinTab = this.util.array(1000);
            this.calcSinTab((Number[])this.sinTab);
            Log.getIstc().logln("... sine table finished (" + -(t -= System.currentTimeMillis()) + " ms)");
        }
    }

    private void calcSinTab(T[] sin_tab) {
        int i;
        short digits = (short)Math.log10(this.sinTab.length);
        Number[][] tmpSin = this.util.array(digits, 10);
        Number[][] tmpCos = this.util.array(digits, 10);
        tmpSin[digits - 1][1] = this.sin(this.div(this.PI, this.THOUSAND));
        for (int k = tmpSin.length - 1; k >= 0; --k) {
            tmpSin[k][0] = this.ZERO;
            tmpCos[k][0] = this.ONE;
            for (i = 2; i < tmpSin[k].length; ++i) {
                tmpCos[k][i - 1] = this.sqrt(this.sub(this.ONE, this.mul(tmpSin[k][i - 1], tmpSin[k][i - 1])));
                if (k == 0 && i > 5) {
                    tmpCos[k][i - 1] = this.neg(tmpCos[k][i - 1]);
                }
                tmpSin[k][i] = this.add(this.mul(tmpSin[k][i - 1], tmpCos[k][1]), this.mul(tmpCos[k][i - 1], tmpSin[k][1]));
            }
            tmpCos[k][9] = this.sqrt(this.sub(this.ONE, this.mul(tmpSin[k][9], tmpSin[k][9])));
            if (k <= 0) continue;
            tmpSin[k - 1][1] = this.add(this.mul(tmpSin[k][9], tmpCos[k][1]), this.mul(tmpCos[k][9], tmpSin[k][1]));
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            sin_tab[i2] = tmpSin[digits - 1][i2];
        }
        HashMap<Integer, Number> cosHash = new HashMap<Integer, Number>();
        for (i = 10; i < sin_tab.length; ++i) {
            Number cos2;
            String iStr = i + "";
            int num1 = Integer.parseInt(iStr.substring(0, 1));
            int num2 = Integer.parseInt(iStr.substring(1));
            sin_tab[i] = tmpSin[digits - iStr.length()][num1];
            int fullNum = (int)Math.round((double)num1 * Math.pow(10.0, iStr.length() - 1));
            Number cos1 = (Number)cosHash.get(fullNum);
            if (cos1 == null) {
                cos1 = this.sqrt(this.sub(this.ONE, this.mul(sin_tab[i], sin_tab[i])));
                if (i > sin_tab.length / 2) {
                    cos1 = this.neg(cos1);
                }
                cosHash.put(fullNum, cos1);
            }
            if ((cos2 = (Number)cosHash.get(num2)) == null) {
                cos2 = this.sqrt(this.sub(this.ONE, this.mul(sin_tab[num2], sin_tab[num2])));
                cosHash.put(num2, cos2);
            }
            sin_tab[i] = this.add(this.mul(sin_tab[i], cos2), this.mul(cos1, sin_tab[num2]));
        }
    }

    public T discrAngle(float pifactor) {
        boolean neg = false;
        if (pifactor < 0.0f) {
            pifactor = -pifactor;
            neg = true;
        }
        int idx = Math.min((int)(pifactor * (float)this.sinTab.length + 0.5f), this.sinTab.length - 1);
        T t1 = this.util.cast(idx);
        T t2 = this.util.cast(this.sinTab.length);
        T retVal = this.mul(this.PI, this.div(t1, t2));
        if (neg) {
            retVal = this.neg(retVal);
        }
        return retVal;
    }

    public T[] discrSinCos(float pifactor) {
        Number[] ret = this.util.array(2);
        boolean neg = false;
        if (pifactor < 0.0f) {
            neg = true;
            pifactor = -pifactor;
        }
        if (pifactor < 1.0f) {
            int idx = Math.min((int)(pifactor * (float)this.sinTab.length + 0.5f), this.sinTab.length - 1);
            ret[0] = this.sinTab[idx];
            if (neg) {
                ret[0] = this.neg(ret[0]);
            }
            if (idx >= this.sinTab.length / 2) {
                neg = true;
                idx -= this.sinTab.length / 2;
            } else {
                neg = false;
                idx = this.sinTab.length / 2 - idx;
            }
            ret[1] = this.sinTab[idx];
            if (neg) {
                ret[1] = this.neg(ret[1]);
            }
        } else {
            Log.getIstc().logln("Error: Sine table not defined for abs(phi) >= pi");
        }
        return ret;
    }

    public T[] sincos(T phi) {
        Number[] ret = null;
        boolean neg = false;
        if (this.cmp(phi, this.ZERO) < 0) {
            neg = true;
            phi = this.neg(phi);
        }
        if (this.cmp(phi, this.PI) > 0) {
            T k = this.util.cast(((Number)this.div(this.sub(phi, this.PI), this.PI_TIMES_TWO)).intValue());
            phi = this.sub(phi, this.mul(this.add(k, this.ONE), this.PI_TIMES_TWO));
        }
        if (this.cmp(phi, this.ZERO) < 0) {
            neg = !neg;
            phi = this.neg(phi);
        }
        ret = this.util.array(2);
        ret[0] = this.sin(phi);
        ret[1] = this.sqrt(this.sub(this.ONE, this.mul(ret[0], ret[0])));
        if (this.cmp(phi, this.PI_OVER_TWO) > 0) {
            ret[1] = this.neg(ret[1]);
        }
        if (neg) {
            ret[0] = this.neg(ret[0]);
        }
        return ret;
    }

    public T[] getBase(byte idx, byte dim) {
        return dim == 3 ? this.BASE3D[idx] : this.BASE2D[idx];
    }

    public T[][] getBase(byte dim) {
        return dim == 3 ? this.BASE3D : this.BASE2D;
    }

    public T[] getDiagHalf(byte dim) {
        return dim == 3 ? this.DIAG_HALF3D : this.DIAG_HALF2D;
    }

    public void swap(T[] vec, byte idx1, byte idx2) {
        T tmp = vec[idx1];
        vec[idx1] = vec[idx2];
        vec[idx2] = tmp;
    }

    public T norm(T[] vec) {
        return (T)this.sqrt(this.normSquared((Number[])vec));
    }

    public T dot(T[] vec1, T[] vec2) {
        T retVal = this.ZERO;
        for (int i = 0; i < vec1.length; ++i) {
            retVal = this.add(retVal, this.mul(vec1[i], vec2[i]));
        }
        return retVal;
    }

    public void normalize(T[] vec) {
        Number norm = this.norm((Number[])vec);
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = this.div(vec[i], norm);
        }
    }

    public void diff(T[] vec1, T[] vec2, T[] vec3) {
        for (int i = 0; i < vec1.length; ++i) {
            vec3[i] = this.sub(vec1[i], vec2[i]);
        }
    }

    public void scaleAdd(T[] v1, T x, T[] v2, T[] v3) {
        for (int i = 0; i < v1.length; ++i) {
            v3[i] = this.add(v1[i], this.mul(x, v2[i]));
        }
    }

    public T normSquared(T[] vec) {
        T retVal = this.ZERO;
        for (int i = 0; i < vec.length; ++i) {
            retVal = this.add(retVal, this.mul(vec[i], vec[i]));
        }
        return retVal;
    }

    @Override
    public void neg(T[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.neg(v[i]);
        }
    }

    public void decompose(T[] v, T[] b1, T[] b2, T[] par) {
        par[0] = this.dot((Number[])b1, (Number[])v);
        par[1] = this.dot((Number[])b2, (Number[])v);
    }

    public void decompose(T[] v, T[][] b, T[] par) {
        for (int i = 0; i < b.length; ++i) {
            par[i] = this.dot((Number[])b[i], (Number[])v);
        }
    }

    public void scale(T x, T[] vec) {
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = this.mul(x, vec[i]);
        }
    }

    public void invScale(T x, T[] vec) {
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = this.div(vec[i], x);
        }
    }

    public void scale(T[] v1, T x, T[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            v2[i] = this.mul(x, v1[i]);
        }
    }

    public void scale(T[] scaleVec, T[] v) {
        for (int i = 0; i < scaleVec.length; ++i) {
            v[i] = this.mul(v[i], scaleVec[i]);
        }
    }

    public void scale(T[] scaleVec, T[] v1, T[] v2) {
        for (int i = 0; i < scaleVec.length; ++i) {
            v2[i] = this.mul(v1[i], scaleVec[i]);
        }
    }

    public void invScale(T[] scaleVec, T[] v) {
        for (int i = 0; i < scaleVec.length; ++i) {
            v[i] = this.div(v[i], scaleVec[i]);
        }
    }

    public void add(T[] v1, T[] v2, T[] v3) {
        for (int i = 0; i < v1.length; ++i) {
            v3[i] = this.add(v1[i], v2[i]);
        }
    }

    public void mirror(T[] v1, T[] nor, T[] v2) {
        this.scale(this.dot((Number[])v1, (Number[])nor), (Number[])nor);
        this.scaleAdd((Number[])v1, (Number)this.neg(this.TWO), (Number[])nor, (Number[])v2);
    }

    public void rotate(T[] v, boolean dir) {
        if (dir) {
            T tmp = v[v.length - 1];
            for (int i = v.length - 2; i >= 0; --i) {
                v[i + 1] = v[i];
            }
            v[0] = tmp;
        } else {
            T tmp = v[0];
            for (int i = 0; i < v.length - 1; ++i) {
                v[i] = v[i + 1];
            }
            v[v.length - 1] = tmp;
        }
    }

    public void rotate2D(T[] vec, T[] ori, T sinphi, T cosphi) {
        Number[] tmp = (Number[])vec.clone();
        this.diff((Number[])vec, (Number[])ori, tmp);
        vec[0] = this.add(this.sub(this.mul(cosphi, tmp[0]), this.mul(sinphi, tmp[1])), ori[0]);
        vec[1] = this.add(this.add(this.mul(sinphi, tmp[0]), this.mul(cosphi, tmp[1])), ori[1]);
    }

    public void rotate2D(T[] vec, T[] ori, T phi) {
        Number[] tmp = (Number[])vec.clone();
        this.diff((Number[])vec, (Number[])ori, tmp);
        Number[] sinCos = this.sincos((Number)phi);
        vec[0] = this.add(this.sub(this.mul(sinCos[1], tmp[0]), this.mul(sinCos[0], tmp[1])), ori[0]);
        vec[1] = this.add(this.add(this.mul(sinCos[0], tmp[0]), this.mul(sinCos[1], tmp[1])), ori[1]);
    }

    public void linBaseComb(T[] par, T[][] vecs, T[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.ZERO;
        }
        this.linBaseCombAdd((Number[])par, (Number[][])vecs, (Number[])v);
    }

    public void linBaseCombAdd(T[] par, T[][] vecs, T[] v) {
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < par.length; ++j) {
                v[i] = this.add(v[i], this.mul(vecs[j][i], par[j]));
            }
        }
    }

    public void linBaseComb(short[] par, T[][] vecs, T[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.ZERO;
        }
        this.linBaseCombAdd(par, (Number[][])vecs, (Number[])v);
    }

    public void linBaseCombAdd(short[] par, T[][] vecs, T[] v) {
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < par.length; ++j) {
                v[i] = this.add(v[i], this.mul(vecs[j][i], par[j]));
            }
        }
    }

    public void transform(T[] v, T[][] b1, T[][] b2, T[] ret) {
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.ZERO;
            for (int j = 0; j < ret.length; ++j) {
                ret[i] = this.add(ret[i], this.mul(this.dot((Number[])b1[j], (Number[])b2[i]), v[j]));
            }
        }
    }

    public void transform(T[] v, T[][] b, T[] ret) {
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.ZERO;
            for (int j = 0; j < ret.length; ++j) {
                ret[i] = this.add(ret[i], this.mul(b[j][i], v[j]));
            }
        }
    }

    public T findRoot(IFunction<T> f, IFunction<T> dfOverDx, T start) throws Exception {
        int digits;
        T er;
        T cur = this.util.copy(start, 10);
        int curAccu = 0;
        do {
            boolean resume = false;
            if (this.util.precision(cur) <= 4 * curAccu) {
                cur = this.util.copy(cur, Math.min(4 * curAccu, this.util.precision(start) + 10));
            }
            T old = cur;
            cur = this.approximateRoot(f, dfOverDx, cur);
            er = this.abs(this.sub(cur, old));
            digits = -this.util.getScale(er);
            curAccu = Math.max(curAccu, digits);
        } while (resume |= this.cmp(er, this.ZERO) != 0 && digits <= this.util.precision(start));
        return this.util.copy(cur, this.util.precision(start));
    }

    public T approximateRoot(IFunction<T> f, IFunction<T> dfOverDx, T cur) throws Exception {
        Number delta = this.div((Number)f.f(cur), (Number)dfOverDx.f(cur));
        return (T)this.sub(cur, delta);
    }

    public T findRoot(IFunction<T> f, T start) throws Exception {
        int digits;
        int er;
        Object cur = this.util.copy(start, 20);
        Object old = this.add(cur, this.pow(this.ONE_OVER_TEN, 10));
        Number fold = f.f((int)old);
        int subCurOld = this.sub(cur, old);
        int curAccu = 0;
        do {
            boolean resume = false;
            if (this.util.precision(cur) <= 2 * curAccu + 10) {
                cur = this.util.copy(cur, 2 * curAccu + 10);
            }
            Number fcur = (Number)f.f((int)cur);
            Number invGrad = this.div(subCurOld, this.sub(fcur, fold));
            Number val = this.sub(cur, this.mul(fcur, invGrad));
            old = cur;
            fold = fcur;
            cur = val;
            subCurOld = this.sub(cur, old);
            er = this.abs(subCurOld);
            digits = -this.util.getScale(er);
            curAccu = Math.max(curAccu, digits);
        } while (resume |= this.cmp(er, this.ZERO) != 0 && digits <= this.util.precision(start));
        return this.util.copy(cur, this.util.precision(start));
    }

    public float getCalculationSpeed() {
        T pi = this.util.getPi(5000);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 66; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.add(pi, pi);
            }
            this.mul(pi, pi);
        }
        return (float)(System.currentTimeMillis() - t0) * 1.0f / 1000.0f;
    }
}

