/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.Util;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.Aprational;

public final class UtilApfloat
extends Util<Apfloat> {
    private static final Apfloat HALF = new Apfloat("0.5").precision(Long.MAX_VALUE);

    @Override
    public Apfloat cast(int i) {
        return new Apfloat(i);
    }

    @Override
    public Apfloat cast(float f) {
        return new Apfloat(f);
    }

    @Override
    public Apfloat cast(double d) {
        return new Apfloat(d);
    }

    @Override
    public Apfloat copy(Apfloat x, int p) {
        return x.precision(p);
    }

    @Override
    public Apfloat round(Apfloat x, int p) {
        int scale = this.getScale(x);
        if ((long)(scale + 1) + x.precision() < (long)p) {
            return x;
        }
        Apfloat ret = ApfloatMath.scale(ApfloatMath.scale(x, p).add(HALF).floor(), -p);
        if (scale > -1) {
            p += scale + 1;
        }
        return ret.precision() > (long)p ? ret.precision(p) : ret;
    }

    @Override
    public Apfloat expand(Apfloat x, int p) {
        return new Apfloat(x.toString(), (long)p);
    }

    @Override
    public int precision(Apfloat x) {
        long p = x.precision();
        if (p == Long.MAX_VALUE || p > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)p;
    }

    @Override
    public Apfloat parse(String s) throws NumberFormatException {
        if (s.indexOf("/") != -1) {
            return new Aprational(s);
        }
        return new Apfloat(s);
    }

    @Override
    public Apfloat getPi(int digits) {
        return ApfloatMath.pi(digits);
    }

    @Override
    public Apfloat getE(int digits) {
        return ApfloatMath.exp(this.copy(Apcomplex.ONE, digits));
    }

    public Apfloat[] array(int dim) {
        return new Apfloat[dim];
    }

    public Apfloat[][] array(int d1, int d2) {
        return new Apfloat[d1][d2];
    }

    @Override
    public int getScale(Apfloat x) {
        long s = x.scale();
        if (s == -9223372036854775807L || s < -2147483647L) {
            return -2147483647;
        }
        return (int)s - 1;
    }

    @Override
    public int getErrorScale(Apfloat x) {
        int s = this.getScale(x);
        if (s == -2147483647) {
            return s;
        }
        int p = this.precision(x);
        if (p == Integer.MAX_VALUE) {
            return -2147483647;
        }
        return s - this.precision(x) + 1;
    }

    @Override
    public String toPlainString(Apfloat t) {
        if (t instanceof Aprational) {
            String strg = t.toString();
            int idx = strg.indexOf("/");
            Apfloat x = new Apfloat(strg.substring(0, idx));
            Apfloat y = new Apfloat(strg.substring(idx + 1));
            t = x.divide(y);
        }
        return super.toPlainString(t);
    }
}

