/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.math.BigDecimal;
import java.util.List;

public abstract class Util<T extends Number> {
    public static final int MAX_INT = Integer.MAX_VALUE;
    public static final int MIN_INT = -2147483647;

    public abstract T getPi(int var1);

    public abstract T getE(int var1);

    public abstract T cast(int var1);

    public abstract T cast(float var1);

    public abstract T cast(double var1);

    public final T[] cast(Float[] n) {
        Number[] ret = this.array(n.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.cast(n[i].floatValue());
        }
        return ret;
    }

    public final T[] cast(Double[] n) {
        Number[] ret = this.array(n.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.cast(n[i]);
        }
        return ret;
    }

    public final T[] cast(float[] n) {
        Number[] ret = this.array(n.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.cast(n[i]);
        }
        return ret;
    }

    public final T[] cast(double[] n) {
        Number[] ret = this.array(n.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.cast(n[i]);
        }
        return ret;
    }

    public final Float[] cast2FloatArray(T[] n) {
        Float[] ret = new Float[n.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Float.valueOf(((Number)n[i]).floatValue());
        }
        return ret;
    }

    public final Double[] cast2DoubleArray(T[] n) {
        Double[] ret = new Double[n.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Number)n[i]).doubleValue();
        }
        return ret;
    }

    public final float[] cast2floatArray(T[] n) {
        float[] ret = new float[n.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Number)n[i]).floatValue();
        }
        return ret;
    }

    public final double[] cast2doubleArray(T[] n) {
        double[] ret = new double[n.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Number)n[i]).doubleValue();
        }
        return ret;
    }

    public final float[] cast2floatArray(List<T[]> l) {
        float[] ret = new float[l.size() * 2];
        for (int i = 0; i < l.size(); ++i) {
            ret[2 * i] = ((Number[])l.get(i))[0].floatValue();
            ret[2 * i + 1] = ((Number[])l.get(i))[1].floatValue();
        }
        return ret;
    }

    public final int[] cast2intArray(T[] n) {
        int[] ret = new int[n.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Number)n[i]).intValue();
        }
        return ret;
    }

    public abstract T parse(String var1) throws NumberFormatException;

    public abstract T copy(T var1, int var2);

    public abstract T round(T var1, int var2);

    public abstract T expand(T var1, int var2);

    public final void round(T[] arr, int p) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.round(arr[i], p);
        }
    }

    public final void setPrecision(T[] arr, int p) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.copy(arr[i], p);
        }
    }

    public abstract int precision(T var1);

    public final int minPrecision(T[] arr) {
        int retVal = this.precision(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            int p = this.precision(arr[i]);
            if (p >= retVal) continue;
            retVal = p;
        }
        return retVal;
    }

    public final int maxPrecision(T[] arr) {
        int retVal = this.precision(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            int p = this.precision(arr[i]);
            if (p <= retVal) continue;
            retVal = p;
        }
        return retVal;
    }

    public final T truncate(T x, int ac) {
        int sc = this.getScale(x);
        if (sc != -2147483647 && sc + ac < this.precision(x)) {
            x = this.copy(x, sc + ac + 1);
        }
        return x;
    }

    public final void copy(T[] v1, T[] v2) {
        for (int i = 0; i < v2.length; ++i) {
            v2[i] = v1[i];
        }
    }

    public abstract int getScale(T var1);

    public abstract int getErrorScale(T var1);

    public abstract T[] array(int var1);

    public abstract T[][] array(int var1, int var2);

    public static final int maxValue(int[][] vals) {
        int retVal = Integer.MIN_VALUE;
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[i].length; ++j) {
                if (retVal >= vals[i][j]) continue;
                retVal = vals[i][j];
            }
        }
        return retVal;
    }

    public static final float maxValue(float[][] vals) {
        float retVal = Float.MIN_VALUE;
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[i].length; ++j) {
                if (!(retVal < vals[i][j])) continue;
                retVal = vals[i][j];
            }
        }
        return retVal;
    }

    public String toPlainString(T t) {
        if (t != null) {
            return new BigDecimal(t.toString()).toPlainString();
        }
        return null;
    }
}

