/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import java.util.Iterator;
import java.util.LinkedList;
import lattice.IBox;
import lattice.IShape;
import lattice.Lattice;
import lattice.Ray;
import math.VecMath;

public final class ShapeContainer<T extends Number>
extends Lattice<T> {
    private final LinkedList<Lattice.LocalCellIterator> cellIterList;
    private final LinkedList<IShape<T>> shapeList;
    private final LinkedList<Ray<T>> rayList;
    private IShape<T> defaultShape;

    public ShapeContainer(T[] p, short sidePoints, T gap, VecMath<T> math) {
        super(p, sidePoints, gap, math);
        this.cellIterList = new LinkedList();
        this.shapeList = new LinkedList();
        this.rayList = new LinkedList();
    }

    public ShapeContainer(ShapeContainer<T> ctr, VecMath<T> math) {
        this(ctr.box.copy(), ctr.getPoints(), ctr.getGap(), math, ctr.getShape().copy());
    }

    private ShapeContainer(IBox<T> box, short pts, T gap, VecMath<T> math, IShape<T> s) {
        super(box, pts, gap, math);
        this.defaultShape = s;
        this.cellIterList = new LinkedList();
        this.shapeList = new LinkedList();
        this.rayList = new LinkedList();
    }

    public void setShape(IShape<T> s) {
        this.defaultShape = s;
        this.clearLocalVars();
    }

    public IShape<T> getShape() {
        return this.defaultShape;
    }

    public IShape<T> getShape(T[] pt) {
        IShape<T> retVal = this.defaultShape.copy();
        this.getCellCenter((Number[])pt, retVal.getCenter());
        return retVal.contains((Number[])pt) ? retVal : null;
    }

    public IShape<T> getShapeLocal(T[] locPt) {
        IShape<T> retVal = this.defaultShape.copy();
        this.getCellCenterLocal((Number[])locPt, retVal.getCenter());
        return retVal.contains((Number[])locPt) ? retVal : null;
    }

    @Override
    public void rotate(T[] center, T[] axis, T phi) {
        Number[] sinCos = this.math.sincos((Number)phi);
        this.rotate((Number[])center, (Number[])axis, sinCos[0], sinCos[1]);
    }

    @Override
    public void rotate(T[] center, T[] axis, T sinphi, T cosphi) {
        super.rotate(center, axis, sinphi, cosphi);
        this.defaultShape.rotate(this.defaultShape.getCenter(), null, (Number)sinphi, (Number)cosphi);
        this.clearLocalVars();
    }

    @Override
    public void setGap(T gp) {
        this.defaultShape.scale(this.math.div(gp, this.getGap()));
        super.setGap(gp);
        this.clearLocalVars();
    }

    @Override
    public void setPoints(short pts) {
        this.defaultShape.scale(this.math.util.cast(this.getPoints() - 1));
        this.defaultShape.scale(this.math.inv(this.math.util.cast(pts - 1)));
        super.setPoints(pts);
        Object size = this.math.util.copy(this.math.util.cast(pts - 1), this.math.PRECISION);
        super.setGap(this.math.div(this.getLengths()[0], size));
        this.clearLocalVars();
    }

    private void clearLocalVars() {
        if (this.shapeList != null) {
            this.shapeList.clear();
        }
        if (this.rayList != null) {
            this.rayList.clear();
        }
        if (this.cellIterList != null) {
            this.cellIterList.clear();
        }
    }

    @Override
    public <S extends Number> ShapeContainer<S> convert(IConverter<T, S> cv, VecMath<S> m) {
        IBox sbox = super.convert(cv, (VecMath)m);
        S sGap = cv.convert(this.getGap());
        IShape<S> sShape = null;
        if (this.defaultShape != null) {
            sShape = this.defaultShape.convert(cv, m);
        }
        return new ShapeContainer<S>(sbox, this.getPoints(), sGap, m, sShape);
    }

    public class LocalReflIter
    implements Iterator<T[]> {
        private Lattice.LocalCellIterator cellItr;
        private IShape<T> shape;
        private Ray<T> reflRay;
        private Ray<T> initRay;
        private boolean foundNext;
        private boolean empty = true;
        private int accuracy;
        private short[] startCellIdx;

        public void init(Ray<T> ray, boolean all) {
            this.shape = (IShape)ShapeContainer.this.shapeList.pollFirst();
            if (this.shape == null) {
                this.shape = ShapeContainer.this.defaultShape.copy();
            }
            Object diff = ShapeContainer.this.math.sub(ShapeContainer.this.getGap(), ShapeContainer.this.math.mul(this.shape.getSize(), ShapeContainer.this.math.TWO));
            int scale = ShapeContainer.this.util.getScale(diff);
            if (all) {
                this.startCellIdx = null;
            }
            this.cellItr = (Lattice.LocalCellIterator)ShapeContainer.this.cellIterList.pollFirst();
            if (this.cellItr == null) {
                this.cellItr = new Lattice.LocalCellIterator();
            }
            this.cellItr.init(ray, scale, this.startCellIdx);
            this.startCellIdx = this.cellItr.getStartCellIndex();
            this.startCellIdx = this.startCellIdx != null ? (short[])this.startCellIdx.clone() : null;
            this.reflRay = (Ray)ShapeContainer.this.rayList.pollFirst();
            if (this.reflRay == null) {
                this.reflRay = new Ray(ShapeContainer.this.math.util);
            }
            this.reflRay.copy(this.cellItr.getLocalRay());
            if (this.initRay == null) {
                this.initRay = new Ray(ShapeContainer.this.math.util);
            }
            this.initRay.copy(this.cellItr.getLocalRay());
            this.foundNext = false;
            this.empty = false;
            this.accuracy = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.empty) {
                return false;
            }
            if (!this.foundNext) {
                while (!this.foundNext && this.cellItr.hasNext()) {
                    this.cellItr.next(this.shape.getCenter());
                    this.foundNext = this.shape.reflect(this.reflRay, this.reflRay);
                }
                if (this.foundNext) {
                    this.cellItr.continueWithRay(this.reflRay);
                } else {
                    this.empty = true;
                }
            }
            return this.foundNext;
        }

        public boolean isStartingInShape() {
            boolean retVal = false;
            if (this.cellItr != null && this.cellItr.hasNext()) {
                Ray locRay = this.cellItr.getLocalRay();
                this.cellItr.next(this.shape.getCenter());
                if (this.shape.contains(locRay.getStart())) {
                    retVal = true;
                }
                this.cellItr.replay();
            }
            return retVal;
        }

        @Override
        public T[] next() {
            Number[] pt = ShapeContainer.this.util.array(2);
            boolean res = this.next(pt);
            if (!res) {
                pt = null;
            }
            return pt;
        }

        public boolean next(T[] pt) {
            if (!this.empty && (this.foundNext || this.hasNext())) {
                this.foundNext = false;
                ShapeContainer.this.util.copy(this.reflRay.getStart(), (Number[])pt);
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
        }

        public Ray<T> getInitRay() {
            return this.initRay;
        }

        public Ray<T> getReflRay() {
            return this.reflRay;
        }

        public void setAccuracy(int digits) {
            this.accuracy = digits;
            int rayAccu = this.reflRay.getAccuracy();
            if (rayAccu < this.accuracy) {
                this.reflRay.incPrecision(this.accuracy - rayAccu + 5);
            }
        }

        public void dispose() {
            if (this.shape != null) {
                ShapeContainer.this.shapeList.add(this.shape);
                this.shape = null;
            }
            if (this.cellItr != null) {
                ShapeContainer.this.cellIterList.add(this.cellItr);
                this.cellItr = null;
            }
            if (this.reflRay != null) {
                ShapeContainer.this.rayList.add(this.reflRay);
                this.reflRay = null;
            }
        }
    }

    public class ShapeIterator
    implements Iterator<IShape<T>> {
        private final IShape<T> shape;
        private final T[][] bv;
        private final Lattice.IndexIterator idxIter;
        private final T[] cellCtrCor;

        public ShapeIterator(int prec) {
            Object gap = ShapeContainer.this.math.util.copy(ShapeContainer.this.getGap(), prec);
            this.bv = (Number[][])ShapeContainer.this.getBaseVectors().clone();
            for (int i = 0; i < this.bv.length; ++i) {
                this.bv[i] = (Number[])this.bv[i].clone();
                for (int j = 0; j < this.bv[0].length; ++j) {
                    this.bv[i][j] = ShapeContainer.this.math.mul(this.bv[i][j], gap);
                }
            }
            this.idxIter = new Lattice.IndexIterator();
            this.shape = ShapeContainer.this.getShape().copy();
            short[] dIdxs = new short[this.bv.length];
            for (int i = 0; i < dIdxs.length; i = (int)((byte)(i + 1))) {
                dIdxs[i] = 1;
            }
            this.cellCtrCor = ShapeContainer.this.math.util.array(2);
            ShapeContainer.this.math.linBaseComb(dIdxs, (Number[][])this.bv, (Number[])this.cellCtrCor);
            ShapeContainer.this.math.scale((Number)ShapeContainer.this.math.ONE_OVER_TWO, (Number[])this.cellCtrCor);
            ShapeContainer.this.math.add(ShapeContainer.this.getCorner(), (Number[])this.cellCtrCor, (Number[])this.cellCtrCor);
        }

        @Override
        public boolean hasNext() {
            return this.idxIter.hasNext();
        }

        @Override
        public IShape<T> next() {
            if (this.hasNext()) {
                short[] idxs = this.idxIter.next();
                Number[] cellCtr = (Number[])this.cellCtrCor.clone();
                ShapeContainer.this.math.linBaseCombAdd(idxs, (Number[][])this.bv, cellCtr);
                this.shape.setCenter(cellCtr);
                return this.shape;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public class ShapeIteratorFloat
    implements Iterator<IShape<Float>> {
        private final IShape<Float> shape;
        private final Float[][] bv;
        private final Lattice.IndexIterator idxIter;
        private final Float[] cellCtrCor;
        private final VecMath<Float> fmath;

        public ShapeIteratorFloat(IConverter<T, Float> cv, VecMath<Float> fmt) {
            this.fmath = fmt;
            float gap = ((Number)ShapeContainer.this.getGap()).floatValue();
            Number[][] bvT = (Number[][])ShapeContainer.this.getBaseVectors().clone();
            this.bv = new Float[bvT.length][bvT[0].length];
            for (int i = 0; i < this.bv.length; ++i) {
                for (int j = 0; j < this.bv[0].length; ++j) {
                    this.bv[i][j] = Float.valueOf(bvT[i][j].floatValue() * gap);
                }
            }
            this.idxIter = new Lattice.IndexIterator();
            this.shape = ShapeContainer.this.getShape().convert(cv, this.fmath);
            short[] dIdxs = new short[this.bv.length];
            for (int i = 0; i < dIdxs.length; i = (int)((byte)(i + 1))) {
                dIdxs[i] = 1;
            }
            this.cellCtrCor = (Float[])this.fmath.util.array(2);
            this.fmath.linBaseComb(dIdxs, this.bv, this.cellCtrCor);
            this.fmath.scale((Number)this.fmath.ONE_OVER_TWO, this.cellCtrCor);
            Number[] cor = (Float[])cv.convert(ShapeContainer.this.getCorner());
            this.fmath.add(cor, this.cellCtrCor, this.cellCtrCor);
        }

        @Override
        public boolean hasNext() {
            return this.idxIter.hasNext();
        }

        @Override
        public IShape<Float> next() {
            if (this.hasNext()) {
                short[] idxs = this.idxIter.next();
                Number[] cellCtr = (Float[])this.cellCtrCor.clone();
                this.fmath.linBaseCombAdd(idxs, this.bv, cellCtr);
                this.shape.setCenter(cellCtr);
                return this.shape;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

