/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.Globals;
import common.ICallback;
import common.Log;
import java.util.ArrayList;
import lattice.Ray;
import lattice.RayPolygon;
import lattice.ShapeContainer;
import math.VecMath;

public class ReflectionEngine<T extends Number> {
    public static final byte OUTPUT_LOCAL = 0;
    public static final byte OUTPUT_WORLD = 1;
    private static final int CALC_INIT_PREC = 15;
    private static final int CALC_INC_PREC = 2;
    private final VecMath<T> mt;
    private final int iniAc;
    private final int incAc;
    private final ArrayList<T[]> tmpCoords;
    private final RayPolygon<T> locCoords;
    private final T[] outputPt;
    private final T[] reflPt;
    private boolean calc = true;
    private byte outputType;

    public ReflectionEngine(VecMath<T> mt) {
        this(mt, 15, 2);
    }

    public ReflectionEngine(VecMath<T> mt, int ac_start, int ac_inc) {
        this.mt = mt;
        this.iniAc = ac_start;
        this.incAc = ac_inc;
        this.tmpCoords = new ArrayList();
        this.locCoords = new RayPolygon(mt.util, -1);
        this.outputPt = mt.util.array(2);
        this.reflPt = mt.util.array(2);
        this.outputType = 1;
    }

    public synchronized boolean calcDynamic(Ray<T> ray, ShapeContainer<T> ctr, RayPolygon<T> poly, ICallback cb) {
        this.tmpCoords.clear();
        this.locCoords.clear();
        this.locCoords.setAccuracy(poly.getAccuracy());
        poly.clear();
        poly.setErrorCalculation(true);
        this.locCoords.setShape(ctr.getShape());
        poly.setShape(ctr.getShape());
        int limitAc = this.mt.PRECISION - ray.getScale() - 2;
        int maxAc = Math.min(ray.getAccuracy(), limitAc);
        if (maxAc < limitAc) {
            if (Globals.LOG_VERBOSE) {
                Log.getIstc().log("ReflectionEngine: Warning: Ray accuracy " + maxAc);
                Log.getIstc().logln(" is lower than max accuracy " + limitAc);
            }
            if (maxAc < this.iniAc * this.incAc) {
                Log.getIstc().log("ReflectionEngine: Error: ");
                Log.getIstc().logln("Minimum ray accuracy must be " + this.iniAc * this.incAc);
            }
        }
        boolean cvrgc = true;
        ShapeContainer.LocalReflIter iter = new ShapeContainer.LocalReflIter(ctr);
        int[] levelAcs = this.getLevelAccuracies(maxAc);
        int level = 0;
        do {
            boolean outsideShape;
            Ray<T> calcRay = new Ray<T>(ray, levelAcs[level] + ray.getScale() + 2, this.mt.util);
            iter.dispose();
            iter.init(calcRay, false);
            boolean bl = outsideShape = poly.size() > 0 || !iter.isStartingInShape();
            if (level == 0) {
                Ray locInRay = new Ray(iter.getInitRay(), -1, this.mt.util);
                if (this.outputType == 1) {
                    poly.setInRay(calcRay);
                } else {
                    poly.setInRay(locInRay);
                }
                this.locCoords.setInRay(locInRay);
            }
            if (!outsideShape) {
                cvrgc = false;
                poly.setObfuscated(true);
                break;
            }
            if (!iter.hasNext()) break;
            cvrgc = this.calcReflPts(ctr, poly, cb, levelAcs[level], level == levelAcs.length - 1, iter);
        } while ((this.calc || poly.size() == 0) && !cvrgc && (level = (int)((byte)(level + 1))) < levelAcs.length);
        if (this.calc && cvrgc) {
            Ray reflRay = iter.getReflRay();
            Ray r = new Ray(reflRay, poly.getAccuracy(), this.mt.util);
            if (this.outputType == 1) {
                ctr.local2WorldPoint(reflRay.getStart(), r.getStart());
                ctr.local2WorldVec(reflRay.getDir(), r.getDir());
            }
            poly.setOutRay(r);
        }
        if (Globals.LOG_VERBOSE) {
            String state = poly.getDigitLossQuality() ? "ok" : "only min";
            String msg = "ReflectionEngine: Finished calculation\n  max digit loss: " + poly.getDigitLossHigh() + "\n  min digit loss: " + poly.getDigitLossLow() + "\n  digit loss calculation: " + state;
            Log.getIstc().logln(msg);
        }
        iter.dispose();
        return cvrgc;
    }

    private boolean calcReflPts(ShapeContainer<T> ctr, RayPolygon<T> poly, ICallback cb, int ac, boolean last, ShapeContainer.LocalReflIter it) {
        boolean cvrgc;
        boolean bl = cvrgc = this.tmpCoords.size() != 0;
        if (cvrgc) {
            this.locCoords.removeRange(poly.size(), this.locCoords.size());
        }
        int reqAc = poly.getAccuracy();
        int stAc = it.getInitRay().getAccuracy();
        int k = 0;
        while ((this.calc || ac <= this.iniAc * this.incAc) && it.hasNext() && (float)stAc - this.locCoords.getDigitLossLow() > (float)reqAc) {
            it.next((Number[])this.reflPt);
            if (k >= poly.size()) {
                this.mt.util.round(this.reflPt, poly.getAccuracy());
                if (cvrgc &= this.tmpCoords.size() != 0) {
                    Number[] pt = (Number[])this.tmpCoords.remove(0);
                    boolean bl2 = cvrgc = this.mt.cmp(pt[0], (Number)this.reflPt[0]) == 0 && this.mt.cmp(pt[1], (Number)this.reflPt[1]) == 0;
                    if (!cvrgc) {
                        this.tmpCoords.clear();
                        if (last) break;
                        ReflectionEngine.callback(cb);
                    }
                }
                if (cvrgc) {
                    if (this.outputType == 1) {
                        ctr.local2WorldPoint((Number[])this.reflPt, (Number[])this.outputPt);
                    } else {
                        this.mt.util.copy((Number[])this.reflPt, (Number[])this.outputPt);
                    }
                    ((ArrayList)poly).add((Number[])this.outputPt.clone());
                } else {
                    this.tmpCoords.add((T[])this.reflPt.clone());
                }
                ((ArrayList)this.locCoords).add((Number[])this.reflPt.clone());
                it.setAccuracy((int)Math.ceil((float)stAc - this.locCoords.getDigitLossLow()));
            } else {
                it.setAccuracy((int)Math.ceil((float)stAc - this.locCoords.getDigitLossLow(k)));
            }
            ++k;
        }
        if (Globals.LOG_VERBOSE) {
            String msg = "ReflectionEngine:\n  accuracy: " + stAc + "\n  verified points: " + poly.size() + "\n  cached points: " + this.tmpCoords.size() + "\n  max digit loss: " + this.locCoords.getDigitLossHigh() + "\n  min digit loss: " + this.locCoords.getDigitLossLow();
            Log.getIstc().logln(msg);
        }
        return cvrgc;
    }

    public synchronized boolean calcStatic(Ray<T> ray, ShapeContainer<T> ctr, RayPolygon<T> poly, ICallback cb) {
        boolean cvrgc;
        poly.clear();
        poly.setErrorCalculation(true);
        poly.setShape(ctr.getShape());
        ShapeContainer.LocalReflIter iter = new ShapeContainer.LocalReflIter(ctr);
        iter.init(ray, false);
        Ray locInRay = new Ray(iter.getInitRay(), -1, this.mt.util);
        if (this.outputType == 1) {
            poly.setInRay(ray);
        } else {
            poly.setInRay(locInRay);
        }
        boolean bl = cvrgc = !iter.isStartingInShape();
        if (cvrgc) {
            int stAc = ray.getAccuracy();
            int reqAc = poly.getAccuracy();
            while (!(cvrgc = !iter.hasNext()) && (this.calc || poly.size() == 0) && (float)stAc - poly.getDigitLossHigh() > (float)(reqAc + 2)) {
                iter.next((Number[])this.reflPt);
                this.mt.util.round(this.reflPt, reqAc + 2);
                if (this.outputType == 1) {
                    ctr.local2WorldPoint((Number[])this.reflPt, (Number[])this.outputPt);
                } else {
                    this.mt.util.copy((Number[])this.reflPt, (Number[])this.outputPt);
                }
                ((ArrayList)poly).add((Number[])this.outputPt.clone());
                iter.setAccuracy((int)Math.ceil((float)stAc - poly.getDigitLossLow()));
                if (poly.size() % 25 != 0) continue;
                ReflectionEngine.callback(cb);
            }
            if (cvrgc) {
                Ray reflRay = iter.getReflRay();
                Ray r = new Ray(reflRay, poly.getAccuracy(), this.mt.util);
                if (this.outputType == 1) {
                    ctr.local2WorldPoint(reflRay.getStart(), r.getStart());
                    ctr.local2WorldVec(reflRay.getDir(), r.getDir());
                }
                poly.setOutRay(r);
            } else {
                poly.removeLast();
                poly.removeLast();
            }
        } else {
            poly.setObfuscated(true);
        }
        if (Globals.LOG_VERBOSE) {
            String state = poly.getDigitLossQuality() ? "ok" : "only min";
            String msg = "ReflectionEngine: Finished calculation\n  max digit loss: " + poly.getDigitLossHigh() + "\n  min digit loss: " + poly.getDigitLossLow() + "\n  digit loss calculation: " + state;
            Log.getIstc().logln(msg);
        }
        iter.dispose();
        return cvrgc;
    }

    private int[] getLevelAccuracies(int maxAccu) {
        float tmp = (float)(Math.log10((double)maxAccu * 1.0 / (double)this.iniAc) / Math.log10(this.incAc));
        int levels = Math.round(tmp) + 2;
        int[] retVal = new int[levels];
        int j = 0;
        int ac = this.iniAc;
        while (j < retVal.length) {
            if (j == retVal.length - 2) {
                retVal[j] = ac - 2 * j++;
            }
            retVal[j] = ac;
            ++j;
            ac *= this.incAc;
        }
        return retVal;
    }

    private static void callback(ICallback cb) {
        if (cb != null) {
            cb.call();
        }
    }

    public void setStopped(boolean b) {
        this.calc = !b;
    }

    public void setOutputType(byte ot) {
        this.outputType = ot;
    }
}

