/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import common.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import lattice.Circle;
import lattice.IBox;
import lattice.IShape;
import lattice.Ray;
import math.Util;
import math.VecMath;

public final class RayPolygon<T extends Number>
extends ArrayList<T[]> {
    private final Util<T> util;
    private final double sqrt_8 = Math.sqrt(8.0);
    private String description;
    private Ray<T> inRay;
    private Ray<T> outRay;
    private IShape<T> shape;
    private final ArrayList<Float> digitLossHigh;
    private final ArrayList<Float> digitLossLow;
    private int accuracy;
    private double qualityBound;
    private boolean digitLossQuality;
    private boolean calcDigitLoss;
    private boolean obfuscated;
    private final float[] tmpPoint;
    private float[] coords;
    private float[] inStart;
    private float[] inDir;
    private float[] outStart;
    private float[] outDir;
    private int size;

    public RayPolygon(Util<T> util, int accuracy) {
        this.util = util;
        this.calcDigitLoss = true;
        this.digitLossHigh = new ArrayList();
        this.digitLossLow = new ArrayList();
        this.coords = new float[100];
        this.tmpPoint = new float[2];
        this.size = 0;
        this.setAccuracy(accuracy);
    }

    public void setAccuracy(int a) {
        this.accuracy = a;
        this.qualityBound = Math.pow(10.0, -Math.min(this.accuracy - 1, 15));
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean add(T[] pt) {
        boolean b = super.add(pt);
        if (this.outRay == null) {
            this.incDigitLoss();
        } else if (this.calcDigitLoss) {
            this.rebuild();
        }
        return b;
    }

    public void setInRay(Ray<T> in) {
        this.inRay = in;
        if (this.digitLossLow.size() > 0) {
            this.rebuild();
        }
    }

    public void setOutRay(Ray<T> out) {
        if (this.outRay != null && this.calcDigitLoss) {
            this.digitLossLow.remove(this.digitLossLow.size() - 1);
            this.digitLossHigh.remove(this.digitLossHigh.size() - 1);
        }
        this.outRay = out;
        if (this.outRay != null) {
            this.incDigitLoss();
        }
    }

    @Override
    public synchronized void clear() {
        this.inRay = null;
        this.outRay = null;
        this.digitLossHigh.clear();
        this.digitLossLow.clear();
        this.digitLossQuality = true;
        this.obfuscated = false;
        super.clear();
    }

    @Override
    public void add(int pos, T[] pt) {
        super.add(pos, pt);
        if (this.calcDigitLoss) {
            this.rebuild();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T[]> pts) {
        boolean b = true;
        if (this.outRay != null) {
            b = super.addAll(pts);
            if (this.calcDigitLoss) {
                this.rebuild();
            }
        } else {
            Iterator<? extends T[]> iter = pts.iterator();
            while (iter.hasNext()) {
                b &= ((ArrayList)this).add((Number[])iter.next());
            }
        }
        return b;
    }

    @Override
    public synchronized T[] remove(int pos) {
        Number[] retVal = (Number[])super.remove(pos);
        if (this.calcDigitLoss) {
            this.rebuild();
        }
        return retVal;
    }

    @Override
    public synchronized void removeLast() {
        if (this.size() > 0) {
            super.remove(this.size() - 1);
            if (this.calcDigitLoss) {
                if (this.outRay == null) {
                    this.digitLossHigh.remove(this.digitLossHigh.size() - 1);
                    this.digitLossLow.remove(this.digitLossLow.size() - 1);
                } else {
                    this.rebuild();
                }
            }
        }
    }

    @Override
    public synchronized boolean remove(Object arg0) {
        Exception e = new Exception("Error: RayPolygon.remove(Object) not supported");
        e.fillInStackTrace();
        Log.getIstc().logln(e.getMessage());
        return false;
    }

    @Override
    public synchronized void removeRange(int pos1, int pos2) {
        boolean end = pos2 >= this.size();
        super.removeRange(pos1, pos2);
        if (this.calcDigitLoss) {
            if (end && this.outRay == null) {
                for (int i = pos2 - 1; i >= pos1; --i) {
                    this.digitLossLow.remove(i);
                    this.digitLossHigh.remove(i);
                }
            } else {
                this.rebuild();
            }
        }
    }

    private void rebuild() {
        ArrayList<T[]> pts = new ArrayList<T[]>(this);
        Ray<T> ray1 = this.inRay;
        Ray<T> ray2 = this.outRay;
        this.clear();
        this.setInRay(ray1);
        Iterator<T[]> iter = pts.iterator();
        while (iter.hasNext()) {
            ((ArrayList)this).add((Number[])iter.next());
        }
        this.setOutRay(ray2);
    }

    public Ray<T> getInRay() {
        return this.inRay;
    }

    public Ray<T> getOutRay() {
        return this.outRay;
    }

    public void setShape(IShape<T> s) {
        this.shape = s;
    }

    public float getDigitLossHigh() {
        return this.digitLossHigh.size() > 0 ? this.getDigitLossHigh(this.digitLossHigh.size() - 1) : 0.0f;
    }

    public float getDigitLossLow() {
        return this.digitLossLow.size() > 0 ? this.getDigitLossLow(this.digitLossLow.size() - 1) : 0.0f;
    }

    public float getDigitLossHigh(int pos) {
        return this.digitLossHigh.get(pos).floatValue();
    }

    public float getDigitLossLow(int pos) {
        return this.digitLossLow.get(pos).floatValue();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setErrorCalculation(boolean b) {
        this.calcDigitLoss = b;
    }

    public boolean getDigitLossQuality() {
        return this.digitLossQuality;
    }

    public void setObfuscated(boolean b) {
        this.obfuscated = b;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public synchronized float calcLength(IBox<Float> fbox, IConverter<T, Float> cv, VecMath<Float> fmath) {
        float retVal = 0.0f;
        float length = fbox.getLength((byte)0).floatValue();
        if (!this.obfuscated && this.getInRay() != null) {
            Number[] p1;
            float[] crds = this.util.cast2floatArray(this);
            for (int i = 1; i < crds.length / 2; ++i) {
                float dx = crds[2 * i] - crds[2 * (i - 1)];
                float dy = crds[2 * i + 1] - crds[2 * (i - 1) + 1];
                retVal = (float)((double)retVal + Math.sqrt(dx * dx + dy * dy));
            }
            Ray<Float> r = this.getInRay().convert(cv, fmath.util);
            if (fbox.intersect(r, p1 = new Float[2])) {
                Number[] p2 = new Float[2];
                if (this.size() == 0) {
                    if (fbox.location(r.getStart()) == 2) {
                        fmath.diff(p1, r.getStart(), p2);
                    } else {
                        Number[] st = (Float[])r.getStart();
                        fmath.scaleAdd(st, Float.valueOf(2.0f * length), r.getDir(), st);
                        fmath.neg((Float)r.getDir());
                        fbox.intersect(r, p2);
                        fmath.diff(p1, p2, p2);
                    }
                } else {
                    if (this.getOutRay() != null) {
                        r = this.getOutRay().convert(cv, fmath.util);
                        fbox.intersect(r, p2);
                        int l = this.size() - 1;
                        fmath.diff(this.util.cast2FloatArray((Number[])this.get(l)), p2, p2);
                        retVal += ((Float)fmath.norm(p2)).floatValue();
                    }
                    fmath.diff(this.util.cast2FloatArray((Number[])this.get(0)), p1, p2);
                }
                retVal += ((Float)fmath.norm(p2)).floatValue();
            }
        }
        return retVal / length;
    }

    public int countRays() {
        int cnt = this.inRay != null ? 1 : 0;
        return (cnt += this.outRay != null ? 1 : 0) + Math.max(2 * this.size() / 2 - 1, 0);
    }

    public synchronized int countLoops() {
        int loops = 0;
        if (this.inRay != null) {
            float[] st1 = this.util.cast2floatArray(this.inRay.getStart());
            float[] dir1 = this.util.cast2floatArray(this.inRay.getDir());
            float[] st2 = null;
            float[] dir2 = null;
            if (this.outRay != null) {
                st2 = this.util.cast2floatArray(this.outRay.getStart());
                dir2 = this.util.cast2floatArray(this.outRay.getDir());
            }
            loops = this.countLoops(st1, dir1, this.util.cast2floatArray(this), st2, dir2);
        }
        return loops;
    }

    private void incDigitLoss() {
        if (this.calcDigitLoss) {
            if (this.shape instanceof Circle) {
                this.incDigitLossUseCircle(((Number)this.shape.getSize()).doubleValue());
            } else {
                String n = this.shape.getClass().getName();
                Log.getIstc().logln("No method to calculate errors for " + n);
            }
        }
    }

    private void incDigitLossUseCircle(double r) {
        int i;
        double[] dirVec1 = new double[2];
        double[] dirVec2 = new double[2];
        int n = i = this.outRay == null ? this.size() - 2 : this.size() - 1;
        if (i > 0 || i == 0 && this.inRay != null) {
            double l2;
            double l1;
            if (i > 0) {
                dirVec1[0] = ((Number[])this.get(i - 1))[0].doubleValue() - ((Number[])this.get(i))[0].doubleValue();
                dirVec1[1] = ((Number[])this.get(i - 1))[1].doubleValue() - ((Number[])this.get(i))[1].doubleValue();
                l1 = Math.sqrt(dirVec1[0] * dirVec1[0] + dirVec1[1] * dirVec1[1]);
                double inv_l1 = 1.0 / l1;
                dirVec1[0] = dirVec1[0] * inv_l1;
                dirVec1[1] = dirVec1[1] * inv_l1;
            } else {
                l1 = 1.0;
                dirVec1[0] = -this.getInRay().getDir()[0].doubleValue();
                dirVec1[1] = -this.getInRay().getDir()[1].doubleValue();
            }
            if (i == this.size() - 2) {
                dirVec2[0] = ((Number[])this.get(i + 1))[0].doubleValue() - ((Number[])this.get(i))[0].doubleValue();
                dirVec2[1] = ((Number[])this.get(i + 1))[1].doubleValue() - ((Number[])this.get(i))[1].doubleValue();
                l2 = Math.sqrt(dirVec2[0] * dirVec2[0] + dirVec2[1] * dirVec2[1]);
                double inv_l2 = 1.0 / l2;
                dirVec2[0] = dirVec2[0] * inv_l2;
                dirVec2[1] = dirVec2[1] * inv_l2;
            } else {
                l2 = 1000000.0;
                dirVec2[0] = this.outRay.getDir()[0].doubleValue();
                dirVec2[1] = this.outRay.getDir()[1].doubleValue();
            }
            double dot = dirVec1[0] * dirVec2[0] + dirVec1[1] * dirVec2[1];
            if (dot + 1.0 < this.qualityBound) {
                dot = this.qualityBound - 1.0;
                this.digitLossQuality = false;
            }
            double tmp = this.sqrt_8 * l1 / (r * Math.sqrt(1.0 + dot));
            int lastPos = this.digitLossHigh.size() - 1;
            float dlHigh = this.digitLossHigh.get(lastPos).floatValue();
            float dlLow = this.digitLossLow.get(lastPos).floatValue();
            this.digitLossHigh.add(Float.valueOf(dlHigh + (float)Math.log10((l1 + l2) / l2 + tmp)));
            this.digitLossLow.add(Float.valueOf(dlLow + (float)Math.log10(1.0 + tmp)));
        } else {
            this.digitLossHigh.add(Float.valueOf(0.0f));
            this.digitLossLow.add(Float.valueOf(0.0f));
        }
    }

    private int countLoops(float[] st1, float[] dir1, float[] crds, float[] st2, float[] dir2) {
        int cnt = 0;
        if (crds.length > 2) {
            this.init(st1, dir1, crds, st2, dir2);
            for (int i = 1; i < this.size / 2 - 1; ++i) {
                float[] pt = null;
                for (int k = i - 2; k >= 0; --k) {
                    pt = this.intersect(2 * k, 2 * i);
                    if (pt == null) continue;
                    ++cnt;
                    this.insertAndRemove(2 * (k + 1), 2 * i, pt);
                    i = k;
                    break;
                }
                if (pt != null || (pt = this.intersect(this.inStart, this.inDir, 2 * i)) == null) continue;
                ++cnt;
                this.insertAndRemove(0, 2 * i, pt);
                i = 0;
            }
            if (this.outStart != null) {
                for (int k = this.size / 2 - 3; k >= 0; --k) {
                    float[] pt = this.intersect(2 * k, this.outStart, this.outDir);
                    if (pt == null) continue;
                    ++cnt;
                }
                float[] pt = this.intersect(this.inStart, this.inDir, this.outStart, this.outDir);
                if (pt != null) {
                    ++cnt;
                }
            }
        }
        return cnt;
    }

    private void init(float[] st1, float[] dir1, float[] crds, float[] st2, float[] dir2) {
        this.coords = crds;
        this.size = crds.length;
        if (this.size > 0) {
            if (this.inStart == null) {
                this.inStart = new float[2];
            }
            this.inStart[0] = this.coords[0];
            this.inStart[1] = this.coords[1];
            if (this.inDir == null) {
                this.inDir = new float[2];
            }
            this.inDir[0] = -dir1[0];
            this.inDir[1] = -dir1[1];
        } else {
            this.inStart = st1;
            this.inDir = dir1;
        }
        this.outStart = st2;
        this.outDir = dir2;
    }

    private float[] intersect(int idx1, int idx2) {
        float dir1X = this.coords[idx1 + 2] - this.coords[idx1];
        float dir1Y = this.coords[idx1 + 3] - this.coords[idx1 + 1];
        if (dir1X != 0.0f || dir1Y != 0.0f) {
            float dot;
            float norDir1X = -dir1Y;
            float norDir1Y = dir1X;
            float dir2X = this.coords[idx2 + 2] - this.coords[idx2];
            float dir2Y = this.coords[idx2 + 3] - this.coords[idx2 + 1];
            if ((dir2X != 0.0f || dir2Y != 0.0f) && (dot = norDir1X * dir2X + norDir1Y * dir2Y) != 0.0f) {
                float t2 = (this.coords[idx1] - this.coords[idx2]) * norDir1X;
                t2 += (this.coords[idx1 + 1] - this.coords[idx2 + 1]) * norDir1Y;
                if ((t2 /= dot) >= 0.0f && t2 < 1.0f) {
                    this.tmpPoint[0] = this.coords[idx2] + t2 * dir2X;
                    this.tmpPoint[1] = this.coords[idx2 + 1] + t2 * dir2Y;
                    float t1 = (this.tmpPoint[0] - this.coords[idx1]) * dir1X;
                    if ((t1 += (this.tmpPoint[1] - this.coords[idx1 + 1]) * dir1Y) > 0.0f && t1 <= RayPolygon.sqNorm(dir1X, dir1Y)) {
                        return this.tmpPoint;
                    }
                }
            }
        }
        return null;
    }

    private float[] intersect(float[] st1, float[] dir1, float[] st2, float[] dir2) {
        float dot = -dir1[1] * dir2[0];
        if ((dot += dir1[0] * dir2[1]) != 0.0f) {
            float t2 = (st1[0] - st2[0]) * -dir1[1];
            t2 += (st1[1] - st2[1]) * dir1[0];
            if ((t2 /= dot) >= 0.0f) {
                this.tmpPoint[0] = st2[0] + t2 * dir2[0];
                this.tmpPoint[1] = st2[1] + t2 * dir2[1];
                float t1 = (this.tmpPoint[0] - st1[0]) * dir1[0];
                if ((t1 += (this.tmpPoint[1] - st1[1]) * dir1[1]) >= 0.0f) {
                    return this.tmpPoint;
                }
            }
        }
        return null;
    }

    private float[] intersect(float[] st, float[] dir, int idx) {
        float dot;
        float dir2X = this.coords[idx + 2] - this.coords[idx];
        float dir2Y = this.coords[idx + 3] - this.coords[idx + 1];
        if ((dir2X != 0.0f || dir2Y != 0.0f) && (dot = -dir[1] * dir2X + dir[0] * dir2Y) != 0.0f) {
            float t2 = (st[0] - this.coords[idx]) * -dir[1];
            t2 += (st[1] - this.coords[idx + 1]) * dir[0];
            if ((t2 /= dot) >= 0.0f && t2 < 1.0f) {
                this.tmpPoint[0] = this.coords[idx] + t2 * dir2X;
                this.tmpPoint[1] = this.coords[idx + 1] + t2 * dir2Y;
                float t1 = (this.tmpPoint[0] - st[0]) * dir[0];
                if ((t1 += (this.tmpPoint[1] - st[1]) * dir[1]) >= 0.0f) {
                    return this.tmpPoint;
                }
            }
        }
        return null;
    }

    private float[] intersect(int idx, float[] st, float[] dir) {
        float dot;
        float dir1X = this.coords[idx + 2] - this.coords[idx];
        float dir1Y = this.coords[idx + 3] - this.coords[idx + 1];
        if ((dir1X != 0.0f || dir1Y != 0.0f) && (dot = -dir1Y * dir[0] + dir1X * dir[1]) != 0.0f) {
            float t2 = (this.coords[idx] - st[0]) * -dir1Y;
            t2 += (this.coords[idx + 1] - st[1]) * dir1X;
            if ((t2 /= dot) >= 0.0f) {
                this.tmpPoint[0] = st[0] + t2 * dir[0];
                this.tmpPoint[1] = st[1] + t2 * dir[1];
                float t1 = (this.tmpPoint[0] - this.coords[idx]) * dir1X;
                if ((t1 += (this.tmpPoint[1] - this.coords[idx + 1]) * dir1Y) > 0.0f && t1 <= RayPolygon.sqNorm(dir1X, dir1Y)) {
                    return this.tmpPoint;
                }
            }
        }
        return null;
    }

    private static float sqNorm(float c1, float c2) {
        return c1 * c1 + c2 * c2;
    }

    private void insertAndRemove(int i1, int i2, float[] pt) {
        if (i1 == 0) {
            this.inStart[0] = pt[0];
            this.inStart[1] = pt[1];
        }
        this.coords[i1] = pt[0];
        this.coords[i1 + 1] = pt[1];
        System.arraycopy(this.coords, i2 + 2, this.coords, i1 + 2, this.size - i2 - 2);
        this.size -= i2 - i1;
    }
}

