/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import common.Log;
import math.Util;
import math.VecMath;

public final class Ray<T extends Number> {
    private T[] start;
    private T[] dir;
    private final Util<T> util;
    private Object attr;

    public Ray(T[] start, T[] dir, Util<T> util) {
        this.start = start;
        this.dir = dir;
        this.util = util;
        this.checkDirNorm();
    }

    public Ray(Ray<T> r, int p, Util<T> util) {
        this.start = (Number[])r.getStart().clone();
        this.dir = (Number[])r.getDir().clone();
        this.util = util;
        if (p != -1) {
            this.setPrecision(p);
        }
        this.checkDirNorm();
    }

    public Ray(Util<T> util) {
        this.util = util;
    }

    public T[] getDir() {
        return this.dir;
    }

    public T[] getStart() {
        return this.start;
    }

    public void setStart(T[] start) {
        this.start = start;
    }

    public void copy(Ray<T> r) {
        this.start = r.start != null ? (Number[])r.start.clone() : null;
        this.dir = r.dir != null ? (Number[])r.dir.clone() : null;
    }

    public void setPrecision(int p) {
        for (int i = 0; i < this.start.length; ++i) {
            if (this.start[i] != null) {
                this.start[i] = this.util.copy(this.start[i], p);
            }
            if (this.dir[i] == null) continue;
            this.dir[i] = this.util.copy(this.dir[i], p);
        }
    }

    public void getPoint(T param, T[] retVal, VecMath<T> math) {
        math.scaleAdd((Number[])this.start, (Number)param, (Number[])this.dir, (Number[])retVal);
    }

    private void checkDirNorm() {
        float dirNormSq = 0.0f;
        for (int i = 0; i < this.dir.length; ++i) {
            if (this.dir[i] == null) {
                return;
            }
            dirNormSq += ((Number)this.dir[i]).floatValue() * ((Number)this.dir[i]).floatValue();
        }
        if (Math.abs(dirNormSq - 1.0f) > 1.0E-5f) {
            Log.getIstc().logln("ERROR: Dir vector of ray not normalized");
        }
    }

    public String toString() {
        String s = "Ray:\n";
        s = s + "start 0:" + this.start[0] + "\n";
        s = s + "start 1:" + this.start[1] + "\n";
        s = s + "dir 0:" + this.dir[0] + "\n";
        s = s + "dir 1:" + this.dir[1] + "\n";
        return s;
    }

    public int getScale() {
        int es0 = this.util.getScale(this.start[0]);
        int es1 = this.util.getScale(this.start[1]);
        int es2 = this.util.getScale(this.dir[0]);
        int es3 = this.util.getScale(this.dir[1]);
        return Math.max(Math.max(es0, es1), Math.max(es2, es3));
    }

    public int getAccuracy() {
        int es0 = this.util.getErrorScale(this.start[0]);
        int es1 = this.util.getErrorScale(this.start[1]);
        int es2 = this.util.getErrorScale(this.dir[0]);
        int es3 = this.util.getErrorScale(this.dir[1]);
        return -Math.max(Math.max(es0, es1), Math.max(es2, es3)) - 1;
    }

    public void incPrecision(int p) {
        for (int i = 0; i < this.start.length; ++i) {
            int p0;
            if (this.start[i] != null && (p0 = this.util.precision(this.start[i])) < Integer.MAX_VALUE - p) {
                this.start[i] = this.util.copy(this.start[i], p0 + p);
            }
            if (this.dir[i] == null || (p0 = this.util.precision(this.dir[i])) >= Integer.MAX_VALUE - p) continue;
            this.dir[i] = this.util.copy(this.dir[i], p0 + p);
        }
    }

    public <S extends Number> Ray<S> convert(IConverter<T, S> c, Util<S> ut) {
        return new Ray(c.convert((T[][])this.start), c.convert((T[][])this.dir), ut);
    }

    public void setAttribute(Object o) {
        this.attr = o;
    }

    public Object getAttribute() {
        return this.attr;
    }
}

