/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lattice.Box2D;
import lattice.BoxAdapter;
import lattice.IBox;
import lattice.Ray;
import math.Util;
import math.VecMath;

public class Lattice<T extends Number>
extends BoxAdapter<T> {
    private final LinkedList<IBox<T>> tempCells;
    private short points;
    private T gap;
    private T invGap;
    private T[][] localCellCenters;
    private T[][] localCellCorners;
    protected final byte dim;
    protected final VecMath<T> math;
    protected final Util<T> util;

    public Lattice(T[] p, short sidePoints, T gap, VecMath<T> math) {
        this.math = math;
        this.util = math.util;
        T sideLength = math.mul(gap, sidePoints - 1);
        this.box = new Box2D(p, sideLength, math);
        this.points = sidePoints;
        this.gap = gap;
        this.invGap = math.inv(gap);
        this.tempCells = new LinkedList();
        this.dim = (byte)p.length;
        this.init();
    }

    protected Lattice(IBox<T> box, short sidePoints, T gap, VecMath<T> math) {
        this.math = math;
        this.util = math.util;
        this.box = box;
        this.points = sidePoints;
        this.gap = gap;
        this.invGap = math.inv(gap);
        this.tempCells = new LinkedList();
        this.dim = (byte)box.getCorner().length;
        this.init();
    }

    private void init() {
        this.localCellCenters = this.util.array((short)Math.round(Math.pow(this.points - 1, this.dim)), this.dim);
        this.localCellCorners = this.util.array((short)Math.round(Math.pow(this.points - 1, this.dim)), this.dim);
        IndexIterator idxIter = new IndexIterator();
        Number[] diagHalf = (Number[])this.math.getDiagHalf(this.dim).clone();
        this.math.scale((Number)this.gap, diagHalf);
        while (idxIter.hasNext()) {
            short[] idxs = idxIter.next();
            short idx = this.getTableIndex(idxs);
            this.localCellCorners[idx] = this.util.array(this.dim);
            this.math.linBaseComb(idxs, this.math.getBase(this.dim), (Number[])this.localCellCorners[idx]);
            this.math.scale((Number)this.gap, (Number[])this.localCellCorners[idx]);
            this.localCellCenters[idx] = this.util.array(this.dim);
            this.math.add((Number[])this.localCellCorners[idx], diagHalf, (Number[])this.localCellCenters[idx]);
        }
    }

    private short getTableIndex(short[] idxs) {
        short idx = 0;
        for (int i = 0; i < idxs.length; ++i) {
            idx = (short)((long)idx + (long)idxs[i] * Math.round(Math.pow(this.points - 1, i)));
        }
        return idx;
    }

    private void getIndex(T[] localPoint, short[] idxVec) {
        for (int i = 0; i < idxVec.length; ++i) {
            idxVec[i] = ((Number)this.math.mul(localPoint[i], this.invGap)).shortValue();
            idxVec[i] = idxVec[i] < 0 ? (short)0 : (short)Math.min(idxVec[i], this.points - 2);
        }
    }

    public void intersect(Ray<T> ray, List<T[]> pts) {
        LocalCellIterator iter = new LocalCellIterator();
        iter.init(ray, null);
        while (iter.hasNext()) {
            Number[] tmp = this.util.array(this.dim);
            this.local2WorldPoint((Number[])iter.next(), tmp);
            pts.add(tmp);
        }
    }

    public boolean getCellCenter(short[] idxs, T[] cellCtr) {
        if (this.checkRange(idxs)) {
            short[] dIdxs = new short[idxs.length];
            for (int i = 0; i < dIdxs.length; i = (int)((byte)(i + 1))) {
                dIdxs[i] = 1;
            }
            this.math.linBaseComb(dIdxs, this.getBaseVectors(), (Number[])cellCtr);
            this.math.scale((Number)this.math.ONE_OVER_TWO, (Number[])cellCtr);
            this.math.linBaseCombAdd(idxs, this.getBaseVectors(), (Number[])cellCtr);
            this.math.scaleAdd(this.getCorner(), (Number)this.gap, (Number[])cellCtr, (Number[])cellCtr);
            return true;
        }
        return false;
    }

    protected void getCellCenterLocal(short[] idxs, T[] cellCtr) {
        this.util.copy((Number[])this.localCellCenters[this.getTableIndex(idxs)], (Number[])cellCtr);
    }

    public void getCellCenter(T[] worldPoint, T[] cellCtr) {
        short[] idxs = new short[this.dim];
        this.world2LocalPoint((Number[])worldPoint, (Number[])cellCtr);
        this.getIndex((Number[])cellCtr, idxs);
        this.getCellCenter(idxs, (Number[])cellCtr);
    }

    protected void getCellCenterLocal(T[] localPoint, T[] cellCtr) {
        short[] idxs = new short[this.dim];
        this.getIndex((Number[])localPoint, idxs);
        this.getCellCenterLocal(idxs, (Number[])cellCtr);
    }

    public short getPoints() {
        return this.points;
    }

    public void setPoints(short pts) {
        this.points = pts;
        this.tempCells.clear();
        this.init();
    }

    public T getGap() {
        return this.gap;
    }

    public void setGap(T gp) {
        this.gap = gp;
        this.invGap = this.math.inv(this.gap);
        this.tempCells.clear();
        this.init();
    }

    public void setBound(IBox<T> box) {
        this.box = box;
        this.tempCells.clear();
    }

    private boolean checkRange(short[] idxs) {
        for (int i = 0; i < idxs.length; ++i) {
            if (0 <= idxs[i] && this.points - 1 > idxs[i]) continue;
            return false;
        }
        return true;
    }

    final boolean calcStartCellIndex(Ray<T> localRay, short[] idxs, T[] tmp) {
        boolean ret = true;
        if (this.containsLocal(localRay.getStart())) {
            this.getIndex(localRay.getStart(), idxs);
        } else {
            ret = this.localIntersect(localRay, (Number[])tmp);
            if (ret) {
                this.getIndex((Number[])tmp, idxs);
            }
        }
        return ret;
    }

    final boolean calcNextCellIndex(Ray<T> locRay, short[] idxs, T[] tmp) {
        short[] diagIdxs = (short[])idxs.clone();
        IBox<T> tmpCell = this.pollTmpCell();
        for (int steps = 0; steps < this.dim - 1; ++steps) {
            for (byte j = 0; j < this.dim; j = (byte)(j + 1)) {
                short dIdx = (short)(this.math.cmp(locRay.getDir()[j], (Number)this.math.ZERO) < 0 ? -1 : 1);
                if (steps == 1) {
                    dIdx = -dIdx;
                }
                short[] tmpIdxs = (short[])idxs.clone();
                byte by = j;
                tmpIdxs[by] = (short)(tmpIdxs[by] + dIdx);
                if (this.checkRange(tmpIdxs)) {
                    this.getCellCenterLocal(tmpIdxs, (Number[])tmp);
                    this.math.diff((Number[])tmp, locRay.getStart(), (Number[])tmp);
                    Number t = this.math.dot((Number[])tmp, locRay.getDir());
                    this.math.scaleAdd(locRay.getStart(), t, locRay.getDir(), (Number[])tmp);
                    tmpCell.setCorner((Number[])this.localCellCorners[this.getTableIndex(tmpIdxs)]);
                    this.math.diff((Number[])tmp, tmpCell.getCorner(), (Number[])tmp);
                    if (tmpCell.containsLocal((Number[])tmp)) {
                        System.arraycopy(tmpIdxs, 0, idxs, 0, idxs.length);
                        this.pushTmpCell(tmpCell);
                        return true;
                    }
                }
                if (steps != 0) continue;
                byte by2 = j;
                diagIdxs[by2] = (short)(diagIdxs[by2] + dIdx);
            }
            System.arraycopy(diagIdxs, 0, idxs, 0, idxs.length);
        }
        this.pushTmpCell(tmpCell);
        return this.checkRange(idxs);
    }

    final boolean calcNextCellIndexDouble(Ray<T> locRay, short[] idxs, double[] tmp) {
        short[] diagIdxs = (short[])idxs.clone();
        IBox<T> tmpCell = this.pollTmpCell();
        for (int steps = 0; steps < this.dim - 1; ++steps) {
            for (byte j = 0; j < this.dim; j = (byte)(j + 1)) {
                short dIdx = (short)(this.math.cmp(locRay.getDir()[j], (Number)this.math.ZERO) < 0 ? -1 : 1);
                if (steps == 1) {
                    dIdx = -dIdx;
                }
                short[] tmpIdxs = (short[])idxs.clone();
                byte by = j;
                tmpIdxs[by] = (short)(tmpIdxs[by] + dIdx);
                if (this.checkRange(tmpIdxs)) {
                    int i;
                    T[] cellCtr = this.localCellCenters[this.getTableIndex(tmpIdxs)];
                    double[] start = this.math.util.cast2doubleArray(locRay.getStart());
                    double[] dir = this.math.util.cast2doubleArray(locRay.getDir());
                    for (int i2 = 0; i2 < this.dim; ++i2) {
                        tmp[i2] = ((Number)cellCtr[i2]).doubleValue() - start[i2];
                    }
                    double t = 0.0;
                    for (i = 0; i < this.dim; ++i) {
                        t += tmp[i] * dir[i];
                    }
                    for (i = 0; i < this.dim; ++i) {
                        tmp[i] = start[i] + t * dir[i];
                    }
                    tmpCell.setCorner((Number[])this.localCellCorners[this.getTableIndex(tmpIdxs)]);
                    for (i = 0; i < this.dim; ++i) {
                        tmp[i] = tmp[i] - tmpCell.getCorner()[i].doubleValue();
                    }
                    if (tmpCell.containsLocal(this.math.util.cast(tmp))) {
                        System.arraycopy(tmpIdxs, 0, idxs, 0, idxs.length);
                        this.pushTmpCell(tmpCell);
                        return true;
                    }
                }
                if (steps != 0) continue;
                byte by2 = j;
                diagIdxs[by2] = (short)(diagIdxs[by2] + dIdx);
            }
            System.arraycopy(diagIdxs, 0, idxs, 0, idxs.length);
        }
        this.pushTmpCell(tmpCell);
        return this.checkRange(idxs);
    }

    private IBox<T> pollTmpCell() {
        IBox<T> tmpCell;
        if (this.tempCells.size() > 0) {
            tmpCell = this.tempCells.pollFirst();
        } else {
            tmpCell = this.box.copy();
            tmpCell.setLength(this.gap);
        }
        return tmpCell;
    }

    private void pushTmpCell(IBox<T> b) {
        this.tempCells.add(b);
    }

    @Override
    public void rotate(T[] p, T[] ax, T phi) {
        super.rotate(p, ax, phi);
        this.tempCells.clear();
    }

    @Override
    public void rotate(T[] p, T[] ax, T sinphi, T cosphi) {
        super.rotate(p, ax, sinphi, cosphi);
        this.tempCells.clear();
    }

    @Override
    public <S extends Number> Lattice<S> convert(IConverter<T, S> cv, VecMath<S> smath) {
        IBox<S> sbox = super.convert(cv, smath);
        return new Lattice<S>(sbox, this.points, cv.convert(this.gap), smath);
    }

    protected final class LocalCellIterator
    implements Iterator<T[]> {
        private final short[] idxs;
        private final T[] tmp1;
        private final double[] tmp2;
        private short[] startIdx;
        private Ray<T> localRay;
        private Ray<T> lowPrecLocalRay;
        private boolean empty = false;
        private boolean next = false;
        private int marginScale = Integer.MIN_VALUE;
        private boolean useLowPrecRay = false;

        public LocalCellIterator() {
            this.tmp1 = Lattice.this.util.array(Lattice.this.dim);
            this.tmp2 = new double[Lattice.this.dim];
            this.idxs = new short[Lattice.this.dim];
        }

        @Override
        public boolean hasNext() {
            if (this.empty) {
                return false;
            }
            if (!this.next) {
                this.next = -this.marginScale > 10 ? Lattice.this.calcNextCellIndex(this.getCellFinderRay(), this.idxs, (Number[])this.tmp1) : Lattice.this.calcNextCellIndexDouble(this.getCellFinderRay(), this.idxs, this.tmp2);
                this.empty = !this.next;
            }
            return !this.empty;
        }

        public boolean init(Ray<T> ray, int mScale, short[] startCellIdx) {
            this.marginScale = mScale;
            return this.init(ray, startCellIdx);
        }

        public boolean init(Ray<T> ray, short[] startCellIdx) {
            if (this.localRay == null) {
                Number[] start = Lattice.this.util.array(Lattice.this.dim);
                Number[] dir = Lattice.this.util.array(Lattice.this.dim);
                this.localRay = new Ray(start, dir, Lattice.this.util);
            }
            Lattice.this.world2LocalPoint(ray.getStart(), this.localRay.getStart());
            Lattice.this.world2LocalVec(ray.getDir(), this.localRay.getDir());
            this.convert2LowPrecRay();
            this.empty = startCellIdx == null;
            if (!this.empty) {
                System.arraycopy(startCellIdx, 0, this.idxs, 0, this.idxs.length);
            } else {
                boolean bl = this.empty = !Lattice.this.calcStartCellIndex(this.getCellFinderRay(), this.idxs, (Number[])this.tmp1);
            }
            if (!this.empty) {
                this.next = true;
                this.startIdx = (short[])this.idxs.clone();
            }
            return !this.empty;
        }

        public short[] getStartCellIndex() {
            return this.startIdx;
        }

        private Ray<T> getCellFinderRay() {
            return this.useLowPrecRay ? this.lowPrecLocalRay : this.localRay;
        }

        private void convert2LowPrecRay() {
            if (this.marginScale >= -2147483637) {
                int prec = -this.marginScale + 10;
                boolean bl = this.useLowPrecRay = prec < Lattice.this.util.maxPrecision(this.localRay.getDir());
                if (this.useLowPrecRay) {
                    Number[] dir;
                    Number[] start;
                    if (this.lowPrecLocalRay == null) {
                        start = Lattice.this.util.array(Lattice.this.dim);
                        dir = Lattice.this.util.array(Lattice.this.dim);
                        this.lowPrecLocalRay = new Ray(start, dir, Lattice.this.util);
                    }
                    start = this.lowPrecLocalRay.getStart();
                    start[0] = Lattice.this.util.copy(this.localRay.getStart()[0], prec);
                    start[1] = Lattice.this.util.copy(this.localRay.getStart()[1], prec);
                    dir = this.lowPrecLocalRay.getDir();
                    dir[0] = Lattice.this.util.copy(this.localRay.getDir()[0], prec);
                    dir[1] = Lattice.this.util.copy(this.localRay.getDir()[1], prec);
                }
            }
        }

        @Override
        public T[] next() {
            Number[] pt = Lattice.this.util.array(Lattice.this.dim);
            boolean res = this.next(pt);
            if (!res) {
                pt = null;
            }
            return pt;
        }

        @Override
        public void remove() {
        }

        public void continueWithRay(Ray<T> locRay) {
            this.localRay = locRay;
            this.convert2LowPrecRay();
        }

        public Ray<T> getLocalRay() {
            return this.localRay;
        }

        public void setMarginScale(short masc) {
            this.marginScale = masc;
            this.convert2LowPrecRay();
        }

        public boolean next(T[] pt) {
            if (!this.empty && (this.next || this.hasNext())) {
                this.next = false;
                Lattice.this.getCellCenterLocal(this.idxs, (Number[])pt);
                return true;
            }
            return false;
        }

        public void replay() {
            this.next = true;
        }
    }

    protected class IndexIterator
    implements Iterator<short[]> {
        private short[] idxs;
        private short pts;

        public IndexIterator() {
            this.idxs = new short[Lattice.this.dim];
            this.idxs[0] = -1;
            this.pts = Lattice.this.points;
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.idxs.length; ++i) {
                if (this.idxs[i] >= this.pts - 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public short[] next() {
            if (this.hasNext()) {
                for (int i = 0; i < this.idxs.length; ++i) {
                    if (this.idxs[i] != this.pts - 2) {
                        int n = i;
                        this.idxs[n] = (short)(this.idxs[n] + 1);
                        break;
                    }
                    this.idxs[i] = 0;
                }
                return this.idxs;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

