/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import lattice.Ray;
import math.VecMath;

public interface IBox<T extends Number> {
    public boolean intersect(Ray<T> var1, T[] var2);

    public boolean localIntersect(Ray<T> var1, T[] var2);

    public byte location(T[] var1);

    public byte locationLocal(T[] var1);

    public boolean contains(T[] var1);

    public boolean containsLocal(T[] var1);

    public void constrainLocal(T[] var1, T[] var2);

    public void rotate(T[] var1, T[] var2, T var3);

    public void rotate(T[] var1, T[] var2, T var3, T var4);

    public void setCenter(T[] var1);

    public void setCorner(T[] var1);

    public void setLength(T var1);

    public void setLength(T var1, byte var2);

    public void setLengths(T[] var1);

    public T[] getLengths();

    public T getLength(byte var1);

    public T[] getCorner();

    public T[][] getSideVectors();

    public T[][] getBaseVectors();

    public IBox<T> copy();

    public void world2LocalPoint(T[] var1, T[] var2);

    public void local2WorldPoint(T[] var1, T[] var2);

    public void world2LocalVec(T[] var1, T[] var2);

    public void local2WorldVec(T[] var1, T[] var2);

    public <S extends Number> IBox<S> convert(IConverter<T, S> var1, VecMath<S> var2);
}

