/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import lattice.Box2D;
import lattice.Ray;
import math.VecMath;
import math.VecMathFloat;

public class EllipseFloat
extends Box2D<Float> {
    public EllipseFloat(Float[] p, Float length, VecMath<Float> math) {
        super((Number[])p, (Number)length, math);
    }

    public boolean containsLocal(Float[] pt) {
        float dy;
        if (!super.containsLocal((Number[])pt)) {
            return false;
        }
        float l1 = ((Float)this.getLength((byte)0)).floatValue() / 2.0f;
        float l2 = ((Float)this.getLength((byte)1)).floatValue() / 2.0f;
        float dx = pt[0].floatValue() - l1;
        return dx * dx / (l1 * l1) + (dy = pt[1].floatValue() - l2) * dy / (l2 * l2) <= 1.0f;
    }

    public boolean intersect(Ray<Float> ray, Float[] isct) {
        float l1 = ((Float)this.getLength((byte)0)).floatValue() / 2.0f;
        float l2 = ((Float)this.getLength((byte)1)).floatValue() / 2.0f;
        if (((Float[])ray.getDir())[0].floatValue() != 0.0f) {
            float t2;
            float m = ((Float[])ray.getDir())[1].floatValue() / ((Float[])ray.getDir())[0].floatValue();
            float t = -((Float[])ray.getStart())[0].floatValue() / ((Float[])ray.getDir())[0].floatValue();
            float c = ((Float[])ray.getDir())[1].floatValue() * t + ((Float[])ray.getStart())[1].floatValue();
            float c2 = m * (l1 + ((Float[])this.getCorner())[0].floatValue()) + c - ((Float[])this.getCorner())[1].floatValue() - l2;
            float ll1 = l1 * l1;
            float ll2 = l2 * l2;
            float p = 2.0f * m * ll1 * c2 / (ll2 + ll1 * m * m);
            float q = ll1 * (c2 * c2 - ll2) / (ll2 + ll1 * m * m);
            float x1 = (float)((double)(-p / 2.0f) + Math.sqrt(p * p / 4.0f - q));
            float x2 = -(p + x1);
            x1 += l1 + ((Float[])this.getCorner())[0].floatValue();
            x2 += l1 + ((Float[])this.getCorner())[0].floatValue();
            float t1 = (x1 - ((Float[])ray.getStart())[0].floatValue()) / ((Float[])ray.getDir())[0].floatValue();
            if (Math.max(t1, t2 = (x2 - ((Float[])ray.getStart())[0].floatValue()) / ((Float[])ray.getDir())[0].floatValue()) < 0.0f) {
                return false;
            }
            isct[0] = Math.min(t1, t2) >= 0.0f ? Float.valueOf(Math.min(t1, t2) == t1 ? x1 : x2) : Float.valueOf(Math.max(t1, t2) == t1 ? x1 : x2);
            isct[1] = Float.valueOf(m * isct[0].floatValue() + c);
        } else {
            float x = ((Float[])ray.getStart())[0].floatValue() - ((Float[])this.getCorner())[0].floatValue() - l1;
            if (x / l1 > 1.0f) {
                return false;
            }
            float y = (float)Math.sqrt(1.0f - x * x / (l1 * l1));
            if ((y + l2 + ((Float[])this.getCorner())[1].floatValue() - ((Float[])ray.getStart())[1].floatValue()) / ((Float[])ray.getDir())[1].floatValue() < 0.0f) {
                y = -y;
            }
            isct[0] = ((Float[])ray.getStart())[0];
            isct[1] = Float.valueOf(y + l2 + ((Float[])this.getCorner())[1].floatValue());
        }
        return true;
    }

    public static void main(String[] s) {
        EllipseFloat ef = new EllipseFloat(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float.valueOf(1.0f), new VecMathFloat());
        Float[] isct = new Float[2];
        Ray ray = new Ray((Number[])new Float[]{Float.valueOf(-1.0f), Float.valueOf(0.5f)}, (Number[])new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f)}, null);
        ef.intersect((Ray<Float>)ray, isct);
        System.out.println("------------  " + isct[0] + "  -----------  " + isct[1]);
    }
}

