/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import lattice.IShape;
import lattice.Ray;
import math.VecMath;

public final class Circle<T extends Number>
implements IShape<T> {
    private final VecMath<T> mt;
    private T[] ctr;
    private T r;
    private T inv_r;
    private T sq_r;
    private T inv_2rrr;
    private T[] tmp;

    public Circle(T[] center, T r, VecMath<T> math) {
        this.mt = math;
        this.ctr = center;
        this.setRadius(r);
        this.tmp = math.util.array(center.length);
    }

    private Circle(T[] center, T r, T invr, T inv2rrr, T sqr, VecMath<T> math) {
        this.mt = math;
        this.ctr = center;
        this.r = r;
        this.inv_r = invr;
        this.inv_2rrr = inv2rrr;
        this.sq_r = sqr;
        this.tmp = math.util.array(center.length);
    }

    @Override
    public T[] getCenter() {
        return this.ctr;
    }

    @Override
    public synchronized boolean reflect(Ray<T> r1, Ray<T> r2) {
        float tmp0 = r1.getStart()[0].floatValue() - ((Number)this.ctr[0]).floatValue();
        float tmp1 = r1.getStart()[1].floatValue() - ((Number)this.ctr[1]).floatValue();
        float d = r1.getDir()[1].floatValue() * tmp0 - r1.getDir()[0].floatValue() * tmp1;
        if (Math.abs(d) < ((Number)this.r).floatValue() + 1.0E-4f) {
            this.mt.diff(r1.getStart(), (Number[])this.ctr, (Number[])this.tmp);
            Number proj = this.mt.dot(r1.getDir(), (Number[])this.tmp);
            if (this.mt.cmp(proj, (Number)this.mt.ZERO) > 0) {
                return false;
            }
            this.mt.scaleAdd((Number[])this.tmp, this.mt.neg(proj), r1.getDir(), (Number[])this.tmp);
            Number tmp2 = this.mt.normSquared((Number[])this.tmp);
            if (this.mt.cmp(tmp2, (Number)this.sq_r) < 0) {
                int p = this.mt.util.minPrecision(r1.getStart());
                this.mt.scaleAdd((Number[])this.tmp, this.mt.neg(this.mt.sqrt(this.mt.sub((Number)this.sq_r, tmp2), p)), r1.getDir(), (Number[])this.tmp);
                this.mt.add((Number[])this.ctr, (Number[])this.tmp, r2.getStart());
                Number dn = this.mt.sub(this.mt.normSquared((Number[])this.tmp), (Number)this.sq_r);
                if (this.mt.util.getScale(dn) + 2 < this.mt.util.getScale(this.sq_r)) {
                    this.mt.scale(this.mt.sub((Number)this.inv_r, this.mt.mul((Number)this.inv_2rrr, dn)), (Number[])this.tmp);
                } else {
                    this.mt.normalize((Number[])this.tmp);
                }
                this.mt.mirror(r1.getDir(), (Number[])this.tmp, r2.getDir());
                return true;
            }
        }
        r2.copy(r1);
        return false;
    }

    private T sq(T t) {
        return this.mt.mul(t, t);
    }

    public T getRadius() {
        return this.r;
    }

    public void setRadius(T radius) {
        this.r = radius;
        this.inv_r = this.mt.inv(radius);
        this.sq_r = this.sq(radius);
        this.inv_2rrr = this.mt.inv(this.mt.mul(this.mt.mul(this.sq_r, this.r), this.mt.TWO));
    }

    @Override
    public void setCenter(T[] c) {
        this.ctr = c;
    }

    @Override
    public Circle<T> copy() {
        return new Circle((Number[])this.ctr.clone(), this.r, this.inv_r, this.inv_2rrr, this.sq_r, this.mt);
    }

    @Override
    public void rotate(T[] p, T[] dir, T phi) {
        this.mt.rotate2D((Number[])this.ctr, (Number[])p, (Number)phi);
    }

    @Override
    public void rotate(T[] p, T[] dir, T sinphi, T cosphi) {
        this.mt.rotate2D((Number[])this.ctr, (Number[])p, (Number)sinphi, (Number)cosphi);
    }

    @Override
    public void scale(T s) {
        this.setRadius(this.mt.mul(this.r, s));
    }

    @Override
    public <S extends Number> Circle<S> convert(IConverter<T, S> cv, VecMath<S> smath) {
        return new Circle(cv.convert(this.ctr), cv.convert((T[])this.r), smath);
    }

    @Override
    public T getSize() {
        return this.r;
    }

    @Override
    public void setSize(T r) {
        this.setRadius(r);
    }

    @Override
    public synchronized boolean contains(T[] p) {
        this.mt.diff((Number[])this.ctr, (Number[])p, (Number[])this.tmp);
        return this.mt.cmp(this.mt.normSquared((Number[])this.tmp), (Number)this.sq_r) <= 0;
    }
}

