/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import lattice.Box;
import lattice.Ray;
import math.VecMath;

public class Box2D<T extends Number>
extends Box<T> {
    private T[] locNorVec;

    public Box2D(T[] p1, T[][] baseVecs, T[] lengths, VecMath<T> math) {
        super(p1, baseVecs, lengths, math);
        this.init();
    }

    public Box2D(T[] p, T length, VecMath<T> math) {
        super(p, length, math);
        this.init();
    }

    public Box2D(T[] p, T[] lengths, VecMath<T> math) {
        super(p, lengths, math);
        this.init();
    }

    private void init() {
        if (this.cornerPoint.length > 2) {
            this.locNorVec = (Number[])this.math.ZERO3D.clone();
            this.locNorVec[2] = this.math.ONE;
        }
    }

    @Override
    public boolean localIntersect(Ray<T> locRay, T[] isct) {
        if (this.locNorVec != null) {
            boolean ret = false;
            if (this.math.cmp(locRay.getDir()[2], this.math.ZERO) != 0) {
                return this.localIntersect3D(locRay, (Number[])isct);
            }
            if (this.math.cmp(locRay.getStart()[2], this.math.ZERO) == 0) {
                ret = this.localIntersect2D(locRay, (Number[])isct);
            }
            return ret;
        }
        return this.localIntersect2D(locRay, (Number[])isct);
    }

    private boolean localIntersect3D(Ray<T> locRay, T[] isct) {
        Number t = this.math.neg(this.math.div(locRay.getStart()[2], locRay.getDir()[2]));
        if (this.math.cmp(t, this.math.ZERO) < 0) {
            return false;
        }
        this.math.scaleAdd(locRay.getStart(), t, locRay.getDir(), (Number[])isct);
        return this.containsLocal((Number[])isct);
    }

    private boolean localIntersect2D(Ray<T> locRay, T[] isct) {
        Number[] st = locRay.getStart();
        Number[] dir = locRay.getDir();
        byte loc = this.locationLocal(st);
        if (loc == 1) {
            this.math.util.copy(locRay.getStart(), (Number[])isct);
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            boolean firstSide;
            if (this.math.cmp(dir[1 - i], this.math.ZERO) == 0) continue;
            this.math.util.copy((Number[])this.math.ZERO3D, (Number[])isct);
            boolean bl = firstSide = this.math.cmp(dir[1 - i], this.math.ZERO) > 0;
            if (loc == 0) {
                if (firstSide ? this.math.cmp(st[1 - i], this.math.ZERO) > 0 : this.math.cmp(st[1 - i], this.sideVecNorm[1 - i]) < 0) {
                    continue;
                }
            } else {
                firstSide = !firstSide;
            }
            short sideIdx = (short)(i + (firstSide ? 0 : 2));
            switch (sideIdx) {
                case 0: {
                    isct[0] = this.math.sub(st[0], this.math.mul(st[1], this.math.div(dir[0], dir[1])));
                    isct[1] = this.math.ZERO;
                    break;
                }
                case 1: {
                    isct[0] = this.math.ZERO;
                    isct[1] = this.math.sub(st[1], this.math.mul(st[0], this.math.div(dir[1], dir[0])));
                    break;
                }
                case 2: {
                    Number tmp = this.math.sub(this.sideVecNorm[1], st[1]);
                    isct[0] = this.math.add(st[0], this.math.mul(tmp, this.math.div(dir[0], dir[1])));
                    isct[1] = this.sideVecNorm[1];
                    break;
                }
                case 3: {
                    Number tmp = this.math.sub(this.sideVecNorm[0], st[0]);
                    isct[0] = this.sideVecNorm[0];
                    isct[1] = this.math.add(st[1], this.math.mul(tmp, this.math.div(dir[1], dir[0])));
                }
            }
            if (!this.containsLocal((Number[])isct)) continue;
            return true;
        }
        return false;
    }

    public T getWidth() {
        return this.getLength((byte)0);
    }

    public T getHeight() {
        return this.getLength((byte)1);
    }

    @Override
    public void rotate(T[] p, T[] axis, T phi) {
        this.math.rotate2D(this.cornerPoint, (Number[])p, (Number)phi);
        for (int i = 0; i < this.sideVec.length; ++i) {
            this.math.rotate2D(this.baseVec[i], (Number[])p, (Number)phi);
            this.math.scale(this.baseVec[i], this.sideVecNorm[i], this.sideVec[i]);
        }
    }

    @Override
    public void rotate(T[] p, T[] axis, T sinphi, T cosphi) {
        this.math.rotate2D(this.cornerPoint, (Number[])p, (Number)sinphi, (Number)cosphi);
        for (int i = 0; i < this.sideVec.length; ++i) {
            this.math.rotate2D(this.baseVec[i], (Number[])p, (Number)sinphi, (Number)cosphi);
            this.math.scale(this.baseVec[i], this.sideVecNorm[i], this.sideVec[i]);
        }
    }

    @Override
    public Box2D<T> copy() {
        Number[][] bv = (Number[][])this.baseVec.clone();
        for (int i = 0; i < bv.length; ++i) {
            bv[i] = (Number[])this.baseVec[i].clone();
        }
        Number[] svn = (Number[])this.sideVecNorm.clone();
        Number[] cp = (Number[])this.cornerPoint.clone();
        return new Box2D(cp, bv, svn, this.math);
    }

    @Override
    public <S extends Number> Box2D<S> convert(IConverter<T, S> c, VecMath<S> smath) {
        Number[][] bv = smath.util.array((short)this.baseVec.length, (short)this.baseVec[0].length);
        for (int i = 0; i < bv.length; ++i) {
            for (int j = 0; j < bv.length; ++j) {
                bv[i][j] = c.convert(this.baseVec[i][j]);
            }
        }
        S svn = c.convert((Number)this.sideVecNorm);
        S cp = c.convert((Number)this.cornerPoint);
        return new Box2D(cp, bv, svn, smath);
    }
}

