/*
 * Decompiled with CFR 0.152.
 */
package lattice;

import common.IConverter;
import common.Log;
import lattice.IBox;
import lattice.Ray;
import math.VecMath;

public abstract class Box<T extends Number>
implements IBox<T> {
    public static final byte LOC_OUTSIDE = 0;
    public static final byte LOC_BOUNDARY = 1;
    public static final byte LOC_INSIDE = 2;
    protected T[] cornerPoint;
    protected T[][] baseVec;
    protected T[][] sideVec;
    protected T[] sideVecNorm;
    protected VecMath<T> math;

    public Box(T[] p, T length, VecMath<T> math) {
        this.cornerPoint = p;
        this.math = math;
        this.sideVec = math.util.array(p.length, p.length);
        this.baseVec = math.util.array(p.length, p.length);
        this.sideVecNorm = math.util.array(p.length);
        for (byte i = 0; i < this.sideVec.length; i = (byte)(i + 1)) {
            this.baseVec[i] = (Number[])math.getBase(i, (byte)p.length).clone();
            this.sideVec[i] = (Number[])this.baseVec[i].clone();
            math.scale((Number)length, (Number[])this.sideVec[i]);
            this.sideVecNorm[i] = length;
        }
    }

    public Box(T[] p, T[] lengths, VecMath<T> math) {
        byte i;
        this.cornerPoint = p;
        this.math = math;
        this.sideVec = math.util.array(lengths.length, p.length);
        this.baseVec = math.util.array(p.length, p.length);
        this.sideVecNorm = math.util.array((short)lengths.length);
        for (i = 0; i < this.baseVec.length; i = (byte)(i + 1)) {
            this.baseVec[i] = (Number[])math.getBase(i, (byte)p.length).clone();
        }
        for (i = 0; i < this.sideVec.length; i = (byte)(i + 1)) {
            this.sideVec[i] = (Number[])this.baseVec[i].clone();
            math.scale((Number)lengths[i], (Number[])this.sideVec[i]);
            this.sideVecNorm[i] = lengths[i];
        }
    }

    public Box(T[] p, T[][] baseVec, T[] lengths, VecMath<T> math) {
        this.cornerPoint = p;
        this.math = math;
        if (baseVec.length != p.length) {
            String msg = "Base count does not match dimension";
            Log.getIstc().log(new Exception(msg));
            return;
        }
        this.baseVec = baseVec;
        this.sideVecNorm = lengths;
        short l1 = (short)lengths.length;
        short l2 = (short)p.length;
        this.sideVec = math.util.array(l1, l2);
        for (int i = 0; i < this.sideVec.length; ++i) {
            math.scale((Number[])baseVec[i], (Number)this.sideVecNorm[i], (Number[])this.sideVec[i]);
        }
    }

    @Override
    public final byte location(T[] p) {
        Number[] tmp = this.math.util.array(p.length);
        this.math.diff((Number[])p, (Number[])this.cornerPoint, tmp);
        Number[] param = this.math.util.array(p.length);
        this.math.decompose(tmp, (Number[][])this.baseVec, param);
        return this.locationLocal(param);
    }

    @Override
    public final byte locationLocal(T[] p) {
        int i;
        for (i = 0; i < this.sideVecNorm.length; ++i) {
            if (this.math.cmp(this.math.ZERO, p[i]) <= 0 && this.math.cmp(this.sideVecNorm[i], p[i]) >= 0) continue;
            return 0;
        }
        for (i = 0; i < this.sideVecNorm.length; ++i) {
            if (this.math.cmp(this.math.ZERO, p[i]) != 0 && this.math.cmp(this.sideVecNorm[i], p[i]) != 0) continue;
            return 1;
        }
        return 2;
    }

    @Override
    public boolean contains(T[] p) {
        byte loc = this.location((Number[])p);
        return loc == 1 || loc == 2;
    }

    @Override
    public boolean containsLocal(T[] p) {
        byte loc = this.locationLocal((Number[])p);
        return loc == 1 || loc == 2;
    }

    @Override
    public final void constrainLocal(T[] p, T[] ret) {
        for (int i = 0; i < p.length; ++i) {
            ret[i] = this.math.cmp(p[i], this.math.ZERO) < 0 ? this.math.ZERO : (this.math.cmp(p[i], this.getLength((byte)i)) > 0 ? this.getLength((byte)i) : p[i]);
        }
    }

    @Override
    public boolean intersect(Ray<T> ray, T[] isct) {
        Number[] start = this.math.util.array(isct.length);
        Number[] dir = this.math.util.array(isct.length);
        Ray locRay = new Ray(start, dir, this.math.util);
        this.world2LocalPoint(ray.getStart(), locRay.getStart());
        this.world2LocalVec(ray.getDir(), locRay.getDir());
        boolean isctFound = this.localIntersect(locRay, (Number[])isct);
        if (isctFound) {
            this.local2WorldPoint((Number[])isct.clone(), (Number[])isct);
        }
        return isctFound;
    }

    @Override
    public void setCorner(T[] corner) {
        this.math.util.copy((Number[])corner, (Number[])this.cornerPoint);
    }

    @Override
    public void setCenter(T[] ctr) {
        this.math.scale((Number[])this.sideVecNorm, this.math.getDiagHalf((byte)ctr.length), (Number[])this.cornerPoint);
        this.math.diff((Number[])ctr, (Number[])this.cornerPoint, (Number[])this.cornerPoint);
        this.setCorner((Number[])this.cornerPoint);
    }

    @Override
    public void setLength(T l) {
        for (int i = 0; i < this.sideVec.length; ++i) {
            this.math.scale((Number[])this.baseVec[i], (Number)l, (Number[])this.sideVec[i]);
            this.sideVecNorm[i] = l;
        }
    }

    @Override
    public void setLengths(T[] ls) {
        for (int i = 0; i < this.sideVec.length; ++i) {
            this.math.scale((Number[])this.baseVec[i], (Number)ls[i], (Number[])this.sideVec[i]);
            this.sideVecNorm[i] = ls[i];
        }
    }

    @Override
    public void setLength(T l, byte dir) {
        this.math.scale((Number[])this.baseVec[dir], (Number)l, (Number[])this.sideVec[dir]);
        this.sideVecNorm[dir] = l;
    }

    @Override
    public final T getLength(byte dir) {
        return this.sideVecNorm[dir];
    }

    @Override
    public T[][] getSideVectors() {
        return this.sideVec;
    }

    @Override
    public T[][] getBaseVectors() {
        return this.baseVec;
    }

    @Override
    public T[] getLengths() {
        return this.sideVecNorm;
    }

    @Override
    public T[] getCorner() {
        return this.cornerPoint;
    }

    @Override
    public abstract IBox<T> copy();

    @Override
    public final void world2LocalPoint(T[] v, T[] ret) {
        Number[] diff = this.math.util.array(v.length);
        this.math.diff((Number[])v, this.getCorner(), diff);
        this.math.decompose(diff, (Number[][])this.baseVec, (Number[])ret);
    }

    @Override
    public final void local2WorldPoint(T[] v, T[] ret) {
        this.math.transform((Number[])v, (Number[][])this.baseVec, (Number[])ret);
        this.math.add(this.getCorner(), (Number[])ret, (Number[])ret);
    }

    @Override
    public final void world2LocalVec(T[] v, T[] ret) {
        this.math.decompose((Number[])v, (Number[][])this.baseVec, (Number[])ret);
    }

    @Override
    public final void local2WorldVec(T[] v, T[] ret) {
        this.math.transform((Number[])v, (Number[][])this.baseVec, (Number[])ret);
    }

    @Override
    public abstract <S extends Number> IBox<S> convert(IConverter<T, S> var1, VecMath<S> var2);
}

