/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class SelectTextItemListener
implements ItemListener,
ActionListener {
    private JFrame frame;
    private final String text;
    private final String title;
    private final AbstractButton item;
    private final int width;
    private final int height;

    public SelectTextItemListener(AbstractButton ab, String title, String text, int w, int h) {
        this.text = text;
        this.title = title;
        this.item = ab;
        this.width = w;
        this.height = h;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.handleFrame();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.handleFrame();
    }

    private void handleFrame() {
        if (this.frame == null) {
            this.frame = new JFrame(this.title);
            this.frame.setBackground(Color.black);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    SelectTextItemListener.this.item.setSelected(false);
                    SelectTextItemListener.this.frame.removeWindowListener(this);
                    SelectTextItemListener.this.frame = null;
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    SelectTextItemListener.this.item.setSelected(false);
                    SelectTextItemListener.this.frame.removeWindowListener(this);
                    SelectTextItemListener.this.frame = null;
                }
            });
            JEditorPane textArea = new JEditorPane("text/html", this.text);
            textArea.setEditable(false);
            final JScrollPane scrollPane = new JScrollPane(textArea);
            int policy = 31;
            scrollPane.setHorizontalScrollBarPolicy(policy);
            this.frame.getContentPane().add(scrollPane);
            this.frame.pack();
            this.frame.setMinimumSize(new Dimension(this.width, this.height));
            this.frame.setMaximumSize(new Dimension(this.width, this.height));
            this.frame.setSize(this.width, this.height);
            this.frame.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point pos = scrollPane.getViewport().getViewPosition();
                    pos.y = 0;
                    scrollPane.getViewport().setViewPosition(pos);
                }
            });
        } else {
            this.frame.dispose();
        }
    }
}

