/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;
import java.util.Arrays;
import java.util.HashMap;

public final class Profiler {
    private final HashMap<String, Long> sumTime = new HashMap();
    private final HashMap<String, Long> iniTime = new HashMap();
    private final HashMap<String, Long> calls = new HashMap();
    private static Profiler inst;
    private long time;
    private boolean active;

    private Profiler() {
    }

    public static Profiler getInstance() {
        if (inst == null) {
            inst = new Profiler();
        }
        return inst;
    }

    public void startTimeMeas(String method) {
        if (this.active) {
            if (this.iniTime.get(method) == null) {
                this.iniTime.put(method, System.currentTimeMillis());
            } else {
                Log.getIstc().logln("Profiler Error: Initialized running measurement");
            }
        }
    }

    public void endTimeMeas(String method) {
        if (this.active) {
            Long startTime = this.iniTime.get(method);
            if (startTime != null) {
                Long t = this.sumTime.get(method);
                if (t == null) {
                    t = 0L;
                }
                this.sumTime.put(method, t + System.currentTimeMillis() - startTime);
                this.iniTime.put(method, null);
                Long c = this.calls.get(method);
                if (c == null) {
                    c = 0L;
                }
                c = c + 1L;
                this.calls.put(method, c);
            } else {
                Log.getIstc().logln("Profiler Error: Stopping non running measurement");
            }
        }
    }

    public String toString() {
        if (this.active) {
            StringBuffer sb = new StringBuffer();
            sb.append("method : calls time[s] time[%]\n");
            long runTime = System.currentTimeMillis() - this.time;
            Object[] keys = this.sumTime.keySet().toArray(new String[this.sumTime.size()]);
            Arrays.sort(keys);
            for (Object method : keys) {
                float mt = (float)this.sumTime.get(method).longValue() / 1000.0f;
                float p = (float)this.sumTime.get(method).longValue() * 100.0f / (float)runTime;
                long c = this.calls.get(method);
                sb.append((String)method + ": " + c + " " + mt + "s " + p + "%\n");
            }
            sb.append("total: " + (float)runTime / 1000.0f);
            return sb.toString();
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.iniTime.clear();
            this.sumTime.clear();
        } else {
            this.time = System.currentTimeMillis();
        }
    }
}

