/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class Log
extends JPanel {
    private static final int BUFFER_SIZE = 20000;
    private final StringBuffer buf = new StringBuffer();
    private static Log instance;
    private boolean enable = true;
    private UpdateTextThread update;
    private JTextPane textPane;
    private JScrollPane scrollPane;

    private Log() {
    }

    public static Log getIstc() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    public void initGUI() {
        if (this.textPane == null) {
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this.setLayout(gbl);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.textPane = new JTextPane();
            this.textPane.setEditable(false);
            this.textPane.setFont(new Font("Monospaced", 0, 9));
            this.textPane.setBackground(new Color(255, 255, 220));
            this.scrollPane = new JScrollPane(this.textPane);
            gbl.setConstraints(this.scrollPane, gbc);
            this.add(this.scrollPane);
            this.log("");
        }
    }

    public synchronized void log(String s) {
        if (!this.enable) {
            return;
        }
        this.buf.append(s);
        if (this.textPane != null && this.update == null) {
            this.update = new UpdateTextThread();
            this.update.start();
        }
        System.out.print(s);
    }

    public synchronized void logln(String s) {
        this.log(s);
        this.log("\n");
    }

    public synchronized void logf(String s, int width) {
        this.log(s);
        for (int i = s.length(); i < width; ++i) {
            this.log(" ");
        }
    }

    public void log(Exception e) {
        this.logln(e.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        this.logln(new String(baos.toByteArray()));
    }

    public void enableLogging(boolean b) {
        this.enable = b;
    }

    public void deleteGUI() {
        this.textPane = null;
        this.scrollPane = null;
        this.removeAll();
    }

    private class UpdateTextThread
    extends Thread {
        private UpdateTextThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Log log = Log.this;
            synchronized (log) {
                Point pos = Log.this.scrollPane.getViewport().getViewPosition();
                if (Log.this.buf.length() > 20000) {
                    Log.this.buf.delete(0, Log.this.buf.length() - 20000);
                }
                Log.this.textPane.setText(Log.this.buf.toString());
                pos.y = Log.this.textPane.getHeight();
                Log.this.scrollPane.getViewport().setViewPosition(pos);
                Log.this.update = null;
            }
        }
    }
}

