/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ColorTheme;
import common.Globals;
import common.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import math.VecMath;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.ILightPattern;
import pattern.LightChar;
import pattern.LightCharPattern;
import pattern.LightPatternSequence;

public class FileIO<T extends Number> {
    private static final String BASE_CONFIG_DIR = "config";
    private static final String RECORD_DIR = "records";
    private static final String CHAR_DIR = "lightpatterns/lightchars";
    private static final String PATTERN_DIR = "lightpatterns";
    private static final String MUSEUM_DIR = "museum";
    private static final String INFO_DIR = "info";
    private static final String THEME_DIR = "themes";
    private static final String CHARS_FILE = "char_map.txt";
    private static final String MUSEUM_FILE = "patterns.txt";
    private static final String TAIL = ".txt";
    private static final String CONFIG_LIST_FILE = "cfg_list.txt";
    private static String USER_CONFIG_DIR;
    private String configDir;
    private final VecMath<T> math;

    public FileIO(VecMath<T> math) {
        this.math = math;
        this.configDir = USER_CONFIG_DIR != null ? USER_CONFIG_DIR : BASE_CONFIG_DIR;
    }

    public FileIO(VecMath<T> math, String ucd) {
        this.math = math;
        this.setUserCfgDir(ucd);
    }

    public void setUserCfgDir(String userCfgDir) {
        USER_CONFIG_DIR = userCfgDir;
        this.configDir = USER_CONFIG_DIR != null ? USER_CONFIG_DIR : BASE_CONFIG_DIR;
    }

    public static String getUserCfgDir() {
        return USER_CONFIG_DIR;
    }

    public static String getUserPatternDir() {
        return USER_CONFIG_DIR + File.separator + PATTERN_DIR;
    }

    public static String getUserRecordDir() {
        return USER_CONFIG_DIR + File.separator + RECORD_DIR;
    }

    public static String getUserMuseumDir() {
        return USER_CONFIG_DIR + File.separator + MUSEUM_DIR;
    }

    public static boolean checkUserConfigDir() {
        if (FileIO.getUserCfgDir() == null) {
            return false;
        }
        File dir = new File(FileIO.getUserCfgDir());
        if (!dir.exists()) {
            return false;
        }
        dir = new File(FileIO.getUserPatternDir());
        if (!dir.exists()) {
            return false;
        }
        dir = new File(FileIO.getUserRecordDir());
        return dir.exists();
    }

    public static void createUserConfigDir() throws Exception {
        File dir = new File(FileIO.getUserCfgDir());
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(dir = new File(FileIO.getUserPatternDir())).exists()) {
            dir.mkdir();
        }
        if (!(dir = new File(FileIO.getUserRecordDir())).exists()) {
            dir.mkdir();
        }
        if (!(dir = new File(FileIO.getUserMuseumDir())).exists()) {
            dir.mkdir();
        }
    }

    public void installUserConfigs() throws Exception {
        this.configDir = BASE_CONFIG_DIR;
        List<BaseLightPattern<T>> patterns = this.loadLightPatterns();
        ArrayList<CalculationRecords<T>> records = new ArrayList<CalculationRecords<T>>();
        for (BaseLightPattern<T> blp : patterns) {
            if (!blp.isStoreCalcEnabled()) continue;
            records.add(this.loadRecords(blp.getName()));
        }
        List<BaseLightPattern<T>> list = this.loadMuseum(patterns);
        this.configDir = USER_CONFIG_DIR;
        for (BaseLightPattern<T> baseLightPattern : patterns) {
            this.save2(baseLightPattern);
        }
        for (CalculationRecords calculationRecords : records) {
            this.save2(calculationRecords);
        }
        this.save2Museum(list);
    }

    private void save2(CalculationRecords<T> recs) throws Exception {
        File outFile = FileIO.findFile(FileIO.getUserRecordDir(), recs.getPatternName() + TAIL);
        if (outFile == null) {
            String path = FileIO.getUserRecordDir() + File.separator;
            path = path + recs.getPatternName() + TAIL;
            outFile = new File(path);
        }
        FileIO.writeFile(outFile, recs.toString());
    }

    private void save2Museum(List<BaseLightPattern<T>> patterns) throws Exception {
        File outFile = FileIO.findFile(FileIO.getUserMuseumDir(), MUSEUM_FILE);
        if (outFile == null) {
            String path = FileIO.getUserMuseumDir() + File.separator;
            path = path + MUSEUM_FILE;
            outFile = new File(path);
        }
        String list = "";
        for (BaseLightPattern<T> blp : patterns) {
            list = list + blp.getName() + "\n";
        }
        FileIO.writeFile(outFile, list.toString());
    }

    public void save(CalculationRecords<T> recs) {
        try {
            this.save2(recs);
        }
        catch (Exception e) {
            Log.getIstc().log("Error: Can't store calculation ");
            Log.getIstc().logln("record " + recs.getPatternName() + ".");
            Log.getIstc().logln(e.getMessage());
        }
    }

    public void save(CalculationRecords<T> recs, File f) {
        try {
            FileIO.writeFile(f, recs.toString());
        }
        catch (Exception e) {
            Log.getIstc().log("Error: Can't store calculation ");
            Log.getIstc().logln("record to file " + f.getPath() + ".");
            Log.getIstc().logln(e.getMessage());
        }
    }

    private void save2(ILightPattern<T> lp) throws Exception {
        File outFile = FileIO.findFile(FileIO.getUserPatternDir(), lp.getName() + TAIL);
        if (outFile == null) {
            String path = FileIO.getUserPatternDir() + File.separator;
            path = path + lp.getName() + TAIL;
            outFile = new File(path);
        }
        FileIO.writeFile(outFile, lp.toString());
    }

    public void save(ILightPattern<T> lp) {
        try {
            this.save2(lp);
        }
        catch (Exception e) {
            Log.getIstc().logln("Error: Can't store light pattern " + lp.getName() + ".");
            Log.getIstc().logln(e.getMessage());
        }
    }

    public static void delete(ILightPattern lp) {
        try {
            File delFile = FileIO.findFile(FileIO.getUserPatternDir(), lp.getName());
            if (delFile != null) {
                delFile.delete();
            }
        }
        catch (Exception e) {
            Log.getIstc().log("Error: Can't delete light pattern " + lp.getName() + ".");
            Log.getIstc().logln(e.getMessage());
        }
    }

    public static void deleteCalculationRecords(String name) {
        try {
            File delFile = FileIO.findFile(FileIO.getUserRecordDir(), name);
            if (delFile != null) {
                delFile.delete();
            }
        }
        catch (Exception e) {
            Log.getIstc().log("Error: Can't delete calculation record " + name + ".");
            Log.getIstc().logln(e.getMessage());
        }
    }

    private static File findFile(String dr, String name) throws Exception {
        File dir = new File(dr);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    String fn;
                    String patName;
                    if (!files[i].getName().endsWith(TAIL) || (patName = (fn = files[i].getName()).substring(0, fn.length() - TAIL.length())).compareTo(name) != 0) continue;
                    return files[i];
                }
            }
        } else {
            throw new Exception("Directory " + dir.getAbsolutePath() + " not found.");
        }
        return null;
    }

    public String loadInfoText(String name) {
        String path = "config/info/";
        return this.readResource(path + name + ".html");
    }

    public LightChar[] loadLightChars() {
        String path = "config/lightpatterns/lightchars/";
        String fileContent = this.readResource(path + CHARS_FILE);
        StringTokenizer st = new StringTokenizer(fileContent, "\n");
        ArrayList<LightPatternSequence> lightChars = new ArrayList<LightPatternSequence>();
        LightPatternSequence lchar = null;
        int l = 0;
        try {
            while (st.hasMoreTokens()) {
                int idx;
                ++l;
                String line = st.nextToken().trim();
                if (line.startsWith("#") || (idx = line.indexOf("=")) == -1) continue;
                String key = line.substring(0, idx).trim();
                String val = line.substring(idx + 1).trim();
                if (key.compareTo("char") == 0) {
                    String ch = val.substring(1, val.length() - 1);
                    lchar = new LightChar(ch);
                    lightChars.add(lchar);
                    if (ch.compareToIgnoreCase("bol") != 0 && ch.compareToIgnoreCase("eol") != 0) continue;
                    ((LightChar)lchar).setOrientation(LightChar.VERTICAL);
                    continue;
                }
                if (key.equalsIgnoreCase("initial_gradients")) {
                    lchar.setInitialGradients(FileIO.initialGradients(val));
                    continue;
                }
                if (key.equalsIgnoreCase("reflection_path")) {
                    lchar.setCellSequence(FileIO.reflectionPath(val));
                    continue;
                }
                throw new Exception("Unknown key: " + key);
            }
        }
        catch (Exception e) {
            String msg = "Error while reading file char_map.txt.txt:\n";
            msg = msg + "Can't read line " + l + ".\n";
            Log.getIstc().log(msg);
            Log.getIstc().log(e);
            return null;
        }
        Collections.sort(lightChars, new Comparator<LightChar>(){

            @Override
            public int compare(LightChar s1, LightChar s2) {
                String c1 = s1.getChar();
                String c2 = s2.getChar();
                char ch1 = c1.charAt(0);
                char ch2 = c2.charAt(0);
                if (c1.length() == 1 && c2.length() > 1) {
                    return -1;
                }
                if (c1.length() > 1 && c2.length() == 1) {
                    return 1;
                }
                if (!Character.isLetter(ch1) && Character.isLetter(ch2)) {
                    return 1;
                }
                if (Character.isLetter(ch1) && !Character.isLetter(ch2)) {
                    return -1;
                }
                if (!Character.isDigit(ch1) && Character.isDigit(ch2)) {
                    return 1;
                }
                if (Character.isDigit(ch1) && !Character.isDigit(ch2)) {
                    return -1;
                }
                if (c1.length() == 1 && c2.length() == 1) {
                    return c1.compareTo(c2);
                }
                return c1.compareTo(c2);
            }
        });
        return lightChars.toArray(new LightChar[lightChars.size()]);
    }

    public CalculationRecords<T> loadRecords(String name) {
        String dir = this.configDir + "/" + RECORD_DIR;
        String content = this.configDir.compareTo(BASE_CONFIG_DIR) == 0 ? this.readResource(dir + "/" + name + TAIL) : FileIO.loadText(name, dir, false);
        try {
            if (content != null) {
                return new CalculationRecords<T>(name, content, this.math);
            }
        }
        catch (Exception e) {
            Log.getIstc().logln(e.getMessage());
        }
        return null;
    }

    public List<BaseLightPattern<T>> loadMuseum(List<BaseLightPattern<T>> li) {
        String dir = this.configDir + "/" + MUSEUM_DIR;
        String content = this.configDir.compareTo(BASE_CONFIG_DIR) == 0 ? this.readResource(dir + "/" + MUSEUM_FILE) : FileIO.loadText(new File(dir + "/" + MUSEUM_FILE), true);
        ArrayList<BaseLightPattern<T>> list = new ArrayList<BaseLightPattern<T>>();
        try {
            if (content != null) {
                StringTokenizer st = new StringTokenizer(content, "\n");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    boolean found = false;
                    for (BaseLightPattern<T> blp : li) {
                        if (blp.getName().compareTo(name) != 0) continue;
                        list.add(blp);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Log.getIstc().logln(dir + "/" + MUSEUM_FILE + ": Pattern " + name + " not found.");
                }
            }
        }
        catch (Exception e) {
            Log.getIstc().logln(e.getMessage());
        }
        return list;
    }

    public CalculationRecords<T> loadRecords(File f) {
        try {
            String txt = FileIO.loadText(f, true);
            if (txt != null) {
                return new CalculationRecords<T>("File: " + f.getName(), txt, this.math);
            }
        }
        catch (Exception e) {
            Log.getIstc().logln(e.getMessage());
        }
        Log.getIstc().logln("Error while reading file " + f.getAbsolutePath() + ".");
        return null;
    }

    public List<ColorTheme> loadColorThemes() {
        String cfgList = this.readResource("config/cfg_list.txt");
        if (cfgList != null) {
            return this.loadColorThemes(cfgList);
        }
        File dir = new File("config/themes");
        ArrayList<ColorTheme> retVal = new ArrayList<ColorTheme>();
        if (!dir.exists()) {
            Log.getIstc().log("Info: Can't load themes. ");
            Log.getIstc().logln("Directory " + dir.getAbsolutePath() + " not found.");
            return retVal;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(TAIL)) continue;
                try {
                    String content = FileIO.readFile(files[i]);
                    if (content == null || content.length() <= 0) continue;
                    int length = files[i].getName().length() - TAIL.length();
                    String name = files[i].getName().substring(0, length);
                    retVal.add(new ColorTheme(name, content));
                    continue;
                }
                catch (Exception e) {
                    String msg = "Warning: Can't read file ";
                    Log.getIstc().log(msg + files[i].getAbsolutePath() + " .");
                }
            }
        }
        return retVal;
    }

    public ColorTheme loadColorTheme(String theme) {
        if (theme != null) {
            List<ColorTheme> themes = this.loadColorThemes();
            for (ColorTheme t : themes) {
                if (t.getName().compareTo(theme) != 0) continue;
                return t;
            }
        }
        return null;
    }

    public List<BaseLightPattern<T>> loadLightPatterns() {
        String path;
        String cfgList;
        if (this.configDir.compareTo(BASE_CONFIG_DIR) == 0 && (cfgList = this.readResource(path = "config/cfg_list.txt")) != null) {
            return this.loadLightPatterns(cfgList);
        }
        File dir = new File(this.configDir + File.separator + PATTERN_DIR);
        ArrayList<BaseLightPattern<T>> retVal = new ArrayList<BaseLightPattern<T>>();
        if (!dir.exists()) {
            Log.getIstc().log("Info: Can't load light patterns. ");
            Log.getIstc().logln("Directory " + dir.getAbsolutePath() + " not found");
            return retVal;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            LightChar[] lchs = this.loadLightChars();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(TAIL)) continue;
                try {
                    String content = FileIO.readFile(files[i]);
                    if (content == null || content.length() <= 0) continue;
                    int length = files[i].getName().length() - TAIL.length();
                    String name = files[i].getName().substring(0, length);
                    BaseLightPattern<T> pat = this.buildPattern(name, content, lchs);
                    if (pat == null) continue;
                    retVal.add(pat);
                    continue;
                }
                catch (IOException e) {
                    Log.getIstc().log(e);
                }
            }
        }
        return retVal;
    }

    public BaseLightPattern<T> loadLightPattern(String pattern) {
        if (pattern != null) {
            List<BaseLightPattern<T>> pts = this.loadLightPatterns();
            for (BaseLightPattern<T> p : pts) {
                if (p.getName().compareTo(pattern) != 0) continue;
                return p;
            }
        }
        return null;
    }

    private static String loadText(String name, String dirName, boolean log) {
        File dir = new File(dirName);
        if (dir.exists()) {
            File file = new File(dirName + File.separator + name + TAIL);
            return FileIO.loadText(file, log);
        }
        Log.getIstc().logln("Error: Can't find directory: " + dir.getAbsolutePath());
        return null;
    }

    private static String loadText(File f, boolean log) {
        if (f.exists()) {
            try {
                return FileIO.readFile(f);
            }
            catch (IOException e) {
                Log.getIstc().log(e);
            }
        } else if (log) {
            Log.getIstc().logln("Error: Can't find file: " + f.getAbsolutePath());
        }
        return null;
    }

    private BaseLightPattern<T> buildPattern(String name, String fileContent, LightChar[] lc) {
        BaseLightPattern<T> retVal = null;
        StringTokenizer st = new StringTokenizer(fileContent, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.indexOf("=") != -1) {
                lines.add(s);
                continue;
            }
            if (lines.size() <= 0) continue;
            lines.set(lines.size() - 1, (String)lines.get(lines.size() - 1) + "\n" + s);
        }
        for (String line : lines) {
            int idx = line.indexOf("=");
            String key = line.substring(0, idx).trim();
            String val = line.substring(idx + 1).trim();
            if (retVal == null) {
                if (key.compareTo("text") == 0) {
                    try {
                        retVal = new LightCharPattern<T>(null, null, false, lc, this.math);
                    }
                    catch (Exception e) {
                        Log.getIstc().log(e);
                    }
                } else {
                    retVal = new BaseLightPattern<T>(this.math);
                }
            }
            if (key == null || key.length() <= 0) continue;
            try {
                if (retVal instanceof LightCharPattern) {
                    this.put(key, val, (LightCharPattern)retVal);
                    continue;
                }
                this.put(key, val, retVal);
            }
            catch (Exception e) {
                String msg = "Error while reading pattern file " + name + TAIL + ". Can't read line: " + line;
                Log.getIstc().logln(msg);
                Log.getIstc().log(e);
                return null;
            }
        }
        retVal.setName(name);
        retVal.calcStartIndex();
        if (retVal.getStartIndex() != 0) {
            retVal.setPropagating(true);
        }
        if (retVal.check()) {
            return retVal;
        }
        return null;
    }

    private void put(String key, String val, LightCharPattern<T> pat) throws Exception {
        if (key.equalsIgnoreCase("text")) {
            pat.setText(val);
        } else if (key.equalsIgnoreCase("store_calc")) {
            pat.setStoreCalculation(Boolean.parseBoolean(val));
        } else {
            throw new Exception("Unknown key: " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void put(String key, String val, BaseLightPattern<T> pat) throws Exception {
        if (key.equalsIgnoreCase("boundary_values")) {
            StringTokenizer st2 = new StringTokenizer(val, ",");
            if (st2.countTokens() == 2) {
                short maxPrec = Globals.PRECISIONS[Globals.PRECISIONS.length - 1];
                Object bndVal = this.math.util.parse(st2.nextToken().trim());
                pat.setStartBndVal(this.math.util.copy(bndVal, maxPrec));
                bndVal = this.math.util.parse(st2.nextToken().trim());
                pat.setEndBndVal(this.math.util.copy(bndVal, maxPrec));
                return;
            }
            String msg = "Two values are required. Found " + st2.countTokens();
            throw new Exception(msg);
        }
        if (key.equalsIgnoreCase("boundary_types")) {
            StringTokenizer st2 = new StringTokenizer(val, ",");
            if (st2.countTokens() != 2) throw new Exception("Expected two tokens");
            String s = st2.nextToken().trim();
            if (s.compareToIgnoreCase("p") == 0) {
                pat.setStartBndValType((byte)0);
            } else if (s.compareToIgnoreCase("+g") == 0) {
                pat.setStartBndValType((byte)1);
            } else {
                if (s.compareToIgnoreCase("-g") != 0) throw new Exception("Unknown bound type: " + s);
                pat.setStartBndValType((byte)2);
            }
            s = st2.nextToken().trim();
            if (s.compareToIgnoreCase("p") == 0) {
                pat.setEndBndValType((byte)0);
                return;
            }
            if (s.compareToIgnoreCase("+g") == 0) {
                pat.setEndBndValType((byte)1);
                return;
            }
            if (s.compareToIgnoreCase("-g") != 0) throw new Exception("Unknown bound type: " + s);
            pat.setEndBndValType((byte)2);
            return;
        }
        if (key.equalsIgnoreCase("initial_gradients")) {
            pat.setInitialGradients(FileIO.initialGradients(val));
            return;
        }
        if (key.equalsIgnoreCase("reflection_path")) {
            pat.setCellSequence(FileIO.reflectionPath(val));
            return;
        }
        if (key.equalsIgnoreCase("grid_size")) {
            pat.setGridSize(Byte.parseByte(val));
            return;
        }
        if (key.equalsIgnoreCase("store_calc")) {
            pat.setStoreCalculation(Boolean.parseBoolean(val));
            return;
        }
        if (!key.equalsIgnoreCase("max_radius")) throw new Exception("Unknown key: " + key);
        if (val != null && val.length() > 0) {
            int pos = val.indexOf("%");
            if (pos == -1) throw new Exception("Missing percent symbol");
            String percentValue = val.substring(0, pos).trim();
            short maxPrec = Globals.PRECISIONS[Globals.PRECISIONS.length - 1];
            Object r = this.math.util.copy(this.math.util.parse(percentValue), maxPrec);
            pat.setMaxShapeSize(r);
            return;
        }
        pat.setMaxShapeSize(null);
    }

    private static List<Float> initialGradients(String val) {
        StringTokenizer st2 = new StringTokenizer(val, ",");
        ArrayList<Float> grads = new ArrayList<Float>();
        while (st2.hasMoreTokens()) {
            grads.add(Float.valueOf(Float.parseFloat(st2.nextToken())));
        }
        return grads;
    }

    private static ArrayList<short[]> reflectionPath(String val) {
        StringTokenizer st2 = new StringTokenizer(val, ",");
        ArrayList<short[]> cellList = new ArrayList<short[]>();
        while (st2.countTokens() > 1) {
            String x = st2.nextToken();
            x = x.replace('(', ' ').replace('{', ' ').replace('[', ' ').trim();
            String y = st2.nextToken();
            y = y.replace(')', ' ').replace('}', ' ').replace(']', ' ').trim();
            short[] cellIdxs = new short[]{Byte.parseByte(x), Byte.parseByte(y)};
            cellList.add(cellIdxs);
        }
        return cellList;
    }

    private List<ColorTheme> loadColorThemes(String resList) {
        ArrayList<ColorTheme> retVal = new ArrayList<ColorTheme>();
        StringTokenizer st = new StringTokenizer(resList, "\n");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.indexOf("/themes/") == -1) continue;
            try {
                String content = this.readResource(path);
                if (content == null || content.compareTo("") == 0) {
                    throw new Exception();
                }
                String name = path.substring(path.lastIndexOf("/") + 1);
                name = name.substring(0, name.indexOf(TAIL));
                retVal.add(new ColorTheme(name, content));
            }
            catch (Exception e) {
                Log.getIstc().log("Warning: Can't read file " + path + " .");
            }
        }
        return retVal;
    }

    private List<BaseLightPattern<T>> loadLightPatterns(String resList) {
        ArrayList<BaseLightPattern<T>> retVal = new ArrayList<BaseLightPattern<T>>();
        StringTokenizer st = new StringTokenizer(resList, "\n");
        LightChar[] lcs = this.loadLightChars();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.indexOf("/lightpatterns/") == -1) continue;
            try {
                String content = this.readResource(path);
                if (content == null || content.compareTo("") == 0) continue;
                String name = path.substring(path.lastIndexOf("/") + 1);
                name = name.substring(0, name.indexOf(TAIL));
                retVal.add(this.buildPattern(name, content, lcs));
            }
            catch (Exception e) {
                Log.getIstc().log("Warning: Pattern " + path + " not found.");
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(String name) {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/" + name);
            if (is != null) {
                int result;
                BufferedInputStream bis = new BufferedInputStream(is);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((result = bis.read()) != -1) {
                    buf.write((byte)result);
                }
                String string = buf.toString("UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            Log.getIstc().logln("Error: Can't read resource " + name + " .");
            Log.getIstc().logln("Message: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[(int)file.length()];
            fis.read(bytes);
            String string = new String(bytes, "UTF-8");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, String content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(content.getBytes("UTF-8"));
        }
    }
}

