/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class ColorTheme {
    private final String name;
    private final Color rayColor;
    private final Color shapeColor;
    private final Color bgColor;
    private final Color borderColor;

    public ColorTheme() {
        this.name = "Blue";
        this.rayColor = Color.WHITE;
        this.shapeColor = new Color(60, 60, 150);
        this.bgColor = new Color(30, 30, 120);
        this.borderColor = new Color(120, 120, 120);
    }

    public ColorTheme(String name, String content) throws Exception {
        StringTokenizer st = new StringTokenizer(content, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.indexOf("=") == -1) continue;
            lines.add(s);
        }
        short[][] colors = new short[4][3];
        String[] fieldBase = new String[]{"shape", "border", "bg", "ray"};
        String[] fieldTail = new String[]{"_r", "_g", "_b"};
        for (String line : lines) {
            try {
                int idx = line.indexOf("=");
                String key = line.substring(0, idx).trim();
                String val = line.substring(idx + 1).trim();
                if (key == null || key.length() <= 0) continue;
                for (int i = 0; i < fieldBase.length; ++i) {
                    for (int k = 0; k < fieldTail.length; ++k) {
                        if (!key.equalsIgnoreCase(fieldBase[i] + fieldTail[k])) continue;
                        colors[i][k] = Short.parseShort(val);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error while parsing theme " + name + " :";
                msg = msg + " Can't read line: " + line;
                Log.getIstc().logln(msg);
                throw e;
            }
        }
        this.name = name;
        this.shapeColor = new Color(colors[0][0], colors[0][1], colors[0][2]);
        this.borderColor = new Color(colors[1][0], colors[1][1], colors[1][2]);
        this.bgColor = new Color(colors[2][0], colors[2][1], colors[2][2]);
        this.rayColor = new Color(colors[3][0], colors[3][1], colors[3][2]);
    }

    public String getName() {
        return this.name;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getRayColor() {
        return this.rayColor;
    }

    public Color getShapeColor() {
        return this.shapeColor;
    }
}

