/*
 * Decompiled with CFR 0.152.
 */
package calc;

import calc.CalculatorModel;
import common.Globals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import math.VecMath;

public class CalculatorVisualizer<T extends Number>
extends JPanel {
    private final String[] HEADERS = new String[]{"", "Expression", "Values", "", "Result"};
    private CalculatorModel<T> model;
    private JTable table;

    public CalculatorVisualizer(VecMath<T> math) {
        this.initGui(math);
    }

    public CalculatorModel<T> getModel() {
        return this.model;
    }

    public JTable getCalculatorTable() {
        return this.table;
    }

    private void initGui(VecMath<T> math) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        JComponent comp = this.createCalculationSheet(math);
        gridbag.setConstraints(comp, c);
        this.add(comp);
        this.setPreferredSize(new Dimension(550, 300));
    }

    private JComponent createCalculationSheet(VecMath<T> math) {
        this.model = new CalculatorModel<T>(this.HEADERS, math);
        this.table = new JTable(this.model);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        StringEditor se = new StringEditor(true);
        ColorRenderer cr = new ColorRenderer();
        ((JTextField)se.getComponent()).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!CalculatorVisualizer.this.model.isCleared()) {
                    CalculatorVisualizer.this.model.clearResults();
                }
                String val = ((JTextField)e.getSource()).getText();
                int rIdx = CalculatorVisualizer.this.table.getEditingRow();
                int cIdx = CalculatorVisualizer.this.table.getEditingColumn();
                CalculatorVisualizer.this.model.setValueAt(val, rIdx, cIdx);
            }
        });
        TableColumn col = this.table.getColumnModel().getColumn(1);
        col.setCellEditor(se);
        col.setCellRenderer(cr);
        col = this.table.getColumnModel().getColumn(2);
        col.setCellEditor(se);
        col.setCellRenderer(cr);
        col = this.table.getColumnModel().getColumn(4);
        col.setCellEditor(new StringEditor(false));
        col = this.table.getColumnModel().getColumn(3);
        col.setCellEditor(new ComboBoxEditor(CalculatorModel.MODES));
        this.table.getColumnModel().getColumn(0).setMaxWidth(25);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(3).setMaxWidth(40);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(120);
        return new JScrollPane(this.table);
    }

    public void stopEditing() {
        int rIdx = this.table.getEditingRow();
        int cIdx = this.table.getEditingColumn();
        if (rIdx != -1 && cIdx != -1) {
            this.table.getCellEditor(rIdx, cIdx).stopCellEditing();
        }
    }

    private class ColorRenderer
    extends DefaultTableCellRenderer {
        private ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object v, boolean sel, boolean b, int row, int col) {
            Component c = super.getTableCellRendererComponent(t, v, sel, b, row, col);
            c.setBackground(Globals.INPUT_BG);
            return c;
        }
    }

    private class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    private class StringEditor
    extends DefaultCellEditor {
        public StringEditor(boolean editable) {
            super(new JTextField());
            this.setClickCountToStart(1);
            JTextField c = (JTextField)this.getComponent();
            c.setEditable(editable);
            if (editable) {
                c.setBackground(Globals.INPUT_BG);
            }
        }
    }
}

