/*
 * Decompiled with CFR 0.152.
 */
package calc;

import calc.CalculatorVisualizer;
import common.FileIO;
import common.SelectTextItemListener;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class CalculatorView<T extends Number>
extends JFrame {
    private final CalculatorVisualizer<T> visualizer;
    private boolean calculating;
    private JToggleButton helpButton;

    public CalculatorView(CalculatorVisualizer<T> vis) {
        super("Calculator");
        this.visualizer = vis;
        this.initGui();
    }

    public CalculatorVisualizer<T> getVisualizer() {
        return this.visualizer;
    }

    private void initGui() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.insets = new Insets(10, 5, 5, 5);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        gridbag.setConstraints(this.visualizer, c);
        this.getContentPane().add(this.visualizer);
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.weighty = 0.0;
        c.gridy = 1;
        c.anchor = 13;
        JPanel p = this.createButtonPanel();
        gridbag.setConstraints(p, c);
        this.getContentPane().add(p);
        this.pack();
        this.setSize(500, 300);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(2));
        this.helpButton = new JToggleButton("Help");
        String text = new FileIO(null).loadInfoText("Calculator");
        String title = "Calculator Info";
        this.helpButton.addItemListener(new SelectTextItemListener(this.helpButton, title, text, 620, 600));
        panel.add(this.helpButton);
        JButton b = new JButton("Remove Row");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable table = CalculatorView.this.visualizer.getCalculatorTable();
                int rIdx = table.getEditingRow();
                if (rIdx != -1) {
                    CalculatorView.this.visualizer.stopEditing();
                    CalculatorView.this.visualizer.getModel().removeRow(rIdx);
                }
            }
        });
        panel.add(b);
        b = new JButton("Insert Row");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable table = CalculatorView.this.visualizer.getCalculatorTable();
                int rIdx = table.getEditingRow();
                if (rIdx != -1) {
                    CalculatorView.this.visualizer.stopEditing();
                    CalculatorView.this.visualizer.getModel().insertRow(rIdx);
                }
            }
        });
        panel.add(b);
        b = new JButton("Calculate");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (!CalculatorView.this.calculating) {
                    CalculatorView.this.calculating = true;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                CalculatorView.this.visualizer.stopEditing();
                                CalculatorView.this.visualizer.getModel().calculate();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(CalculatorView.this, e.getMessage());
                            }
                            CalculatorView.this.calculating = false;
                        }
                    };
                    t.setPriority(1);
                    t.start();
                }
            }
        });
        panel.add(b);
        return panel;
    }

    @Override
    public void dispose() {
        this.helpButton.setSelected(false);
        super.dispose();
    }
}

