/*
 * Decompiled with CFR 0.152.
 */
package calc;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import math.IFunction;
import math.VecMath;
import parser.ExpressionTree;
import parser.ExpressionTreeBuilder;

public class CalculatorModel<T extends Number>
implements TableModel {
    public static final String MODE_EVAL = "  =  ";
    public static final String MODE_ROOT = "  = 0";
    public static final String[] MODES = new String[]{"  =  ", "  = 0"};
    private final String ROOT_VAR = "x";
    private final VecMath<T> math;
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    private final String[] columnNames;
    private final ArrayList<Row> rows;

    public CalculatorModel(String[] columnNames, VecMath<T> mt) {
        this.columnNames = columnNames;
        this.math = mt;
        this.rows = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            this.rows.add(new Row());
        }
    }

    public void updateTable() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                for (TableModelListener l : CalculatorModel.this.listeners) {
                    l.tableChanged(new TableModelEvent(CalculatorModel.this));
                }
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.columnNames.length) {
            return this.columnNames[columnIndex];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int cIdx) {
        switch (cIdx) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return JComboBox.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rIdx, int cIdx) {
        switch (cIdx) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rIdx, int cIdx) {
        switch (cIdx) {
            case 0: {
                return rIdx + 1 + "";
            }
            case 1: {
                return this.rows.get(rIdx).exprs;
            }
            case 2: {
                return this.rows.get(rIdx).params;
            }
            case 3: {
                return this.rows.get(rIdx).mode ? MODE_ROOT : MODE_EVAL;
            }
            case 4: {
                Number retVal = this.rows.get(rIdx).result;
                if (retVal != null && this.math.util.precision(retVal) > this.math.PRECISION) {
                    retVal = this.math.util.copy(retVal, this.math.PRECISION);
                }
                return this.math.util.toPlainString(retVal);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object val, int rIdx, int cIdx) {
        switch (cIdx) {
            case 1: {
                this.rows.get(rIdx).exprs = (String)val;
                break;
            }
            case 2: {
                this.rows.get(rIdx).params = (String)val;
                break;
            }
            case 3: {
                this.rows.get(rIdx).mode = ((String)val).compareTo(MODE_ROOT) == 0;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void calculate() throws Exception {
        for (Row r : this.rows) {
            r.result = null;
        }
        this.updateTable();
        ExpressionTreeBuilder<T> builder = new ExpressionTreeBuilder<T>(this.math);
        ArrayList<Number> vals = new ArrayList<Number>();
        for (int i = 0; i < this.rows.size(); ++i) {
            Row r = this.rows.get(i);
            if (r.exprs == null || r.exprs.trim().compareTo("") == 0) {
                vals.add(null);
                continue;
            }
            try {
                final ExpressionTree<T> exprTree = builder.build(r.exprs);
                Number[] vs = vals.toArray(this.math.util.array(vals.size()));
                final HashMap map = exprTree.buildValueMap(r.params, vs);
                if (!r.mode) {
                    r.result = exprTree.calculate(map);
                } else {
                    String msg;
                    if (!exprTree.containsVariable("x")) {
                        msg = "Can't calculate root: Variable x is missing";
                        throw new Exception(msg);
                    }
                    if (!map.containsKey("x")) {
                        msg = "Can't calculate root: Initial value for variable x is missing.";
                        throw new Exception(msg);
                    }
                    IFunction f = new IFunction<T>(){

                        @Override
                        public T f(T arg) throws Exception {
                            map.put("x", arg);
                            return exprTree.calculate(map);
                        }
                    };
                    r.result = this.math.findRoot(f, (Number)map.get("x"));
                }
                vals.add(r.result);
                this.updateTable();
                continue;
            }
            catch (Exception ex) {
                int line = this.rows.indexOf(r) + 1;
                String msg = "Error in line " + line + ".\n" + ex.getMessage();
                throw new Exception(msg);
            }
        }
        this.updateTable();
    }

    public boolean isCleared() {
        for (Row r : this.rows) {
            if (r.result == null) continue;
            return false;
        }
        return true;
    }

    public void clearResults() {
        for (Row r : this.rows) {
            r.result = null;
        }
        this.updateTable();
    }

    public void removeRow(int row) {
        if (this.rows.size() > row) {
            this.rows.remove(row);
            if (!this.updateArgs(row, false)) {
                this.clearResults();
            }
            this.updateTable();
        }
    }

    public void insertRow(int row) {
        if (this.rows.size() >= row) {
            this.rows.add(row, new Row());
            this.updateArgs(row, true);
            this.updateTable();
        }
    }

    private boolean updateArgs(int row, boolean decOrInc) {
        boolean refOk = true;
        for (int k = row; k < this.rows.size(); ++k) {
            Row r = this.rows.get(k);
            if (r.params == null) continue;
            StringBuffer sb = new StringBuffer(r.params);
            int i1 = sb.indexOf("$");
            while (i1 != -1) {
                int i2 = sb.indexOf(",", i1);
                if (i2 == -1) {
                    i2 = sb.length();
                }
                short line = Short.parseShort(sb.substring(i1 + 1, i2).trim());
                if (decOrInc) {
                    if (line - 1 >= row) {
                        sb.replace(i1 + 1, i2, "" + (line + 1));
                    }
                } else if (line - 1 == row) {
                    sb.replace(i1 + 1, i2, "");
                    refOk = false;
                } else if (line - 1 > row) {
                    sb.replace(i1 + 1, i2, "" + (line - 1));
                }
                i1 = sb.indexOf("$", i2);
            }
            r.params = sb.toString();
        }
        return refOk;
    }

    private class Row {
        private String exprs;
        private String params;
        private boolean mode;
        private T result;
    }
}

