/*
 * Decompiled with CFR 0.152.
 */
import common.Globals;
import common.Log;
import javax.swing.UIManager;
import math.VecMathApfloat;
import mvc.AnimatePatterns;
import mvc.Controller;

public class FroZenLight {
    private static final String usage = "Usage: mvc.Controller [-h][-v][-o][-f][-w[w]][-[win]scr][-e TEXT]\n[-c THEME][-r RADIUS][-d FILE][-u URL][-a [SPEED]][-l PATTERN]\n\n-h          Help: prints this message.\n-v          Verbose: logs some details usefull for debugging.\n-t TIME     TIME is given in seconds and defines how long a\n            pattern is shown in the animation.\n-a [SPEED]  Animation: starts the application with a running\n            pattern animation. The parameter SPEED = 0,1,2,3,4 is\n            optional. Default is 2.\n-c THEME    Preselects the given color theme. See config/themes\n            directory for possible values (e.g. Brown).\n-r RADIUS   Preselects the given radius which must be a percent\n            value like 33.33333333333333333333333%.Default is 50%\n-l PATTERN  Calculates and shows the given light pattern at start\n            up.See config/patterns directory for possible values\n            (e.g. Triangle).\n-e TEXT     Enigma mode: calculates the pattern for the given\n             TEXT and shows it at start up if -w(w) is ommited.\n-w          No window: only useful in combination with -l or -e.\n            The application terminates after the pattern has been\n            calculated and writes the result into a file in the\n            .frozenlight/records dir. The record name for -e\n            option is \"Text: ...\".\n-ww         The same as -w but writes only the record out to the\n            console instead of creating a record file.\n-o          Writes estimated calculation time and progress info\n            out to the console. Useful in combination with -l \n            or -e and -w(w).\n-d FILE     Decode FILE: The file has been created with -w(w) or\n            should look like those found in the config/records\n            directory but with just one data set. The -r option\n            overwrites the radius value in the file. The pattern\n            becomes immediately visible when the main window\n            appears.\n-f          Fullscreen mode without window decoration.\n-mu         Museums view for touchscreens (fullscreen). Terminate\n            with ESC or CTRL-X buttons.\n-scr        Screensaver: Terminates on key press or mouse click.\n-winscr     Like -scr but needs a /b for starting (windows).\n";

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pattern = null;
        String theme = null;
        String text = null;
        String radius = null;
        String record = null;
        byte anim = -1;
        int win = 0;
        boolean winScr = false;
        boolean info = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].compareTo("-h") == 0) {
                    System.out.println(usage);
                    System.exit(0);
                    continue;
                }
                if (args[i].compareTo("-v") == 0) {
                    Globals.LOG_VERBOSE = true;
                    continue;
                }
                if (args[i].compareTo("-t") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        long t = Integer.parseInt(args[i]);
                        if (t < 0L) continue;
                        AnimatePatterns.ANIM_SHOW_TIME = t * 1000L;
                        continue;
                    }
                    throw new Exception("Time is missing for option -t");
                }
                if (args[i].compareTo("-a") == 0) {
                    anim = AnimatePatterns.ANIM_PAT_SPEEDS[2];
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue;
                    byte b = Byte.parseByte(args[++i]);
                    anim = AnimatePatterns.ANIM_PAT_SPEEDS[b];
                    continue;
                }
                if (args[i].compareTo("-w") == 0) {
                    win = 3;
                    continue;
                }
                if (args[i].compareTo("-ww") == 0) {
                    win = 4;
                    continue;
                }
                if (args[i].compareTo("-o") == 0) {
                    info = true;
                    continue;
                }
                if (args[i].compareTo("-f") == 0) {
                    if (win == 2) continue;
                    if (win == 5) {
                        win = 6;
                        continue;
                    }
                    win = 1;
                    continue;
                }
                if (args[i].compareTo("-l") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        pattern = args[i];
                        continue;
                    }
                    throw new Exception("Pattern name is missing for option -l");
                }
                if (args[i].compareTo("-c") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        theme = args[i];
                        continue;
                    }
                    throw new Exception("Theme name is missing for option -c");
                }
                if (args[i].compareTo("-r") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        int k = args[i].indexOf("%");
                        if (k == -1) {
                            radius = args[i];
                            continue;
                        }
                        radius = args[i].substring(0, k);
                        continue;
                    }
                    throw new Exception("Value is missing for option -r");
                }
                if (args[i].compareTo("-e") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        text = args[i];
                        continue;
                    }
                    throw new Exception("Text is missing for option -e");
                }
                if (args[i].compareTo("-d") == 0) {
                    if (++i < args.length && !args[i].startsWith("-")) {
                        record = args[i];
                        continue;
                    }
                    throw new Exception("Record file is missing for option -d");
                }
                if (args[i].compareTo("-mu") == 0) {
                    if (win == 2) continue;
                    if (win == 1) {
                        win = 6;
                        continue;
                    }
                    win = 5;
                    continue;
                }
                if (args[i].compareTo("-scr") == 0) {
                    win = 2;
                    continue;
                }
                if (args[i].compareTo("-winscr") == 0) {
                    winScr = true;
                    win = 2;
                    continue;
                }
                if (args[i].compareToIgnoreCase("/s") == 0) {
                    winScr = false;
                    continue;
                }
                if (args[i].startsWith("/")) continue;
                throw new Exception("Unrecognized option: " + args[i]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (winScr) {
            System.exit(0);
        }
        if (win == 4) {
            Log.getIstc().enableLogging(false);
        }
        short p = Globals.PRECISIONS[Globals.IDX_PREC];
        VecMathApfloat mt = new VecMathApfloat(p, false);
        Controller.launch(mt, radius, pattern, theme, text, record, anim, (byte)win, info);
    }
}

