uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Euclidean interpretation:  inverse square of distance at which fog saturates

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec3			atrNormal;

out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec4	tmpPositionEC,		//	vertex's position in eye coordinates
			tmpNormal,			//	normal vector at tmpPositionEC
			tmpLightDirection;	//	light direction at tmpPositionEC; runs along Clifford parallels
	float	tmpFogValue,		//	0.0 = bright;  1.0 = dark
			tmpFogCoef,			//	0.0 = dark;    1.0 = bright
			tmpDotProduct,
			tmpDiffuseFactor,
			tmpBrightness;
	
	const vec4	cntColor = vec4(0.5, 0.5, 0.5, 1.0);	//	premultiplied alpha
	
	gl_Position			= atrModelViewProjectionMatrix * atrPosition;

	//	Whether we use the true distance d or the coordinate w = cos(d)
	//	to compute the fog, the results come out nearly identical.
	//	So let's stick with w, to reduce the computational load.
	//
	//	Just for the record, here's the "true distance" version
	//	that we are *not* using:
	//
	//		#define PI_INVERSE	0.31830988618379067154
	//
	//		tmpFogValue	= acos(clamp(tmpPositionEC.w, -1.0, 1.0)) * PI_INVERSE;
	//
	tmpPositionEC		= atrModelViewMatrix * atrPosition;
	tmpFogValue			= uniFogRangeParameter * (0.5 - 0.5*tmpPositionEC.w);
	tmpFogCoef			= 1.0 - uniFogFactor*tmpFogValue;

	//	This computation of tmpNormalEC relies on the fact that atrModelViewMatrix
	//	rescales only in the direction perpendicular to the plane of the normal vectors.
	tmpNormal			= atrModelViewMatrix * vec4(atrNormal, 0.0);
	tmpLightDirection	= vec4(-tmpPositionEC.y, tmpPositionEC.x, -tmpPositionEC.w, tmpPositionEC.z);
	tmpDotProduct		= dot(tmpLightDirection, tmpNormal);
	tmpDiffuseFactor	= 0.25 + 0.75 * max(0.0, tmpDotProduct);

	tmpBrightness		= tmpFogCoef * tmpDiffuseFactor;

	varColor			= cntColor * vec4(tmpBrightness, tmpBrightness, tmpBrightness, 1.0);
}
