uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Euclidean interpretation:  inverse square of distance at which fog saturates

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec3			atrNormal;

out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec4	tmpPositionEC,		//	vertex's position in eye coordinates
			tmpNormal,			//	normal vector at tmpPositionEC
			tmpLightDirection;	//	light direction at tmpPositionEC
	float	tmpFogValue,		//	0.0 = bright;  1.0 = dark
			tmpFogCoef,			//	0.0 = dark;    1.0 = bright
			tmpHorizontal,		//	- √(x² + y² + z²)
			tmpDotProduct,
			tmpDiffuseFactor,
			tmpBrightness;
	
	const vec4	cntColor	= vec4(0.75, 0.75, 0.75, 1.00);	//	premultiplied alpha
	const float	cntInvFudge	= 0.25;	//	inverse of "fudge factor" in theDilation in ConvertBondEndpointsToBondPlacement()

	gl_Position			= atrModelViewProjectionMatrix * atrPosition;

	//	Let the fog be proportional to
	//
	//		log(w) = log(cosh(d)) ≈ log(exp(d)/2) = d - log(2)
	//
	tmpPositionEC	= atrModelViewMatrix * atrPosition;
	tmpFogValue		= uniFogRangeParameter * log(tmpPositionEC.w);
	tmpFogCoef		= 1.0 - uniFogFactor*tmpFogValue;

	//	This computation of tmpNormalEC relies on the fact that atrModelViewMatrix
	//	rescales only in the direction perpendicular to the plane of the normal vectors.
	tmpNormal			= atrModelViewMatrix * vec4(atrNormal, 0.0);
	
	//	Let the light direction be
	//
	//		      -w * x           -w * y           -w * z
	//		( ---------------, ---------------, ---------------, -√(x² + y² + z²) ) 
	//		  √(x² + y² + z²)  √(x² + y² + z²)  √(x² + y² + z²)  
	//
	//	That choice is somewhat arbitrary, but seems plausible and in any case
	//	it has unit length.
	//
	//	As a practical matter, omit the minus sign in the last component
	//	in anticipation of taking the dot product relative to the Minkowski metric +++-.
	tmpHorizontal		= length(vec3(tmpPositionEC));
	tmpLightDirection	= vec4((-tmpPositionEC.w/tmpHorizontal)*vec3(tmpPositionEC), tmpHorizontal);
	tmpDotProduct		= dot(tmpLightDirection, tmpNormal);
	tmpDiffuseFactor	= cntInvFudge*(0.25 + 0.75 * max(0.0, tmpDotProduct));

	tmpBrightness	= tmpFogCoef * tmpDiffuseFactor;

	varColor		= cntColor * vec4(tmpBrightness, tmpBrightness, tmpBrightness, 1.0);
}
