uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Euclidean interpretation:  inverse square of distance at which fog saturates

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec3			atrNormal;

out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec3	tmpPositionEC,		//	vertex's position in eye coordinates
			tmpNormalEC;		//	normal vector in eye coordinates
	float	tmpFogValue,		//	0.0 = bright;  1.0 = dark
			tmpFogCoef,			//	0.0 = dark;    1.0 = bright
			tmpDiffuseFactor,
			tmpBrightness;
	
	const vec4	cntColor = vec4(0.5, 0.5, 0.5, 1.0);	//	premultiplied alpha
	
	gl_Position			= atrModelViewProjectionMatrix * atrPosition;

	tmpPositionEC		= vec3(atrModelViewMatrix * atrPosition);
	tmpFogValue			= min(uniFogRangeParameter * dot(tmpPositionEC, tmpPositionEC), 1.0);
	tmpFogCoef			= 1.0 - uniFogFactor*tmpFogValue;

	//	This computation of tmpNormalEC relies on the fact that atrModelViewMatrix
	//	rescales only in the direction perpendicular to the plane of the normal vectors.
	tmpNormalEC			= vec3(atrModelViewMatrix * vec4(atrNormal, 0.0));
	tmpDiffuseFactor	= 0.25 + 0.75 * max(0.0, -tmpNormalEC.z);

	tmpBrightness		= tmpFogCoef * tmpDiffuseFactor;

	varColor			= cntColor * vec4(tmpBrightness, tmpBrightness, tmpBrightness, 1.0);
}
