uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Hyperbolic interpretation:  1.0 / log(cosh(distance at which fog saturates))

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
//in vec3		atrDiffuseEvaluator;
in vec4			atrPosition;
in vec4			atrColor;				//	premultiplied alpha

out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec4	tmpPositionEC,		//	vertex's position in eye coordinates
			tmpNormal,			//	normal vector at tmpPositionEC
			tmpLightDirection;	//	light direction at tmpPositionEC
	float	tmpFogValue,		//	0.0 = bright;  1.0 = dark
			tmpFogCoef,			//	0.0 = dark;    1.0 = bright
			tmpHorizontal,		//	- √(x² + y² + z²)
			tmpDotProduct,
			tmpDiffuseFactor,
			tmpBrightness;
	
	//	Kludge Alert:
	//	We multiply the normal vector by atrModelViewMatrix,
	//	even though atrModelViewMatrix includes a contraction factor.
	//	To avoid the overhead of passing a separate compensating factor,
	//	let's just define the correction factor here.
	//	Yes, I know this is a complete kludge.
	//	Furthermore it's dangerous, because if I later change
	//	the size of the atom, this fudge factor won't automatically respond.
	const float	cntInverseAtomSize = 1.0 / 0.1875;

	gl_Position			= atrModelViewProjectionMatrix * atrPosition;

	//	Let the fog be proportional to
	//
	//		log(w) = log(cosh(d)) ≈ log(exp(d)/2) = d - log(2)
	//
	tmpPositionEC	= atrModelViewMatrix * atrPosition;
	tmpFogValue		= uniFogRangeParameter * log(tmpPositionEC.w);
	tmpFogCoef		= 1.0 - uniFogFactor*tmpFogValue;

	//	The position vector provides the normal vector.
	tmpNormal			= atrModelViewMatrix * vec4(vec3(atrPosition), 0.0);
	
	//	Let the light direction be
	//
	//		      -w * x           -w * y           -w * z
	//		( ---------------, ---------------, ---------------, -√(x² + y² + z²) ) 
	//		  √(x² + y² + z²)  √(x² + y² + z²)  √(x² + y² + z²)  
	//
	//	That choice is somewhat arbitrary, but seems plausible and in any case
	//	it has unit length.
	//
	//	As a practical matter, omit the minus sign in the last component
	//	in anticipation of taking the dot product relative to the Minkowski metric +++-.
	tmpHorizontal		= length(vec3(tmpPositionEC));
	tmpLightDirection	= vec4((-tmpPositionEC.w/tmpHorizontal)*vec3(tmpPositionEC), tmpHorizontal);
	tmpDotProduct		= cntInverseAtomSize * dot(tmpLightDirection, tmpNormal);
	tmpDiffuseFactor	= 0.25 + 0.75 * max(0.0, tmpDotProduct);

	tmpBrightness		= tmpFogCoef * tmpDiffuseFactor;

	varColor			= atrColor * vec4(tmpBrightness, tmpBrightness, tmpBrightness, 1.0);
}
