uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	spherical interpretation:  fog saturation at antipode

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec2			atrTextureCoordinates;
in vec4			atrColor;				//	premultiplied alpha

out vec2		varTextureCoordinates;
out vec4		varColor;				//	premultiplied alpha


void main()
{
	float	tmpW,			//	vertex's w-coordinate in eye coordinates
			tmpFogValue,	//	0.0 = bright;  1.0 = dark
			tmpFogCoef;		//	0.0 = dark;    1.0 = bright
	
	gl_Position = atrModelViewProjectionMatrix * atrPosition;

	varTextureCoordinates = atrTextureCoordinates;

	//	Whether we use the true distance d or the coordinate w = cos(d)
	//	to compute the fog, the results come out nearly identical.
	//	So let's stick with w, to reduce the computational load.
	//
	//	Just for the record, here's the "true distance" version
	//	that we are *not* using:
	//
	//		#define PI_INVERSE	0.31830988618379067154
	//
	//		tmpFogValue	= acos(clamp(tmpW,-1.0,1.0)) * PI_INVERSE;
	//
	tmpW		= dot(atrModelViewMatrix[3], atrPosition);
	tmpFogValue	= uniFogRangeParameter * (0.5 - 0.5*tmpW);
	tmpFogCoef	= 1.0 - uniFogFactor*tmpFogValue;
	varColor	= vec4(tmpFogCoef, tmpFogCoef, tmpFogCoef, 1.0) * atrColor;
}
