uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	hyperbolic interpretation:  1 / (cosh(max_r) - 1)

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec2			atrTextureCoordinates;
in vec4			atrColor;				//	premultiplied alpha

out vec2		varTextureCoordinates;
out vec4		varColor;				//	premultiplied alpha


void main()
{
	float	tmpW,			//	vertex's w-coordinate in eye coordinates
			tmpFogValue,	//	0.0 = bright;  1.0 = dark
			tmpFogCoef;		//	0.0 = dark;    1.0 = bright
	
	gl_Position = atrModelViewProjectionMatrix * atrPosition;

	varTextureCoordinates = atrTextureCoordinates;

	//	Let the fog be proportional to
	//
	//		log(w) = log(cosh(d)) ≈ log(exp(d)/2) = d - log(2)
	//
	tmpW		= dot(atrModelViewMatrix[3], atrPosition);
	tmpFogValue	= uniFogRangeParameter * log(tmpW);
	tmpFogCoef	= 1.0 - uniFogFactor*tmpFogValue;
	varColor	= vec4(tmpFogCoef, tmpFogCoef, tmpFogCoef, 1.0) * atrColor;
}
