uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Euclidean interpretation:  inverse square of distance at which fog saturates

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec4			atrPosition;
in vec2			atrTextureCoordinates;
in vec4			atrColor;				//	premultiplied alpha

out vec2		varTextureCoordinates;
out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec3	tmpPositionEC;	//	vertex's position in eye coordinates
	float	tmpFogValue,	//	0.0 = bright;  1.0 = dark
			tmpFogCoef;		//	0.0 = dark;    1.0 = bright
	
	gl_Position				= atrModelViewProjectionMatrix * atrPosition;
	varTextureCoordinates	= atrTextureCoordinates;
	tmpPositionEC			= vec3(atrModelViewMatrix * atrPosition);
	tmpFogValue				= min(uniFogRangeParameter * dot(tmpPositionEC, tmpPositionEC), 1.0);
	tmpFogCoef				= 1.0 - uniFogFactor*tmpFogValue;
	varColor				= vec4(tmpFogCoef, tmpFogCoef, tmpFogCoef, 1.0) * atrColor;
}
