uniform float	uniFogFactor,			//	0.0 = off;  1.0 = on
				uniFogRangeParameter;	//	Euclidean interpretation:  inverse square of distance at which fog saturates

in mat4			atrModelViewProjectionMatrix,
				atrModelViewMatrix;
in vec3			atrDiffuseEvaluator;
in vec4			atrPosition;
in vec4			atrColor;				//	premultiplied alpha

out vec4		varColor;				//	premultiplied alpha


void main()
{
	vec3	tmpPositionEC;		//	vertex's position in eye coordinates
	float	tmpFogValue,		//	0.0 = bright;  1.0 = dark
			tmpFogCoef,			//	0.0 = dark;    1.0 = bright
			tmpDiffuseFactor,
			tmpBrightness;
	
	gl_Position			= atrModelViewProjectionMatrix * atrPosition;

	tmpPositionEC		= vec3(atrModelViewMatrix * atrPosition);
	tmpFogValue			= min(uniFogRangeParameter * dot(tmpPositionEC, tmpPositionEC), 1.0);
	tmpFogCoef			= 1.0 - uniFogFactor*tmpFogValue;

	//	The position vector serves as the normal vector.
	tmpDiffuseFactor	= 0.25 + 0.75 * max(0.0, dot(atrDiffuseEvaluator, vec3(atrPosition)));

	tmpBrightness		= tmpFogCoef * tmpDiffuseFactor;

	varColor			= atrColor * vec4(tmpBrightness, tmpBrightness, tmpBrightness, 1.0);
}
