/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JFrame;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.Util;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.HTMLDocWindow;
import vmm.xm3d.LauncherApplet;
import vmm.xm3d.Menus;

public class WindowXM
extends JFrame {
    private static int openWindowCount;
    private static WindowXM activeWindow;
    private static HTMLDocWindow htmlDocWindow;
    private Menus menus;
    private DisplayXM display;
    private LauncherApplet launcherApplet;

    public DisplayXM getDisplay() {
        return this.display;
    }

    public View getView() {
        return this.display.getView();
    }

    public Exhibit getExhibit() {
        return this.display.getExhibit();
    }

    Menus getMenus() {
        return this.menus;
    }

    public WindowXM() {
        this((WindowXM)null);
    }

    public static void showHTMLDocWindow(String string) {
        if (htmlDocWindow == null) {
            htmlDocWindow = new HTMLDocWindow();
        }
        htmlDocWindow.showFile(string);
    }

    public static void showHTMLDocWindow(URL uRL) {
        if (htmlDocWindow == null) {
            htmlDocWindow = new HTMLDocWindow();
        }
        htmlDocWindow.showURL(uRL);
    }

    public WindowXM(WindowXM windowXM) {
        this(windowXM, null, 0);
    }

    WindowXM(int n) {
        this(null, null, n);
    }

    WindowXM(LauncherApplet launcherApplet, int n) {
        this(null, launcherApplet, n);
    }

    private WindowXM(WindowXM windowXM, LauncherApplet launcherApplet, int n) {
        super(I18n.tr("3dxm.window.defaultname"));
        if (launcherApplet != null) {
            this.launcherApplet = launcherApplet;
        } else if (windowXM != null) {
            this.launcherApplet = windowXM.launcherApplet;
        }
        this.setDefaultCloseOperation(2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = dimension.width * 3 / 4;
        if (n2 > 800) {
            n2 = 800;
        }
        int n3 = (int)((double)n2 / 1.628);
        if (n2 > dimension.width - 40) {
            n2 = dimension.width - 40;
        }
        if (n3 > dimension.height - 60) {
            n3 = dimension.height - 60;
        }
        if (activeWindow != null) {
            WindowXM.activeWindow.display.discardFilmstrip();
        }
        this.display = new DisplayXM();
        this.display.setPreferredSize(new Dimension(n2, n3));
        this.setContentPane(this.display.getHolder());
        int n4 = 0;
        if (n != 0) {
            n4 = n;
        } else if (windowXM != null) {
            n4 = windowXM.getMenus().getOptionFlags();
        }
        this.menus = new Menus(this, null, n4);
        this.setJMenuBar(this.menus);
        this.pack();
        if (windowXM == null) {
            if (Util.isMacOS()) {
                this.setLocation(30, 35);
            } else {
                this.setLocation((dimension.width - n2) / 2, 35);
            }
        } else {
            Point point = windowXM.getLocation();
            int n5 = point.x + 40;
            int n6 = point.y + 30;
            if (n5 + this.getWidth() > dimension.width) {
                n5 = 20;
            }
            if (n6 + this.getHeight() > dimension.height) {
                n6 = 40;
            }
            this.setLocation(n5, n6);
        }
        ++openWindowCount;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (WindowXM.this.launcherApplet != null) {
                    WindowXM.this.launcherApplet.windowOpened(WindowXM.this);
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                WindowXM.this.display.stopAnimation();
                WindowXM.this.display.install(null, null);
                openWindowCount--;
                if (WindowXM.this.launcherApplet != null) {
                    WindowXM.this.launcherApplet.windowClosed(WindowXM.this);
                }
                if (openWindowCount == 0 && WindowXM.this.launcherApplet == null) {
                    System.exit(0);
                }
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (activeWindow != WindowXM.this) {
                    if (activeWindow != null) {
                        activeWindow.display.stopAnimation();
                        activeWindow.display.discardFilmstrip();
                    }
                    activeWindow = WindowXM.this;
                }
            }
        });
        this.display.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("preferredSize")) {
                    WindowXM.this.display.invalidate();
                    WindowXM.this.validate();
                    WindowXM.this.pack();
                }
            }
        });
    }

    static {
        I18n.addFile("vmm.xm3d.stringsXM");
    }
}

