/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.Display;
import vmm.core.Filmstrip;
import vmm.core.I18n;

class SavedAnimationSupport {
    SavedAnimationSupport() {
    }

    static boolean saveAnimation(Component component, OutputStream outputStream, Filmstrip filmstrip, boolean bl, String string) throws IOException {
        filmstrip.stripNullFrames();
        if (filmstrip.getFrameCount() < 2) {
            throw new IOException(I18n.tr("3dxm.AnimationSupport.NoFrames"));
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[filmstrip.getFrameCount()];
        for (int i = 0; i < filmstrip.getFrameCount(); ++i) {
            bufferedImageArray[i] = filmstrip.getFrame(i);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("3dxm_animation_file_format_version=1\n");
        stringBuffer.append("format=" + string + "\n");
        stringBuffer.append("frames=" + filmstrip.getFrameCount() + "\n");
        stringBuffer.append("width=" + bufferedImageArray[0].getWidth() + "\n");
        stringBuffer.append("height=" + bufferedImageArray[0].getHeight() + "\n");
        stringBuffer.append("cyclic=" + bl + "\n");
        String string2 = stringBuffer.toString();
        ZipEntry zipEntry = new ZipEntry("metadata.txt");
        zipOutputStream.putNextEntry(zipEntry);
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        printWriter.print(string2);
        printWriter.flush();
        zipOutputStream.closeEntry();
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        ProgressDialog progressDialog = new ProgressDialog((Frame)component, I18n.tr("3dxm.AnimationSupport.SavingFrameNumber", "1", "" + bufferedImageArray.length));
        progressDialog.setLocation(component.getX() + 50, component.getY() + 50);
        FrameSaver frameSaver = new FrameSaver(string, bufferedImageArray, zipOutputStream, progressDialog);
        frameSaver.start();
        progressDialog.setVisible(true);
        if (frameSaver.errorMessage != null) {
            throw new IOException(frameSaver.errorMessage);
        }
        return !frameSaver.canceled;
    }

    static void readAndPlay(Display display, ZipFile zipFile) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        Serializable serializable;
        Object object;
        display.setCursor(Cursor.getPredefinedCursor(3));
        try {
            object = zipFile.getEntry("metadata.txt");
            if (object == null) {
                throw new Exception();
            }
            serializable = new Properties();
            ((Properties)serializable).load(zipFile.getInputStream((ZipEntry)object));
            if (((Properties)serializable).get("3dxm_animation_file_format_version") == null) {
                throw new Exception();
            }
            if ("JPEG".equalsIgnoreCase((String)((Properties)serializable).get("format"))) {
                string = "JPEG";
            } else if ("PNG".equalsIgnoreCase((String)((Properties)serializable).get("format"))) {
                string = "PNG";
            } else {
                throw new Exception();
            }
            n4 = Integer.parseInt((String)((Properties)serializable).get("frames"));
            if (n4 < 2) {
                throw new Exception();
            }
            n3 = Integer.parseInt((String)((Properties)serializable).get("width"));
            if (n3 <= 0) {
                throw new Exception();
            }
            n2 = Integer.parseInt((String)((Properties)serializable).get("height"));
            if (n2 <= 0) {
                throw new Exception();
            }
            n = ((Properties)serializable).get("cyclic").equals("true") ? 1 : 2;
        }
        catch (Exception exception) {
            display.setCursor(Cursor.getDefaultCursor());
            throw new IOException(I18n.tr("3dxm.AnimationSupport.BadAnimationFileFormat"));
        }
        display.discardFilmstrip();
        object = new Filmstrip();
        for (serializable = display; serializable != null && !(serializable instanceof Frame); serializable = ((Component)serializable).getParent()) {
        }
        try {
            for (int i = 0; i < n4; ++i) {
                display.setStatusText(I18n.tr("3dxm.AnimationSupport.status.ReadingFrameFromFile", i + 1));
                ZipEntry zipEntry = zipFile.getEntry("frame" + i + "." + string.toLowerCase());
                if (zipEntry == null) {
                    throw new Exception();
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage == null) {
                        throw new Exception();
                    }
                    ((Filmstrip)object).setFrame(i, bufferedImage);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (i < 4) {
                        object = null;
                        JOptionPane.showMessageDialog(display, I18n.tr("3dxm.AnimationSupport.OutOfMemoryCantPlay"), I18n.tr("3dxm.dialog.errormessage.title"), 0);
                        display.setCursor(Cursor.getDefaultCursor());
                        display.setStatusText();
                        return;
                    }
                    ((Filmstrip)object).setFrame(i - 1, null);
                    if (0 == JOptionPane.showConfirmDialog(display, I18n.tr("3dxm.AnimationSupport.OutOfMemoryDialogQuestion", i - 1, n4), I18n.tr("3dxm.AnimationSupport.OutOfMemoryDialogTitle"), 0)) {
                        ((Filmstrip)object).stripNullFrames();
                        break;
                    }
                    display.setCursor(Cursor.getDefaultCursor());
                    display.setStatusText();
                    return;
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            display.setCursor(Cursor.getDefaultCursor());
            display.setStatusText();
            throw new IOException(I18n.tr("3dxm.AnimationSupport.ErrorWhileReadingAnimationFrames"));
        }
        display.playFilmstrip((Filmstrip)object, n, new Dimension(n3, n2));
    }

    private static class FrameSaver
    extends Thread {
        String format;
        BufferedImage[] frames;
        ZipOutputStream out;
        ProgressDialog progressDialog;
        volatile boolean canceled = true;
        volatile String errorMessage;

        FrameSaver(String string, BufferedImage[] bufferedImageArray, ZipOutputStream zipOutputStream, ProgressDialog progressDialog) {
            this.format = string;
            this.frames = bufferedImageArray;
            this.out = zipOutputStream;
            this.progressDialog = progressDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                for (int i = 0; i < this.frames.length; ++i) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ZipEntry zipEntry = new ZipEntry("frame" + i + "." + this.format.toLowerCase());
                    try {
                        this.out.putNextEntry(zipEntry);
                        if (!ImageIO.write((RenderedImage)this.frames[i], this.format, this.out)) {
                            throw new IOException();
                        }
                        this.out.closeEntry();
                    }
                    catch (IOException iOException) {
                        this.errorMessage = I18n.tr("3dxm.AnimationSupport.CantWriteFile");
                        this.canceled = false;
                        if (!this.progressDialog.canceled) {
                            this.progressDialog.dispose();
                        }
                        return;
                    }
                    if (this.progressDialog.canceled) {
                        return;
                    }
                    if (i >= this.frames.length - 1) continue;
                    this.progressDialog.setNote(I18n.tr("3dxm.AnimationSupport.SavingFrameNumber", "" + (i + 2), "" + this.frames.length));
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.errorMessage = I18n.tr("3dxm.AnimationSupport.CantWriteFile");
                }
                this.canceled = false;
            }
            finally {
                if (!this.progressDialog.canceled) {
                    this.progressDialog.dispose();
                }
            }
        }
    }

    private static class ProgressDialog
    extends JDialog
    implements ActionListener {
        JLabel message = new JLabel();
        volatile boolean canceled;

        ProgressDialog(Frame frame, String string) {
            super(frame, I18n.tr("3dxm.AnimationSupport.SavingAnimation"), true);
            JPanel jPanel = new JPanel();
            this.message = new JLabel(string + "   ");
            jPanel.add(this.message);
            JButton jButton = new JButton(I18n.tr("buttonNames.Cancel"));
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.setContentPane(jPanel);
            this.pack();
        }

        void setNote(String string) {
            this.message.setText(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.canceled = true;
            this.dispose();
        }
    }
}

