/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.Animateable;
import vmm.core.Animation;
import vmm.core.BasicAnimator;
import vmm.core.Exhibit;
import vmm.core.Filmstrip;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Prefs;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.Util;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.DocPrefsDialog;
import vmm.xm3d.Galleries;
import vmm.xm3d.SavedAnimationSupport;
import vmm.xm3d.WindowXM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menus
extends JMenuBar {
    static final int NO_FILE_SYSTEM = 1;
    static final int NO_ACCELERATORS = 2;
    static final int SINGLE_EXHIBIT = 4;
    static final int SINGLE_GALLERY = 8;
    static final int NO_EXIT = 16;
    private int optionFlags;
    private WindowXM window;
    private DisplayXM display;
    private JMenu fileMenu;
    private JMenu galleryMenu;
    private JMenu exhibitMenu;
    private JMenu actionMenu;
    private JMenu documentationMenu;
    private JMenu viewMenu;
    private JMenu settingsMenu;
    private JMenu animateMenu;
    private AbstractAction morphAction;
    private AbstractAction cyclicMorphAction;
    private AbstractAction playFilmstripAction;
    private AbstractAction saveAnimationAsPngAction;
    private AbstractAction saveAnimationAsJpegAction;
    private AbstractAction playSavedAnimationAction;
    private JMenu speedSubmenu;
    private JRadioButtonMenuItem speedSelect1;
    private JRadioButtonMenuItem speedSelect2;
    private JRadioButtonMenuItem speedSelect3;
    private JRadioButtonMenuItem speedSelect4;
    private AbstractAction saveAction;
    private AbstractAction newViewAction;
    private AbstractAction newSynchronizedViewAction;
    private JMenuItem saveAsPngCommand;
    private JMenuItem saveAsJpegCommand;
    private AbstractAction showATE;
    private AbstractAction showATG;
    private JFileChooser fileDialog;
    private Galleries galleries;
    private View[] alternativeViews;
    private JRadioButtonMenuItem[] viewSelect;
    public static final String FILE_EXTENSION = "3dxmj";

    public Menus(WindowXM windowXM) {
        this(windowXM, null, 0);
    }

    Menus(WindowXM windowXM, DisplayXM displayXM, int n) {
        this.window = windowXM;
        if (displayXM == null) {
            displayXM = windowXM.getDisplay();
        }
        this.display = displayXM;
        this.optionFlags = n;
        displayXM.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Status")) {
                    Menus.this.setUpForDisplayStatus((String)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("FilmstripAvailable")) {
                    Menus.this.setUpForDisplayFilmstrip((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.createMenus();
        if (windowXM != null) {
            this.add(this.fileMenu);
        }
        if ((n & 4) == 0 && (n & 8) == 0) {
            this.add(this.galleryMenu);
        }
        if ((n & 4) == 0) {
            this.add(this.exhibitMenu);
        }
        if ((n & 1) == 0) {
            this.add(this.documentationMenu);
        }
        this.add(this.actionMenu);
        this.add(this.settingsMenu);
        this.add(this.viewMenu);
        this.add(this.animateMenu);
        this.setUpMenusForNoExhibit();
    }

    int getOptionFlags() {
        return this.optionFlags;
    }

    void install(View view, Exhibit exhibit) {
        Animation animation;
        this.alternativeViews = null;
        this.viewSelect = null;
        if (this.window != null) {
            this.window.setTitle(exhibit.getTitle());
        }
        this.getAlternativeViews(exhibit);
        if (view == null) {
            view = this.alternativeViews == null ? exhibit.getDefaultView() : this.alternativeViews[0];
        }
        this.display.install(view, exhibit);
        this.setUpMenusForNewExhibit(view, exhibit);
        String string = this.galleries.findGalleryForExhibit(exhibit);
        if (string != null) {
            this.galleries.selectGalleryByName(string, this, this.exhibitMenu);
        }
        if ((animation = exhibit.getCreateAnimation(view)) != null) {
            this.display.installAnimation(animation);
        }
    }

    void installExhibit(Galleries.ExhibitItem exhibitItem) {
        Object object;
        Exhibit exhibit = null;
        View view = null;
        this.alternativeViews = null;
        this.viewSelect = null;
        if (exhibitItem != null && exhibitItem.isXML) {
            try {
                ArrayList<View> arrayList;
                object = this.getClass().getClassLoader();
                URL uRL = ((ClassLoader)object).getResource(exhibitItem.classname);
                InputStream inputStream = uRL.openStream();
                exhibit = SaveAndRestore.readExhibitFromXML(inputStream, exhibitItem.classname);
                if (exhibitItem.name != exhibitItem.classname) {
                    exhibit.setName(exhibitItem.name);
                }
                if ((arrayList = exhibit.getViews()) != null && arrayList.size() > 0) {
                    view = arrayList.get(0);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadXMLFile", exhibitItem.classname, exception.getMessage()));
                exception.printStackTrace();
            }
        } else if (exhibitItem != null) {
            try {
                exhibit = (Exhibit)Class.forName(exhibitItem.classname).newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadClassName", exhibitItem.classname));
                exception.printStackTrace();
            }
            if (exhibit instanceof UserExhibit && (view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().showCreateDialog(this.display)) == null) {
                return;
            }
        }
        if (exhibit == null) {
            if (this.window != null) {
                this.window.setTitle(I18n.tr("3dxm.window.defaultname"));
            }
            this.display.install(null, null);
            this.setUpMenusForNoExhibit();
            return;
        }
        if (this.window != null) {
            this.window.setTitle(exhibit.getTitle());
        }
        this.getAlternativeViews(exhibit);
        if (view == null) {
            view = this.alternativeViews == null ? exhibit.getDefaultView() : this.alternativeViews[0];
        }
        this.display.install(view, exhibit);
        this.setUpMenusForNewExhibit(view, exhibit);
        object = exhibit.getCreateAnimation(view);
        if (object != null) {
            this.display.installAnimation((Animation)object);
        }
    }

    private void getAlternativeViews(Exhibit exhibit) {
        View[] viewArray = exhibit.getAlternativeViews();
        if (viewArray != null) {
            this.alternativeViews = new View[viewArray.length + 1];
            this.alternativeViews[0] = exhibit.getDefaultView();
            for (int i = 0; i < viewArray.length; ++i) {
                this.alternativeViews[i + 1] = viewArray[i];
            }
        }
    }

    private void setUpForDisplayStatus(String string) {
        if (this.saveAction != null) {
            this.saveAction.setEnabled(string.equals("idle"));
        }
        this.newViewAction.setEnabled(string.equals("idle"));
        this.newSynchronizedViewAction.setEnabled(string.equals("idle"));
        if (this.saveAsJpegCommand != null) {
            this.saveAsJpegCommand.setEnabled(!string.equals("empty") && !string.equals("running"));
        }
        if (this.saveAsPngCommand != null) {
            this.saveAsPngCommand.setEnabled(!string.equals("empty") && !string.equals("running"));
        }
    }

    private void setUpForDisplayFilmstrip(boolean bl) {
        this.playFilmstripAction.setEnabled(bl);
        if (this.saveAnimationAsJpegAction != null) {
            this.saveAnimationAsJpegAction.setEnabled(bl);
        }
        if (this.saveAnimationAsPngAction != null) {
            this.saveAnimationAsPngAction.setEnabled(bl);
        }
    }

    private void setUpMenusForNoExhibit() {
        this.actionMenu.removeAll();
        this.viewMenu.removeAll();
        this.settingsMenu.removeAll();
        this.actionMenu.setEnabled(false);
        this.viewMenu.setEnabled(false);
        this.animateMenu.setEnabled(false);
        this.settingsMenu.setEnabled(false);
        this.checkATEandATG();
    }

    private void setUpMenusForNewExhibit(View view, Exhibit exhibit) {
        Object object;
        this.actionMenu.removeAll();
        this.actionMenu.setEnabled(false);
        ActionList actionList = view.getActionsForViewAndExhibit();
        if (actionList != null && actionList.getItemCount() > 0) {
            this.actionMenu.setEnabled(true);
            this.addMenuItems(actionList, this.actionMenu);
        }
        if (this.alternativeViews != null) {
            if (this.viewSelect == null) {
                ButtonGroup buttonGroup = new ButtonGroup();
                object = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = actionEvent.getSource();
                        for (int i = 0; i < Menus.this.alternativeViews.length; ++i) {
                            if (object != Menus.this.viewSelect[i]) continue;
                            Menus.this.swapInAlternativeView(Menus.this.alternativeViews[i]);
                            return;
                        }
                    }
                };
                this.viewSelect = new JRadioButtonMenuItem[this.alternativeViews.length];
                for (int i = 0; i < this.alternativeViews.length; ++i) {
                    this.viewSelect[i] = new JRadioButtonMenuItem(this.alternativeViews[i].getTitle());
                    buttonGroup.add(this.viewSelect[i]);
                    this.viewSelect[i].addActionListener((ActionListener)object);
                    if (this.alternativeViews[i] != view) continue;
                    this.viewSelect[i].setSelected(true);
                }
            }
            if (this.actionMenu.getMenuComponentCount() > 0) {
                this.actionMenu.addSeparator();
            }
            for (int i = 0; i < this.alternativeViews.length; ++i) {
                this.actionMenu.add(this.viewSelect[i]);
            }
            this.actionMenu.setEnabled(true);
        }
        ActionList actionList2 = view.getViewCommands();
        this.viewMenu.removeAll();
        if (actionList2 != null && actionList2.getItemCount() > 0) {
            this.viewMenu.setEnabled(true);
            this.addMenuItems(actionList2, this.viewMenu);
        } else {
            this.viewMenu.setEnabled(false);
        }
        object = view.getSettingsCommandsForViewAndExhibit();
        this.settingsMenu.removeAll();
        if (object != null && ((ActionList)object).getItemCount() > 0) {
            this.settingsMenu.setEnabled(true);
            this.addMenuItems((ActionList)object, this.settingsMenu);
        } else {
            this.settingsMenu.setEnabled(false);
        }
        ActionList actionList3 = view.getAdditionalAnimationsForViewAndExhibit();
        this.animateMenu.removeAll();
        this.animateMenu.add(this.speedSubmenu);
        this.animateMenu.addSeparator();
        this.animateMenu.add(this.morphAction);
        this.animateMenu.add(this.cyclicMorphAction);
        this.animateMenu.addSeparator();
        if (actionList3 != null && actionList3.getItemCount() > 0) {
            this.addMenuItems(actionList3, this.animateMenu);
            this.animateMenu.addSeparator();
        }
        this.animateMenu.add(this.playFilmstripAction);
        this.animateMenu.setEnabled(true);
        Parameter[] parameterArray = view.getViewAndExhibitParameters();
        boolean bl = false;
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable)) continue;
            bl = true;
            break;
        }
        this.galleries.setUpExhibitMenu(this, this.exhibitMenu);
        if (exhibit instanceof UserExhibit) {
            if (((UserExhibit)((Object)exhibit)).getUserExhibitSupport().getAllowNewParameters()) {
                bl = true;
            }
            if (((UserExhibit)((Object)exhibit)).getUserExhibitSupport().getAllowChangeUserDataCommand()) {
                AbstractActionVMM abstractActionVMM = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().makeChangeUserDataAction(view);
                this.exhibitMenu.addSeparator();
                this.exhibitMenu.add(abstractActionVMM);
            }
        }
        this.speedSelect1.setSelected(true);
        this.display.setTimeDilationForAnimations(1.0);
        this.morphAction.setEnabled(bl);
        this.cyclicMorphAction.setEnabled(bl);
        this.checkATEandATG();
    }

    private void swapInAlternativeView(View view) {
        if (this.display.getView() == view || this.display.getExhibit() == null) {
            return;
        }
        Exhibit exhibit = this.display.getExhibit();
        view.takeExhibit(this.display.getView(), true);
        this.display.install(view, exhibit);
        Animation animation = exhibit.getCreateAnimation(view);
        if (animation != null) {
            this.display.installAnimation(animation);
        }
        this.setUpMenusForNewExhibit(view, exhibit);
    }

    private void addMenuItems(ActionList actionList, JMenu jMenu) {
        if (actionList != null) {
            for (int i = 0; i < actionList.getItemCount(); ++i) {
                JMenuItem[] jMenuItemArray;
                if (actionList.getItem(i) == null) {
                    jMenu.addSeparator();
                    continue;
                }
                for (JMenuItem jMenuItem : jMenuItemArray = actionList.getItem(i).getMenuItems()) {
                    if (jMenuItem == null) {
                        jMenu.addSeparator();
                        continue;
                    }
                    if ((this.optionFlags & 2) != 0) {
                        if (jMenuItem instanceof JMenu) {
                            int n = ((JMenu)jMenuItem).getMenuComponentCount();
                            for (int j = 0; j < n; ++j) {
                                Component component = ((JMenu)jMenuItem).getMenuComponent(j);
                                if (component == null || !(component instanceof JMenuItem) || component instanceof JMenu) continue;
                                ((JMenuItem)component).setAccelerator(null);
                            }
                        } else {
                            jMenuItem.setAccelerator(null);
                        }
                    }
                    jMenu.add(jMenuItem);
                }
            }
        }
    }

    private void createMenus() {
        Object object;
        String string;
        boolean bl = (this.optionFlags & 1) != 0;
        boolean bl2 = (this.optionFlags & 2) != 0;
        this.fileMenu = new JMenu(bl ? I18n.tr("3dxm.menus.LauncherApplet.WindowsMenuName") : I18n.tr("3dxm.menus.fileMenuName"));
        this.galleryMenu = new JMenu(I18n.tr("3dxm.menus.galleryMenuName"));
        this.actionMenu = new JMenu(I18n.tr("3dxm.menus.actionMenuName"));
        this.exhibitMenu = new JMenu(I18n.tr("3dxm.gallery.PlaneCurves"));
        this.documentationMenu = new JMenu(I18n.tr("3dxm.menus.documentationMenuName"));
        this.viewMenu = new JMenu(I18n.tr("3dxm.menus.viewMenuName"));
        this.settingsMenu = new JMenu(I18n.tr("3dxm.menus.settingsMenuName"));
        this.animateMenu = new JMenu(I18n.tr("3dxm.menus.animateMenuName"));
        this.documentationMenu.add(new AbstractAction(I18n.tr("3dxm.command.documentation.GettingStarted")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                String string2 = I18n.getLocale().getLanguage().toLowerCase();
                if (!string2.equals("en")) {
                    string = "vmm/xm3d/getting_started_" + string2 + ".html";
                    if (this.getClass().getClassLoader().getResource(string) == null) {
                        string = null;
                    }
                }
                if (string == null) {
                    string = "vmm/xm3d/getting_started.html";
                }
                WindowXM.showHTMLDocWindow(string);
            }
        });
        this.documentationMenu.addSeparator();
        this.showATE = new AbstractAction(I18n.tr("3dxm.command.documentation.ATE")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Menus.this.display == null || Menus.this.display.getExhibit() == null) {
                    return;
                }
                String string = Menus.this.display.getExhibit().getName();
                Menus.this.showDocumentation(string + ".ATE.html");
            }
        };
        this.documentationMenu.add(this.showATE);
        this.showATG = new AbstractAction(I18n.tr("3dxm.command.documentation.ATG")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Menus.this.galleries.currentGalleryName();
                if (string == null) {
                    return;
                }
                Menus.this.showDocumentation(string + ".ATG.html");
            }
        };
        this.documentationMenu.add(this.showATG);
        this.documentationMenu.addSeparator();
        this.documentationMenu.add(new AbstractAction(I18n.tr("3dxm.command.documentation.DocPrefs")){

            public void actionPerformed(ActionEvent actionEvent) {
                new DocPrefsDialog(Menus.this.display).setVisible(true);
                Galleries.setDocumentationLocation();
                Menus.this.checkATEandATG();
            }
        });
        this.documentationMenu.add(new AbstractAction(I18n.tr("About the Documentation")){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.documentation.about.text"));
            }
        });
        try {
            this.galleries = new Galleries();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadGalleryInfo", iOException.toString()));
            System.exit(0);
        }
        this.galleries.setUpGalleryMenu(this, this.galleryMenu, this.exhibitMenu);
        if ((this.optionFlags & 4) == 0) {
            string = bl2 ? null : "N";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.New"), string){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowXM windowXM = new WindowXM(Menus.this.window);
                    if ((Menus.this.optionFlags & 8) != 0) {
                        String string = Menus.this.galleries.currentGalleryName();
                        Menus menus = windowXM.getMenus();
                        menus.galleries.selectGalleryByName(string, menus, menus.exhibitMenu);
                    }
                    windowXM.setVisible(true);
                }
            });
        }
        this.newViewAction = new AbstractAction(I18n.tr("3dxm.command.NewView")){

            public void actionPerformed(ActionEvent actionEvent) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                WindowXM windowXM = new WindowXM(Menus.this.window);
                windowXM.getMenus().getAlternativeViews(exhibit);
                View view = windowXM.getMenus().alternativeViews == null ? exhibit.getDefaultView() : windowXM.getMenus().alternativeViews[0];
                windowXM.getDisplay().install(view, exhibit);
                windowXM.getMenus().setUpMenusForNewExhibit(view, exhibit);
                windowXM.setTitle(Menus.this.window.getTitle());
                windowXM.getMenus().galleries.selectGalleryByName(Menus.this.galleries.currentGalleryName(), windowXM.getMenus(), windowXM.getMenus().exhibitMenu);
                windowXM.setVisible(true);
            }
        };
        this.newViewAction.setEnabled(false);
        this.fileMenu.add(this.newViewAction);
        this.newSynchronizedViewAction = new AbstractAction(I18n.tr("3dxm.command.NewViewShareTransform")){

            public void actionPerformed(ActionEvent actionEvent) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                WindowXM windowXM = new WindowXM(Menus.this.window);
                windowXM.getMenus().getAlternativeViews(exhibit);
                View view = windowXM.getMenus().alternativeViews == null ? exhibit.getDefaultView() : windowXM.getMenus().alternativeViews[0];
                view.takeExhibit(Menus.this.display.getView(), true);
                windowXM.getDisplay().install(view, null);
                windowXM.getMenus().setUpMenusForNewExhibit(view, exhibit);
                windowXM.setTitle(Menus.this.window.getTitle());
                windowXM.getMenus().galleries.selectGalleryByName(Menus.this.galleries.currentGalleryName(), windowXM.getMenus(), windowXM.getMenus().exhibitMenu);
                windowXM.setVisible(true);
            }
        };
        this.newSynchronizedViewAction.setEnabled(false);
        this.fileMenu.add(this.newSynchronizedViewAction);
        if (!bl) {
            string = bl2 ? null : "O";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Open"), string){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menus.this.doOpen();
                }
            });
            this.fileMenu.addSeparator();
            string = bl2 ? null : "S";
            this.saveAction = new AbstractActionVMM(I18n.tr("3dxm.command.Save"), string){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menus.this.doSave();
                }
            };
            this.saveAsJpegCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsJpeg"));
            this.saveAsPngCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsPng"));
            object = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == Menus.this.saveAsJpegCommand) {
                        Menus.this.doSaveImage("JPEG");
                    } else if (actionEvent.getSource() == Menus.this.saveAsPngCommand) {
                        Menus.this.doSaveImage("PNG");
                    }
                }
            };
            this.saveAnimationAsPngAction = new AbstractActionVMM(I18n.tr("3dxm.command.saveAnimationPngFormat")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menus.this.doSaveAnimation("PNG");
                }
            };
            this.saveAnimationAsPngAction.setEnabled(false);
            this.saveAnimationAsJpegAction = new AbstractActionVMM(I18n.tr("3dxm.command.saveAnimationJpegFormat")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menus.this.doSaveAnimation("JPEG");
                }
            };
            this.saveAnimationAsJpegAction.setEnabled(false);
            this.playSavedAnimationAction = new AbstractActionVMM(I18n.tr("3dxm.command.playSavedAnimation")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menus.this.doPlaySavedAnimation();
                }
            };
            this.saveAsJpegCommand.addActionListener((ActionListener)object);
            this.saveAsPngCommand.addActionListener((ActionListener)object);
            this.saveAction.setEnabled(false);
            this.saveAsJpegCommand.setEnabled(false);
            this.saveAsPngCommand.setEnabled(false);
            this.fileMenu.add(this.saveAction);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveAsPngCommand);
            this.fileMenu.add(this.saveAsJpegCommand);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveAnimationAsPngAction);
            this.fileMenu.add(this.saveAnimationAsJpegAction);
            this.fileMenu.add(this.playSavedAnimationAction);
        }
        this.fileMenu.addSeparator();
        string = bl2 ? null : "W";
        this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Close"), string){

            public void actionPerformed(ActionEvent actionEvent) {
                Menus.this.window.dispose();
            }
        });
        if ((this.optionFlags & 0x10) == 0) {
            string = bl2 ? null : "Q";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Quit"), string){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        string = bl2 ? null : "P";
        this.playFilmstripAction = new AbstractActionVMM(I18n.tr("3dxm.command.playback"), string){

            public void actionPerformed(ActionEvent actionEvent) {
                Menus.this.display.playFilmstrip();
            }
        };
        this.playFilmstripAction.setEnabled(false);
        this.morphAction = new AbstractAction(I18n.tr("3dxm.command.Morph")){

            public void actionPerformed(ActionEvent actionEvent) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                BasicAnimator basicAnimator = exhibit.getMorphingAnimation(Menus.this.display.getView(), 2);
                if (basicAnimator != null) {
                    Menus.this.display.installAnimation(basicAnimator);
                } else {
                    JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.morphing.noAnimation"));
                }
            }
        };
        this.cyclicMorphAction = new AbstractAction(I18n.tr("3dxm.command.CyclicMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                BasicAnimator basicAnimator = exhibit.getMorphingAnimation(Menus.this.display.getView(), 1);
                if (basicAnimator != null) {
                    Menus.this.display.installAnimation(basicAnimator);
                } else {
                    JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.morphing.noAnimation"));
                }
            }
        };
        this.speedSelect1 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.NormalSpeed"), true);
        this.speedSelect2 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.HalfSpeed"), true);
        this.speedSelect3 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.QuarterSpeed"), true);
        this.speedSelect4 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.EighthSpeed"), true);
        if ((this.optionFlags & 2) == 0) {
            this.speedSelect1.setAccelerator(Util.getAccelerator("1"));
            this.speedSelect2.setAccelerator(Util.getAccelerator("2"));
            this.speedSelect3.setAccelerator(Util.getAccelerator("3"));
            this.speedSelect4.setAccelerator(Util.getAccelerator("4"));
        }
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.speedSelect1);
        ((ButtonGroup)object).add(this.speedSelect2);
        ((ButtonGroup)object).add(this.speedSelect3);
        ((ButtonGroup)object).add(this.speedSelect4);
        SetSpeedAction setSpeedAction = new SetSpeedAction();
        this.speedSelect1.addActionListener(setSpeedAction);
        this.speedSelect2.addActionListener(setSpeedAction);
        this.speedSelect3.addActionListener(setSpeedAction);
        this.speedSelect4.addActionListener(setSpeedAction);
        this.speedSubmenu = new JMenu(I18n.tr("3dxm.command.AnimationSpeed"));
        this.speedSubmenu.add(this.speedSelect1);
        this.speedSubmenu.add(this.speedSelect2);
        this.speedSubmenu.add(this.speedSelect3);
        this.speedSubmenu.add(this.speedSelect4);
    }

    private void showDocumentation(String string) {
        URL uRL;
        Object object;
        String string2;
        boolean bl = Prefs.getBoolean("3dxm.docprefs.useExternalBrowser", false);
        String string3 = null;
        if (bl && ((string3 = Prefs.get("3dxm.docprefs.externalBrowserCommand", null)) == null || string3.indexOf("%f") < 0)) {
            bl = false;
        }
        if ((string2 = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"))).startsWith("http://")) {
            object = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
            try {
                uRL = new URL((String)object);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.documentation.error.BadDocumentationLocation", object));
                return;
            }
        }
        object = new File(string2, string);
        try {
            uRL = ((File)object).getAbsoluteFile().toURI().toURL();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.documentation.error.BadDocumentationLocation", ((File)object).getAbsolutePath()));
            return;
        }
        if (!bl) {
            WindowXM.showHTMLDocWindow(uRL);
        } else {
            object = string3.replace("%f", uRL.toString());
            String string4 = this.runCommand((String)object);
            if (string4 != null) {
                JOptionPane.showMessageDialog(this.window, I18n.tr(string4));
            }
        }
    }

    private String runCommand(final String string) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Runner
        extends Thread {
            volatile String errorMessage = null;

            Runner() {
            }

            @Override
            public void run() {
                Process process;
                System.out.println("Running external command: " + string);
                try {
                    process = Runtime.getRuntime().exec(string);
                }
                catch (Exception exception) {
                    this.errorMessage = I18n.tr("3dxm.documentation.error.cantLaunchBrowser", string);
                    return;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        if (this.errorMessage == null) {
                            this.errorMessage = I18n.tr("3dxm.documentation.error.errorFromBrowserProcess");
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Runner runner = new Runner();
        runner.start();
        try {
            runner.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (runner.errorMessage != null && !runner.isAlive()) {
            return runner.errorMessage;
        }
        return null;
    }

    void gotDocumnetationFileList(TreeSet<String> treeSet) {
        if (this.galleries.currentGalleryName() != null) {
            this.showATG.setEnabled(treeSet.contains(this.galleries.currentGalleryName() + ".ATG.html"));
        }
        if (this.display.getExhibit() != null) {
            this.showATE.setEnabled(treeSet.contains(this.display.getExhibit().getName() + ".ATE.html"));
        }
    }

    private void checkATEandATG() {
        if (this.galleries.currentGalleryName() == null) {
            this.showATG.setEnabled(false);
        } else {
            this.showATG.setEnabled(Galleries.documentationFileExists(this, this.galleries.currentGalleryName() + ".ATG.html"));
        }
        if (this.display.getExhibit() == null) {
            this.showATE.setEnabled(false);
        } else {
            this.showATE.setEnabled(Galleries.documentationFileExists(this, this.display.getExhibit().getName() + ".ATE.html"));
        }
    }

    private void setupFileDialog() {
        File file;
        String string;
        if (this.fileDialog == null) {
            this.fileDialog = new JFileChooser();
        }
        if ((string = Prefs.get("filechooser.directory")) != null && (file = new File(string)).isDirectory()) {
            this.fileDialog.setCurrentDirectory(file);
        }
    }

    private void saveFileDialogDirectory() {
        File file = this.fileDialog.getCurrentDirectory();
        if (file != null) {
            String string = file.getAbsolutePath();
            Prefs.put("filechooser.directory", string);
            Prefs.save("filechooser.directory");
        }
    }

    private void doOpen() {
        View[] viewArray;
        Exhibit exhibit;
        Object object;
        Object object2;
        Object object3;
        this.setupFileDialog();
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.openDialog.title"));
        int n = this.fileDialog.showOpenDialog(this.display);
        if (n != 0) {
            return;
        }
        File file = this.fileDialog.getSelectedFile();
        String string = null;
        try {
            object3 = SaveAndRestore.readXMLDocument(file);
            object2 = object3.getDocumentElement().getElementsByTagName("gallery_3dxm");
            if (object2.getLength() > 0) {
                object = (Element)object2.item(0);
                string = object.getAttribute("name").trim();
            }
            exhibit = SaveAndRestore.readExhibitFromXML(file);
        }
        catch (Exception exception) {
            this.errorMessage(I18n.tr("3dxm.dialog.openDialog.error", exception.getMessage()));
            return;
        }
        this.window.setTitle(exhibit.getTitle());
        this.galleries.selectGalleryByName(string, this, this.exhibitMenu);
        object3 = exhibit.getViews();
        object2 = object3 == null || ((ArrayList)object3).size() == 0 ? exhibit.getDefaultView() : (View)((ArrayList)object3).get(0);
        this.display.install((View)object2, exhibit);
        object = exhibit.getCreateAnimation((View)object2);
        if (object != null) {
            this.display.installAnimation((Animation)object);
        }
        if ((viewArray = exhibit.getAlternativeViews()) != null) {
            this.alternativeViews = new View[viewArray.length + 1];
            this.alternativeViews[0] = exhibit.getDefaultView();
            for (int i = 0; i < viewArray.length; ++i) {
                this.alternativeViews[i + 1] = viewArray[i];
            }
        }
        this.setUpMenusForNewExhibit((View)object2, exhibit);
        this.saveFileDialogDirectory();
    }

    private void doSave() {
        PrintWriter printWriter;
        int n;
        if (this.display.getExhibit() == null) {
            return;
        }
        this.display.stopAnimation();
        this.setupFileDialog();
        String string = I18n.tr("3dxm.dialog.saveDialog.SettingsFileNameForExhibit", this.display.getExhibit().getTitle()) + '.' + FILE_EXTENSION;
        File file = new File(string);
        this.fileDialog.setSelectedFile(file);
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.saveDialog.title"));
        int n2 = this.fileDialog.showSaveDialog(this.display);
        if (n2 != 0) {
            return;
        }
        file = this.fileDialog.getSelectedFile();
        if (!file.exists() && !file.getName().toLowerCase().endsWith(".3dxmj")) {
            file = new File(file.getParent(), file.getName() + '.' + FILE_EXTENSION);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.display, I18n.tr("3dxm.dialog.saveDialog.fileExists", file.getName()), I18n.tr("3dxm.dialog.saveDialog.confirmSaveTitle"), 0, 2)) == 1) {
            return;
        }
        try {
            printWriter = new PrintWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantOpenOutputFile", file.getName()));
            return;
        }
        Document document = SaveAndRestore.exhibitToXML(this.display.getExhibit(), this.display.getView());
        String string2 = this.galleries.currentGalleryName();
        if (string2 != null) {
            Element element = document.createElement("gallery_3dxm");
            element.setAttribute("name", string2);
            document.getDocumentElement().appendChild(element);
        }
        try {
            SaveAndRestore.writeXMLDocument(printWriter, document);
        }
        catch (Exception exception) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", file.getName()));
            return;
        }
        printWriter.close();
        if (printWriter.checkError()) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", file.getName()));
            return;
        }
        this.saveFileDialogDirectory();
    }

    private void doSaveImage(String string) {
        int n;
        BufferedImage bufferedImage;
        if (this.display.getView() == null || this.display.getExhibit() == null) {
            return;
        }
        try {
            bufferedImage = this.display.getView().getImage(false);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.errorMessage(I18n.tr("3dxm.dialog.saveImageDialog.error.OutOfMemory"));
            return;
        }
        if (bufferedImage == null) {
            this.errorMessage(I18n.tr("3dxm.dialog.saveImageDialog.error.NoImage"));
            return;
        }
        this.setupFileDialog();
        String string2 = this.display.getExhibit().getTitle() + "." + string.toLowerCase();
        File file = new File(string2);
        this.fileDialog.setSelectedFile(file);
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.saveImageDialog.title", string));
        int n2 = this.fileDialog.showSaveDialog(this.display);
        if (n2 != 0) {
            return;
        }
        file = this.fileDialog.getSelectedFile();
        if (!file.exists()) {
            if (string.equalsIgnoreCase("PNG") && !file.getName().toLowerCase().endsWith(".png")) {
                file = new File(file.getParent(), file.getName() + ".png");
            } else if (string.equalsIgnoreCase("JPEG") && !file.getName().toLowerCase().endsWith(".jpeg") && !file.getName().toLowerCase().endsWith(".jpg")) {
                file = new File(file.getParent(), file.getName() + ".jpeg");
            }
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.display, I18n.tr("3dxm.dialog.saveDialog.fileExists", file.getName()), I18n.tr("3dxm.dialog.saveDialog.confirmSaveTitle"), 0, 2)) == 1) {
            return;
        }
        try {
            if (!ImageIO.write((RenderedImage)bufferedImage, string, file)) {
                this.errorMessage(I18n.tr("3dxm.dialog.saveImageDialog.error.BadFormat", string));
                return;
            }
        }
        catch (Exception exception) {
            this.errorMessage(I18n.tr("3dxm.dialog.saveImageDialog.error.WriteError"));
            return;
        }
        this.saveFileDialogDirectory();
    }

    private void doSaveAnimation(String string) {
        BufferedOutputStream bufferedOutputStream;
        int n;
        Filmstrip filmstrip = this.display.getSavedFilmstrip();
        if (filmstrip == null) {
            return;
        }
        this.display.stopAnimation();
        int n2 = this.display.getSavedFilmstripLooping();
        boolean bl = n2 == 1;
        this.setupFileDialog();
        String string2 = this.display.getExhibit() == null ? I18n.tr("3dxm.dialog.saveAnimationDialog.AnimationFileNameForExhibit", string.toLowerCase()) + ".3dxmja" : I18n.tr("3dxm.dialog.saveAnimationDialog.AnimationFileNameForExhibit", this.display.getExhibit().getTitle()) + ".3dxmja";
        File file = new File(string2);
        this.fileDialog.setSelectedFile(file);
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.saveAnimationDialog.title", string));
        int n3 = this.fileDialog.showSaveDialog(this.display);
        if (n3 != 0) {
            return;
        }
        file = this.fileDialog.getSelectedFile();
        if (!file.exists() && !file.getName().toLowerCase().endsWith(".3dxmja")) {
            file = new File(file.getParent(), file.getName() + ".3dxmja");
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.display, I18n.tr("3dxm.dialog.saveDialog.fileExists", file.getName()), I18n.tr("3dxm.dialog.saveDialog.confirmSaveTitle"), 0, 2)) == 1) {
            return;
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", file.getName()));
            return;
        }
        this.display.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean bl2 = SavedAnimationSupport.saveAnimation(this.display, bufferedOutputStream, filmstrip, bl, string);
            if (!bl2) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.errorSavingAnimation", file.getName(), iOException.getMessage()));
            iOException.printStackTrace();
        }
        this.display.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPlaySavedAnimation() {
        ZipFile zipFile;
        this.display.stopAnimation();
        this.setupFileDialog();
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.playSavedAnimation.title"));
        int n = this.fileDialog.showOpenDialog(this.display);
        if (n != 0) {
            return;
        }
        File file = this.fileDialog.getSelectedFile();
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            this.errorMessage(I18n.tr("3dxm.dialog.playSavedAnimation.CantRead", file.getName()));
            return;
        }
        this.display.discardFilmstrip();
        try {
            SavedAnimationSupport.readAndPlay(this.display, zipFile);
        }
        catch (Exception exception) {
            this.errorMessage(I18n.tr("3dxm.dialog.playSavedAnimation.error", file.getName(), exception.getMessage()));
            return;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
    }

    private void errorMessage(String string) {
        JOptionPane.showMessageDialog(this.display, string, I18n.tr("3dxm.dialog.errormessage.title"), 0);
    }

    private class SetSpeedAction
    implements ActionListener {
        private SetSpeedAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Menus.this.speedSelect1) {
                Menus.this.display.setTimeDilationForAnimations(1.0);
            } else if (object == Menus.this.speedSelect2) {
                Menus.this.display.setTimeDilationForAnimations(2.0);
            } else if (object == Menus.this.speedSelect3) {
                Menus.this.display.setTimeDilationForAnimations(4.0);
            } else if (object == Menus.this.speedSelect4) {
                Menus.this.display.setTimeDilationForAnimations(8.0);
            }
        }
    }
}

