/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JButton;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.MainForWebStart;
import vmm.xm3d.WindowXM;

public class LauncherApplet
extends JApplet {
    private JButton launchButton;
    private String openString;
    private String closeString;
    private String exhibitName;
    private ArrayList<WindowXM> openWindows = new ArrayList();

    public void init() {
        String string = this.getParameter("Locale");
        if (string != null && string.length() == 2) {
            I18n.setLocale(new Locale(string));
        }
        I18n.addFile("vmm.xm3d.stringsXM");
        DisplayXM.noSplash();
        this.openString = this.getParameter("OpenCommand");
        if (this.openString == null) {
            this.openString = I18n.tr("3dxm.LauncherApplet.OpenCommand");
        }
        this.closeString = this.getParameter("CloseCommand");
        if (this.closeString == null) {
            this.closeString = I18n.tr("3dxm.LauncherApplet.CloseCommand");
        }
        this.exhibitName = this.getParameter("Exhibit");
        this.launchButton = new JButton(this.openString);
        this.getContentPane().add(this.launchButton);
        this.launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LauncherApplet.this.doButton();
            }
        });
    }

    private void doButton() {
        this.launchButton.setEnabled(false);
        if (this.openWindows.size() == 0) {
            Object object;
            Exhibit exhibit = null;
            View view = null;
            int n = 17;
            if (this.exhibitName != null) {
                try {
                    if (this.exhibitName.endsWith(".xml")) {
                        object = MainForWebStart.class.getClassLoader();
                        URL uRL = ((ClassLoader)object).getResource(this.exhibitName);
                        if (uRL == null) {
                            uRL = new URL(this.getDocumentBase(), this.exhibitName);
                        }
                        InputStream inputStream = uRL.openStream();
                        exhibit = SaveAndRestore.readExhibitFromXML(inputStream, "Settings File");
                        view = exhibit.getViews().get(0);
                    } else {
                        exhibit = (Exhibit)Class.forName(this.exhibitName).newInstance();
                        if (exhibit instanceof UserExhibit) {
                            view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().showCreateDialog(null);
                            if (view == null) {
                                this.launchButton.setEnabled(true);
                                return;
                            }
                        } else {
                            view = exhibit.getDefaultView();
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("Can't load Exhibit specified by applet param \"" + this.exhibitName + "\"");
                    exception.printStackTrace();
                    exhibit = null;
                    view = null;
                    return;
                }
                if ("yes".equalsIgnoreCase(this.getParameter("SingleExhibit"))) {
                    n |= 4;
                } else if ("yes".equalsIgnoreCase(this.getParameter("SingleGallery"))) {
                    n |= 8;
                }
            }
            object = new WindowXM(this, n);
            if (exhibit != null) {
                ((WindowXM)object).getMenus().install(view, exhibit);
            }
            ((Window)object).setVisible(true);
        } else {
            for (WindowXM windowXM : this.openWindows) {
                windowXM.dispose();
            }
        }
    }

    void windowClosed(WindowXM windowXM) {
        this.openWindows.remove(windowXM);
        if (this.openWindows.size() == 0) {
            this.launchButton.setText(this.openString);
            this.launchButton.setEnabled(true);
        }
    }

    void windowOpened(WindowXM windowXM) {
        this.launchButton.setText(this.closeString);
        this.launchButton.setEnabled(true);
        this.openWindows.add(windowXM);
    }
}

