/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import vmm.core.I18n;

public class HTMLDocWindow
extends JFrame {
    private JEditorPane editPane;
    private ArrayList<Object> history = new ArrayList();
    private int currentHistoryIndex = -1;
    private JButton backButton;
    private JButton forwardButton;
    private JButton closeButton;

    public HTMLDocWindow() {
        super(I18n.tr("3dxm.HTMLDocWindow.title"));
        this.setDefaultCloseOperation(1);
        this.editPane = new JEditorPane();
        this.editPane.setEditable(false);
        this.editPane.setMargin(new Insets(15, 15, 10, 5));
        this.editPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        HTMLDocWindow.this.editPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Exception exception) {
                        HTMLDocWindow.this.editPane.setContentType("text/plain");
                        HTMLDocWindow.this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
                    }
                }
            }
        });
        this.backButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Back"));
        this.forwardButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Forward"));
        this.closeButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Close"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.backButton);
        jPanel.add(this.forwardButton);
        jPanel.add(this.closeButton);
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLDocWindow.this.setVisible(false);
                HTMLDocWindow.this.history.clear();
                HTMLDocWindow.this.currentHistoryIndex = -1;
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLDocWindow.this.historyBack();
            }
        });
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLDocWindow.this.historyForward();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(3, 3));
        jPanel2.setBackground(Color.GRAY);
        jPanel2.add((Component)new JScrollPane(this.editPane), "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.editPane.getEditorKitForContentType("text/html");
        hTMLEditorKit.getStyleSheet().addRule("body { font-size: 16pt }");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 620) / 2, 100, 650, 500);
    }

    public HTMLDocWindow(String string) {
        this();
        if (string != null) {
            this.showFile(string);
        } else {
            this.setVisible(true);
        }
    }

    public HTMLDocWindow(URL uRL) {
        this();
        if (uRL != null) {
            this.showURL(uRL);
        } else {
            this.setVisible(true);
        }
    }

    public void showURL(URL uRL) {
        this.historyAdd(uRL);
        try {
            this.editPane.setPage(uRL);
        }
        catch (Exception exception) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.setVisible(true);
    }

    public void showFile(String string) {
        this.historyAdd(string);
        try {
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (uRL == null) {
                throw new Exception();
            }
            this.editPane.setPage(uRL);
        }
        catch (Exception exception) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.setVisible(true);
    }

    private void historyBack() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            this.showFromHistory();
        }
    }

    private void historyForward() {
        if (this.currentHistoryIndex >= 0 && this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.showFromHistory();
        }
    }

    private void showFromHistory() {
        Object object = this.history.get(this.currentHistoryIndex);
        try {
            URL uRL = object instanceof String ? this.getClass().getClassLoader().getResource((String)object) : (URL)object;
            this.editPane.setPage(uRL);
        }
        catch (Exception exception) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.backButton.setEnabled(this.currentHistoryIndex > 0);
        this.forwardButton.setEnabled(this.currentHistoryIndex < this.history.size() - 1);
    }

    private void historyAdd(Object object) {
        if (this.currentHistoryIndex == -1) {
            this.history.add(object);
            this.currentHistoryIndex = 0;
        } else {
            if (object.equals(this.history.get(this.currentHistoryIndex))) {
                return;
            }
            while (this.history.size() > this.currentHistoryIndex + 1) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(object);
            this.currentHistoryIndex = this.history.size() - 1;
        }
        this.backButton.setEnabled(this.currentHistoryIndex > 0);
        this.forwardButton.setEnabled(this.currentHistoryIndex < this.history.size() - 1);
    }
}

