/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.Prefs;
import vmm.xm3d.Menus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Galleries {
    private GalleryItemList defaultGallery;
    private ArrayList<GalleryItemList> items;
    private GalleryItemList currentGallery;
    private String currentGalleryName;
    private static String documentationLocation;
    private static TreeSet<String> documentationFileList;
    private static Menus waitingForDocInfo;
    private static int setDocLocationCount;

    public Galleries() throws IOException {
        this("vmm/xm3d/galleries.xml");
    }

    public Galleries(String string) throws IOException {
        InputStream inputStream;
        try {
            ClassLoader classLoader = Galleries.class.getClassLoader();
            URL uRL = classLoader.getResource(string);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantRead"));
        }
        this.readStream(inputStream);
    }

    public Galleries(InputStream inputStream) throws IOException {
        this.readStream(inputStream);
    }

    public String currentGalleryName() {
        return this.currentGalleryName;
    }

    public void selectGalleryByName(String string, Menus menus, JMenu jMenu) {
        if (string == null) {
            this.currentGalleryName = null;
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            GalleryItemList galleryItemList = this.items.get(i);
            if (galleryItemList.nodeType.equals("gallery")) {
                if (!galleryItemList.name.equals(string)) continue;
                this.setUpExhibitMenu(menus, jMenu, galleryItemList);
                return;
            }
            for (int j = 0; j < galleryItemList.items.size(); ++j) {
                GalleryItemList galleryItemList2 = (GalleryItemList)galleryItemList.items.get(j);
                if (!galleryItemList2.name.equals(string)) continue;
                this.setUpExhibitMenu(menus, jMenu, galleryItemList2);
                return;
            }
        }
        this.currentGalleryName = null;
    }

    String findGalleryForExhibit(Exhibit exhibit) {
        String string = exhibit.getClass().getName();
        for (GalleryItemList galleryItemList : this.items) {
            if (galleryItemList == null) continue;
            if (galleryItemList.nodeType.equals("gallery_group")) {
                for (GalleryItem galleryItem : galleryItemList.items) {
                    if (galleryItem == null) continue;
                    assert (galleryItem instanceof GalleryItemList && ((GalleryItemList)galleryItem).nodeType.equals("gallery"));
                    if (!this.findGalleryHelper(string, (GalleryItemList)galleryItem)) continue;
                    return galleryItem.name;
                }
                continue;
            }
            if (!this.findGalleryHelper(string, galleryItemList)) continue;
            return galleryItemList.name;
        }
        return null;
    }

    private boolean findGalleryHelper(String string, GalleryItemList galleryItemList) {
        for (GalleryItem galleryItem : galleryItemList.items) {
            if (galleryItem == null) continue;
            assert (galleryItem instanceof ExhibitItem || galleryItem instanceof GalleryItemList && ((GalleryItemList)galleryItem).nodeType.equals("exhbit_group"));
            if (galleryItem instanceof GalleryItemList) {
                for (GalleryItem galleryItem2 : ((GalleryItemList)galleryItem).items) {
                    if (galleryItem2 == null || !string.equals(((ExhibitItem)galleryItem2).classname)) continue;
                    return true;
                }
                continue;
            }
            if (!string.equals(((ExhibitItem)galleryItem).classname)) continue;
            return true;
        }
        return false;
    }

    public void setUpGalleryMenu(Menus menus, JMenu jMenu, JMenu jMenu2) {
        for (int i = 0; i < this.items.size(); ++i) {
            GalleryItemList galleryItemList;
            if (this.items.get(i) == null) {
                jMenu.addSeparator();
                continue;
            }
            if (this.items.get((int)i).nodeType.equals("gallery")) {
                galleryItemList = this.items.get(i);
                jMenu.add(new SelectGalleryAction(menus, galleryItemList, jMenu2));
                continue;
            }
            galleryItemList = this.items.get(i);
            ArrayList<GalleryItem> arrayList = galleryItemList.items;
            JMenu jMenu3 = new JMenu(galleryItemList.title);
            for (int j = 0; j < arrayList.size(); ++j) {
                if (arrayList.get(j) == null) {
                    jMenu3.addSeparator();
                    continue;
                }
                GalleryItemList galleryItemList2 = (GalleryItemList)arrayList.get(j);
                jMenu3.add(new SelectGalleryAction(menus, galleryItemList2, jMenu2));
            }
            jMenu.add(jMenu3);
        }
        this.setUpExhibitMenu(menus, jMenu2, this.defaultGallery);
    }

    void setUpExhibitMenu(Menus menus, JMenu jMenu) {
        this.setUpExhibitMenu(menus, jMenu, null);
    }

    private void setUpExhibitMenu(Menus menus, JMenu jMenu, GalleryItemList galleryItemList) {
        if (galleryItemList == null) {
            galleryItemList = this.currentGallery;
        }
        if (galleryItemList == null) {
            galleryItemList = this.defaultGallery;
        }
        this.currentGallery = galleryItemList;
        this.currentGalleryName = galleryItemList.name;
        jMenu.removeAll();
        jMenu.setText(galleryItemList.title);
        for (int i = 0; i < galleryItemList.items.size(); ++i) {
            if (galleryItemList.items.get(i) == null) {
                jMenu.addSeparator();
                continue;
            }
            if (galleryItemList.items.get(i) instanceof ExhibitItem) {
                jMenu.add(new SelectExhibitAction(menus, (ExhibitItem)galleryItemList.items.get(i)));
                continue;
            }
            GalleryItemList galleryItemList2 = (GalleryItemList)galleryItemList.items.get(i);
            ArrayList<GalleryItem> arrayList = galleryItemList2.items;
            JMenu jMenu2 = new JMenu(galleryItemList2.title);
            for (int j = 0; j < arrayList.size(); ++j) {
                if (arrayList.get(j) == null) {
                    jMenu2.addSeparator();
                    continue;
                }
                jMenu2.add(new SelectExhibitAction(menus, (ExhibitItem)arrayList.get(j)));
            }
            jMenu.add(jMenu2);
        }
    }

    private void readStream(InputStream inputStream) throws IOException {
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantDoXML"));
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(I18n.tr("3dxm.galleries.error.NotXML", sAXException.getMessage()));
        }
        catch (IOException iOException) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantRead", iOException.getMessage()));
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("galleries")) {
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", element.getTagName()));
        }
        NodeList nodeList = element.getChildNodes();
        this.items = new ArrayList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            if (element2.getTagName().equals("gallery")) {
                this.items.add(this.buildGallery(element2));
                continue;
            }
            if (element2.getTagName().equals("gallery_group")) {
                this.items.add(this.buildGalleryGroup(element2));
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", element.getTagName()));
        }
    }

    private GalleryItemList buildGallery(Element element) throws IOException {
        Object object;
        String string = element.getAttribute("name").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "gallery"));
        }
        String string2 = element.getAttribute("title").trim();
        if (string2.length() == 0) {
            string2 = I18n.tr(string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<GalleryItem> arrayList = new ArrayList<GalleryItem>();
        for (int i = 0; i < n; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            object = (Element)nodeList.item(i);
            String string3 = object.getTagName();
            if (string3.equals("separator")) {
                arrayList.add(null);
                continue;
            }
            if (string3.equals("exhibit")) {
                arrayList.add(this.buildGalleryItem((Element)object));
                continue;
            }
            if (string3.equals("xml_exhibit")) {
                arrayList.add(this.buildXMLGalleryItem((Element)object));
                continue;
            }
            if (string3.equals("exhibit_group")) {
                arrayList.add(this.buildGalleryItemGroup((Element)object));
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", string3));
        }
        GalleryItemList galleryItemList = new GalleryItemList();
        galleryItemList.nodeType = "gallery";
        galleryItemList.name = string;
        galleryItemList.title = string2;
        galleryItemList.items = arrayList;
        object = element.getAttribute("default").trim();
        if (((String)object).equals("yes") || this.defaultGallery == null) {
            this.defaultGallery = galleryItemList;
        }
        return galleryItemList;
    }

    private GalleryItemList buildGalleryGroup(Element element) throws IOException {
        String string = element.getAttribute("name").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "gallery_group"));
        }
        String string2 = element.getAttribute("title").trim();
        if (string2.length() == 0) {
            string2 = I18n.tr(string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<GalleryItemList> arrayList = new ArrayList<GalleryItemList>();
        for (int i = 0; i < n; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getTagName();
            if (string3.equals("gallery")) {
                arrayList.add(this.buildGallery(element2));
                continue;
            }
            if (string3.equals("separator")) {
                arrayList.add(null);
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", string3));
        }
        GalleryItemList galleryItemList = new GalleryItemList();
        galleryItemList.nodeType = "gallery_group";
        galleryItemList.name = string;
        galleryItemList.title = string2;
        galleryItemList.items = arrayList;
        return galleryItemList;
    }

    private ExhibitItem buildGalleryItem(Element element) throws IOException {
        String string;
        String string2 = element.getAttribute("class").trim();
        if (string2.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "class", "exhibit"));
        }
        String string3 = element.getAttribute("name").trim();
        if (string3.length() == 0) {
            string3 = string2;
        }
        if ((string = element.getAttribute("title").trim()).length() == 0) {
            string = I18n.tr(string3);
        }
        ExhibitItem exhibitItem = new ExhibitItem();
        exhibitItem.classname = string2;
        exhibitItem.name = string3;
        exhibitItem.title = string;
        exhibitItem.isXML = false;
        return exhibitItem;
    }

    private ExhibitItem buildXMLGalleryItem(Element element) throws IOException {
        String string;
        String string2 = element.getAttribute("file").trim();
        if (string2.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "file", "xml_exhibit"));
        }
        String string3 = element.getAttribute("name").trim();
        if (string3.length() == 0) {
            string3 = string2;
        }
        if ((string = element.getAttribute("title").trim()).length() == 0) {
            string = I18n.tr(string3);
        }
        ExhibitItem exhibitItem = new ExhibitItem();
        exhibitItem.classname = string2;
        exhibitItem.name = string3;
        exhibitItem.title = string;
        exhibitItem.isXML = true;
        return exhibitItem;
    }

    private GalleryItemList buildGalleryItemGroup(Element element) throws IOException {
        String string = element.getAttribute("name").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "exhibit_group"));
        }
        String string2 = element.getAttribute("title").trim();
        if (string2.length() == 0) {
            string2 = I18n.tr(string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<ExhibitItem> arrayList = new ArrayList<ExhibitItem>();
        for (int i = 0; i < n; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getTagName();
            if (string3.equals("exhibit")) {
                arrayList.add(this.buildGalleryItem(element2));
                continue;
            }
            if (string3.equals("separator")) {
                arrayList.add(null);
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", string3));
        }
        GalleryItemList galleryItemList = new GalleryItemList();
        galleryItemList.nodeType = "exhibit_group";
        galleryItemList.name = string;
        galleryItemList.title = string2;
        galleryItemList.items = arrayList;
        return galleryItemList;
    }

    static synchronized void setDocumentationLocation() {
        final String string = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
        if (string.equals(documentationLocation)) {
            return;
        }
        documentationLocation = string;
        documentationFileList = null;
        final int n = ++setDocLocationCount;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TreeSet<String> treeSet = new TreeSet<String>();
                try {
                    String string2;
                    URL uRL;
                    Object object;
                    if (string.startsWith("http://")) {
                        object = string.endsWith("/") ? string + "doclist.txt" : string + "/" + "doclist.txt";
                        uRL = new URL((String)object);
                    } else {
                        object = new File(string, "doclist.txt");
                        uRL = ((File)object).getAbsoluteFile().toURI().toURL();
                    }
                    object = new BufferedReader(new InputStreamReader(uRL.openStream(), "ISO-8859-1"));
                    while ((string2 = ((BufferedReader)object).readLine()) != null) {
                        treeSet.add(string2);
                    }
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    System.out.println("Error reading documentation file list.\n" + exception);
                }
                finally {
                    Galleries.gotDocInfo(treeSet, n);
                }
            }
        };
        thread.start();
    }

    private static synchronized void gotDocInfo(TreeSet<String> treeSet, int n) {
        if (n != setDocLocationCount) {
            return;
        }
        documentationFileList = treeSet;
        if (waitingForDocInfo != null) {
            waitingForDocInfo.gotDocumnetationFileList(treeSet);
            waitingForDocInfo = null;
        }
    }

    static synchronized boolean documentationFileExists(Menus menus, String string) {
        if (documentationFileList == null) {
            waitingForDocInfo = menus;
            return false;
        }
        return documentationFileList.contains(string);
    }

    static {
        Galleries.setDocumentationLocation();
    }

    private class SelectExhibitAction
    extends AbstractAction {
        Menus menus;
        ExhibitItem exhibitItem;

        SelectExhibitAction(Menus menus, ExhibitItem exhibitItem) {
            super(exhibitItem.title);
            this.menus = menus;
            this.exhibitItem = exhibitItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.menus.installExhibit(this.exhibitItem);
        }
    }

    private class SelectGalleryAction
    extends AbstractAction {
        JMenu exhibitMenu;
        GalleryItemList gallery;
        Menus menus;

        SelectGalleryAction(Menus menus, GalleryItemList galleryItemList, JMenu jMenu) {
            super(galleryItemList.title);
            this.menus = menus;
            this.gallery = galleryItemList;
            this.exhibitMenu = jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Galleries.this.currentGalleryName = this.gallery.name;
            this.menus.installExhibit(null);
            Galleries.this.setUpExhibitMenu(this.menus, this.exhibitMenu, this.gallery);
        }
    }

    private static class GalleryItemList
    extends GalleryItem {
        String nodeType;
        ArrayList<GalleryItem> items;

        private GalleryItemList() {
        }
    }

    static class ExhibitItem
    extends GalleryItem {
        boolean isXML;
        String classname;

        ExhibitItem() {
        }
    }

    static class GalleryItem {
        String name;
        String title;

        GalleryItem() {
        }
    }
}

