/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.MainForWebStart;
import vmm.xm3d.Menus;

public class EmbeddedApplet
extends JApplet {
    private DisplayXM display;

    public void init() {
        Object object;
        String string = this.getParameter("Locale");
        if (string != null && string.length() == 2) {
            I18n.setLocale(new Locale(string));
        }
        I18n.addFile("vmm.xm3d.stringsXM");
        DisplayXM.noSplash();
        int n = 19;
        this.display = new DisplayXM();
        JComponent jComponent = (JComponent)this.display.getHolder();
        jComponent.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        if ("no".equalsIgnoreCase(this.getParameter("StatusBar"))) {
            this.display.setShowStatusBar(false);
        }
        String string2 = this.getParameter("Exhibit");
        Exhibit exhibit = null;
        View view = null;
        if (string2 != null) {
            try {
                if (string2.endsWith(".xml")) {
                    object = MainForWebStart.class.getClassLoader();
                    URL uRL = ((ClassLoader)object).getResource(string2);
                    if (uRL == null) {
                        uRL = new URL(this.getDocumentBase(), string2);
                    }
                    InputStream inputStream = uRL.openStream();
                    exhibit = SaveAndRestore.readExhibitFromXML(inputStream, "Settings File");
                    view = exhibit.getViews().get(0);
                } else {
                    exhibit = (Exhibit)Class.forName(string2).newInstance();
                    if (exhibit instanceof UserExhibit) {
                        view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().defaults();
                        if (view == null) {
                            throw new Exception("Error while creating user exhibits with default settings");
                        }
                    } else {
                        view = exhibit.getDefaultView();
                    }
                }
                if ("yes".equalsIgnoreCase(this.getParameter("SingleExhibit"))) {
                    n |= 4;
                } else if ("yes".equalsIgnoreCase(this.getParameter("SingleGallery"))) {
                    n |= 8;
                }
            }
            catch (Exception exception) {
                System.out.println("Can't load Exhibit specified by applet param \"" + string2 + "\"");
                exception.printStackTrace();
                exhibit = null;
            }
        }
        object = new Menus(null, this.display, n);
        if (exhibit != null) {
            ((Menus)object).install(view, exhibit);
        }
        this.display.setStopAnimationsOnResize(false);
        this.setJMenuBar((JMenuBar)object);
        this.setContentPane(jComponent);
    }

    public void stop() {
        this.display.stopAnimation();
    }
}

