/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import vmm.core.I18n;
import vmm.core.Prefs;
import vmm.core.SettingsDialog;
import vmm.core.Util;

public class DocPrefsDialog
extends SettingsDialog {
    private boolean useExternalBrowser;
    private String externalBrowserCommand;
    private String documentationBaseURL;
    private JComboBox browserSelect;
    private JTextField docsLocationInput;
    private JButton browseDocLocationButton;

    public DocPrefsDialog(Component component) {
        super(component, I18n.tr("3dxm.DocPrefsDialog.title"), true, false);
        String string;
        Box box = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("3dxm.DocPrefsDialog.SelectBrowser")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Box box3 = Box.createVerticalBox();
        box3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("3dxm.DocPrefsDialog.SelectDocsLocation")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        box.add(box3);
        box.add(Box.createVerticalStrut(7));
        box.add(box2);
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.browserSelect = new JComboBox();
        this.useExternalBrowser = Prefs.getBoolean("3dxm.docprefs.useExternalBrowser", false);
        this.externalBrowserCommand = Prefs.get("3dxm.docprefs.externalBrowserCommand", null);
        if (this.externalBrowserCommand == null || this.externalBrowserCommand.indexOf("%f") < 0) {
            this.useExternalBrowser = false;
        }
        this.documentationBaseURL = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
        if (this.useExternalBrowser) {
            this.browserSelect.addItem(this.externalBrowserCommand);
        }
        this.browserSelect.addItem(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        try {
            string = System.getProperty("os.name").toLowerCase();
        }
        catch (Exception exception) {
            string = "";
        }
        if (Util.isMacOS()) {
            this.browserSelect.addItem("open %f");
            this.browserSelect.addItem("open -a safari %f");
            this.browserSelect.addItem("open -a firefox %f");
        } else if (string.indexOf("linux") >= 0) {
            this.browserSelect.addItem("gnome-open %f");
            this.browserSelect.addItem("kfmclient exec %f");
            this.browserSelect.addItem("firefox %f");
            this.browserSelect.addItem("konqueror %f");
        } else if (string.indexOf("wind") >= 0) {
            this.browserSelect.addItem("cmd.exe /c start %f");
            this.browserSelect.addItem("\"c:\\Program Files\\Internet Explorer\\iexplore\" %f");
            this.browserSelect.addItem("firefox %f");
        } else {
            this.browserSelect.addItem("firefox %f");
        }
        this.browserSelect.setSelectedItem(0);
        this.browserSelect.setEditable(true);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(I18n.tr("3dxm.DocPrefsDialog.selectBrowserInfo"), 2));
        box2.add(jPanel);
        box2.add(Box.createVerticalStrut(5));
        box2.add(this.browserSelect);
        this.docsLocationInput = new JTextField(this.documentationBaseURL);
        this.browseDocLocationButton = new JButton(I18n.tr("3dxm.DocPrefsDialog.Browse"));
        this.browseDocLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocPrefsDialog.this.browseToSelectDocDirectory();
            }
        });
        jPanel = new JPanel();
        jPanel.add(new JLabel(I18n.tr("3dxm.DocPrefsDialog.selectDocsLocationInfo"), 2));
        box3.add(jPanel);
        box3.add(Box.createVerticalStrut(5));
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)this.docsLocationInput, "Center");
        jPanel.add((Component)this.browseDocLocationButton, "East");
        box3.add(jPanel);
        this.addInputPanel(box);
        this.pack();
    }

    private void browseToSelectDocDirectory() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18n.tr("3dxm.DocPrefsDialog.SelectDocsDirectoryTitle"));
        jFileChooser.setFileSelectionMode(1);
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = jFileChooser.getSelectedFile();
            this.docsLocationInput.setText(file.getAbsolutePath());
        }
    }

    protected void doDefaults() {
        this.browserSelect.setSelectedItem(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        this.docsLocationInput.setText(I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
    }

    protected boolean doOK() {
        String string = this.docsLocationInput.getText();
        if (!string.startsWith("http://")) {
            File file = new File(string);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.DocsDirDoesNotExist"));
                return false;
            }
            if (!file.isDirectory()) {
                JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.DocsDirIsNotDirectory"));
                return false;
            }
        }
        this.externalBrowserCommand = (String)this.browserSelect.getSelectedItem();
        boolean bl = this.useExternalBrowser = !this.externalBrowserCommand.equals(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        if (this.useExternalBrowser && !this.externalBrowserCommand.contains("%f")) {
            JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.BadBrowserCommand"));
            return false;
        }
        Prefs.putBoolean("3dxm.docprefs.useExternalBrowser", this.useExternalBrowser);
        Prefs.save("3dxm.docprefs.useExternalBrowser");
        if (this.useExternalBrowser) {
            Prefs.putAndSave("3dxm.docprefs.externalBrowserCommand", this.externalBrowserCommand);
        } else {
            Prefs.putAndSave("3dxm.docprefs.externalBrowserCommand", "");
        }
        this.documentationBaseURL = string;
        Prefs.putAndSave("3dxm.docprefs.documentationBaseURL", this.documentationBaseURL);
        return true;
    }
}

