/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.View;

public class DisplayXM
extends Display {
    private static String backgroundURL = "vmm/resources/splash_background.jpeg";
    private static boolean firstWindow = true;
    private volatile Image splashBackground;

    public DisplayXM() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("control PERIOD"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("meta PERIOD"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("SPACE"), "pause");
        this.getActionMap().put("reset", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayXM.this.stopAnimation();
            }
        });
        this.getActionMap().put("pause", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayXM.this.toggleAnimationPaused();
            }
        });
        if (firstWindow) {
            try {
                URL uRL = this.getClass().getClassLoader().getResource(backgroundURL);
                if (uRL != null) {
                    this.splashBackground = Toolkit.getDefaultToolkit().createImage(uRL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            firstWindow = false;
        }
    }

    static void noSplash() {
        firstWindow = false;
    }

    public void install(View view, Exhibit exhibit) {
        super.install(view, exhibit);
        if (this.getExhibit() != null) {
            this.splashBackground = null;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getStatus() == "empty") {
            if (this.splashBackground != null) {
                graphics.drawImage(this.splashBackground, 0, 0, this.getWidth(), this.getHeight(), this);
                this.showWelcomeMessage(graphics);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(I18n.tr("3dxm.DisplayXM.SelectExhibitMessage"), 15, 30);
            }
        }
    }

    private void showWelcomeMessage(Graphics graphics) {
        int n;
        int n2;
        graphics.setFont(new Font("Serif", 1, 18));
        String string = I18n.tr("3dxm.DisplayXM.WelcomeMessage");
        String string2 = I18n.tr("application.nameAndVersion");
        String[] stringArray = string.split("\n");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading() + 12;
        int n4 = fontMetrics.getAscent() + (this.getHeight() - n3 * stringArray2.length) / 2;
        int n5 = 0;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = fontMetrics.stringWidth(stringArray2[n2]);
            if (n <= n5) continue;
            n5 = n;
        }
        n2 = (this.getWidth() - n5) / 2;
        graphics.setColor(Color.RED);
        for (n = 0; n < stringArray2.length; ++n) {
            graphics.drawString(stringArray2[n], n2 + (n5 - fontMetrics.stringWidth(stringArray2[n])) / 2, n4);
            n4 += n3;
        }
    }
}

