/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.BasicAnimator;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.Vector3D;
import vmm.surface.SurfaceView;
import vmm.surface.parametric.SurfaceParametric;

public abstract class WeierstrassMinimalSurface
extends SurfaceParametric {
    public static final Complex ZERO_C = new Complex(0.0, 0.0);
    public static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final Complex ONE__C = new Complex(-1.0, 0.0);
    public static final Complex IP_C = new Complex(0.0, Math.PI);
    public static final Complex IP__C = new Complex(0.0, -Math.PI);
    public static final Complex I_C = new Complex(0.0, 1.0);
    public static final Complex I__C = new Complex(0.0, -1.0);
    public static final Complex I1_C = new Complex(Math.sqrt(0.5), Math.sqrt(0.5));
    public static final Complex I2_C = new Complex(-Math.sqrt(0.5), Math.sqrt(0.5));
    public static final Complex I3_C = new Complex(-Math.sqrt(0.5), -Math.sqrt(0.5));
    public static final Complex I4_C = new Complex(Math.sqrt(0.5), -Math.sqrt(0.5));
    protected static final Complex del = new Complex(1.0E-8, 0.0);
    public RealParamAnimateable afp = new RealParamAnimateable("vmm.surface.parametric.WeierstrassMinimalSurface.AssocFamParam", 0.0, 0.0, 0.0);
    protected boolean canShowConjugateSurface = false;
    @VMMSave
    private int numberOfPieces = 1;
    protected int[] multipleCopyOptions = null;
    protected int ucount;
    protected int vcount;
    protected boolean iFirstInHelper = true;
    protected boolean iBeginMiddleInHelper = false;
    protected double du;
    protected double dv;
    protected double distFrom0;
    protected double AFP = this.afp.getValue();
    protected double LRPclosed = 1.0;
    protected ComplexVector3D[][] helperArray;
    protected ComplexVector3D halfPeriod = new ComplexVector3D(ComplexVector3D.ORIGIN);
    protected boolean flag0;
    protected boolean flag05;
    protected boolean wantsToSeeDomain = false;
    protected boolean wantsToSeeGaussImage = false;
    protected boolean needsValueArray = true;
    protected boolean needsPeriodClosed = false;
    protected boolean inAssociateMorph = false;
    static final double weight1 = 0.35555555555555557;
    static final double weight2 = 0.05;
    static final double weight3 = 0.2722222222222222;
    static final double sqrtOf3Over28 = Math.sqrt(0.10714285714285714);
    static final double almost0 = 5.960464477539063E-8;
    private ToggleAction numberOfPiecesToggle;
    private ActionRadioGroup numberOfPiecesSelect;
    private ToggleAction showConjugateSurfaceToggle;

    public WeierstrassMinimalSurface() {
        this.setFramesForMorphing(20);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.5);
        this.umax.reset(1.5);
        this.vmin.reset(-1.5);
        this.vmax.reset(1.5);
        this.setDefaultViewpoint(new Vector3D(20.0, -20.0, 20.0));
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.addParameter(this.afp);
    }

    protected void createData() {
        this.flag0 = Math.abs(this.afp.getValue()) < 0.001 || Math.abs(this.afp.getValue() - Math.PI) < 0.001 || Math.abs(this.afp.getValue() - Math.PI * 2) < 0.001;
        boolean bl = this.flag05 = Math.abs(this.afp.getValue() + 1.5707963267948966) < 0.001 || Math.abs(this.afp.getValue() - 1.5707963267948966) < 0.001;
        if (this.needsValueArray) {
            this.redoConstants();
            this.createHelperArray();
            System.out.println("created helperArray");
            if (this.needsPeriodClosed) {
                this.doClosingJob();
                this.needsPeriodClosed = false;
            }
            this.needsValueArray = false;
            this.computeHalfPeriod();
        }
        super.createData();
    }

    protected Complex domainGrid(double d, double d2) {
        return new Complex(d, d2);
    }

    protected abstract Complex gauss(Complex var1);

    protected abstract Complex hPrime(Complex var1);

    protected ComplexVector3D getCenter() {
        int n = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        int n2 = (int)Math.floor((double)(this.vcount - 1) / 2.0);
        return new ComplexVector3D(this.helperArray[n][n2]);
    }

    protected Complex intersectLines(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        Complex complex5 = complex4.minus(complex3).times(I_C);
        Complex complex6 = complex2.minus(complex);
        double d = complex3.minus(complex).dot(complex5) / complex6.dot(complex5);
        return complex.plus(complex6.times(d));
    }

    protected static double monotonPow(double d, int n) {
        double d2 = 1.0;
        if (n > 0) {
            d2 = d;
        }
        if (n > 1) {
            for (int i = 2; i <= n; ++i) {
                d2 *= Math.abs(d);
            }
        }
        return d2;
    }

    protected void doClosingJob() {
    }

    protected void redoConstants() {
        this.ucount = 1 + this.uPatchCount.getValue() * 6;
        this.vcount = 1 + this.vPatchCount.getValue() * 6;
        this.helperArray = new ComplexVector3D[this.ucount][this.vcount];
        this.du = (this.umax.getValue() - this.umin.getValue()) / (double)(this.ucount - 1);
        this.dv = (this.vmax.getValue() - this.vmin.getValue()) / (double)(this.vcount - 1);
    }

    protected Complex gaussTimesHPrime(Complex complex) {
        Complex complex2 = this.gauss(complex);
        complex2.assignTimes(this.hPrime(complex));
        return complex2;
    }

    protected Complex gaussInverseTimesHPrime(Complex complex) {
        if (this.gauss((Complex)complex).re == 0.0 && this.gauss((Complex)complex).im == 0.0) {
            return this.gauss(complex.plus(del)).inverse().times(this.hPrime(complex.plus(del)));
        }
        Complex complex2 = this.hPrime(complex);
        complex2.assignDivide(this.gauss(complex));
        return complex2;
    }

    protected Complex component3(Complex complex) {
        Complex complex2 = this.hPrime(complex);
        complex2.assignTimes(2.0);
        return complex2;
    }

    public Vector3D surfaceNormal(double d, double d2) {
        Complex complex = this.domainGrid(d, d2);
        Complex complex2 = this.gauss(complex);
        Vector3D vector3D = new Vector3D(complex2.re * 2.0, complex2.im * 2.0, complex2.abs2() - 1.0);
        double d3 = vector3D.norm();
        if (Double.isInfinite(d3) || Double.isNaN(d3) || d3 == 0.0) {
            vector3D.x = 1.0;
            vector3D.y = 0.0;
            vector3D.z = 0.0;
        } else {
            vector3D.normalize();
        }
        return vector3D;
    }

    protected ComplexVector3D ComplexVectorFunction(Complex complex) {
        Complex complex2;
        Complex complex3;
        if (this.wantsToSeeDomain) {
            complex3 = new Complex(ONE_C);
            complex2 = new Complex(ONE_C);
        } else {
            complex3 = this.gauss(complex);
            complex2 = this.hPrime(complex);
        }
        return new ComplexVector3D(complex2.times(complex3), complex2.dividedBy(complex3), complex2.times(2.0));
    }

    public ComplexVector3D ComplexVectorOneStepIntegrator(Complex complex, Complex complex2) {
        ComplexVector3D complexVector3D = new ComplexVector3D();
        Complex complex3 = complex2.minus(complex);
        if (Math.abs(complex3.re) + Math.abs(complex3.im) > 5.960464477539063E-8) {
            Complex complex4 = complex.plus(complex2);
            complex4.assignTimes(0.5);
            Complex complex5 = complex3.times(sqrtOf3Over28);
            Complex complex6 = complex4.minus(complex5);
            complex5.assignPlus(complex4);
            complexVector3D = this.ComplexVectorFunction(complex4);
            complexVector3D.assignTimes(0.35555555555555557);
            ComplexVector3D complexVector3D2 = this.ComplexVectorFunction(complex);
            complexVector3D2.assignPlus(this.ComplexVectorFunction(complex2));
            complexVector3D2.assignTimes(0.05);
            complexVector3D.assignPlus(complexVector3D2);
            complexVector3D2 = this.ComplexVectorFunction(complex6);
            complexVector3D2.assignPlus(this.ComplexVectorFunction(complex5));
            complexVector3D2.assignTimes(0.2722222222222222);
            complexVector3D.assignPlus(complexVector3D2);
            complexVector3D.assignTimes(complex3);
        }
        return complexVector3D;
    }

    public ComplexVector3D ComplexVectorIntegrator(Complex complex, Complex complex2, int n) {
        ComplexVector3D complexVector3D = new ComplexVector3D();
        Complex complex3 = complex2.minus(complex);
        if (Math.abs(complex3.re) + Math.abs(complex3.im) > 5.960464477539063E-8) {
            int n2 = (int)Math.floor((1.0 + complex3.r()) * (double)n);
            complex3 = complex3.times(1.0 / (double)n2);
            for (int i = 0; i < n2; ++i) {
                Complex complex4 = new Complex(complex.times(1.0 * (double)(n2 - i)).plus(complex2.times(1.0 * (double)i)).times(1.0 / (double)n2));
                complexVector3D = complexVector3D.plus(this.ComplexVectorOneStepIntegrator(complex4, complex4.plus(complex3)));
            }
        }
        return complexVector3D;
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
        ComplexVector3D complexVector3D2 = this.helperToMinimal(complexVector3D);
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D2.z.re, complexVector3D2.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }

    public ComplexVector3D helperToMinimal(ComplexVector3D complexVector3D) {
        return new ComplexVector3D(complexVector3D.y.minus(complexVector3D.x), complexVector3D.y.plus(complexVector3D.x).times(I_C), complexVector3D.z);
    }

    public ComplexVector3D minimalToHelper(ComplexVector3D complexVector3D) {
        return new ComplexVector3D(complexVector3D.x.plus(complexVector3D.y.times(I_C)).times(-0.5), complexVector3D.x.minus(complexVector3D.y.times(I_C)).times(0.5), complexVector3D.z);
    }

    public void createHelperArray() {
        int n;
        int n2;
        Complex complex;
        int n3;
        this.distFrom0 = 1.0;
        int n4 = 4;
        double d = this.umin.getValue();
        double d2 = this.vmin.getValue();
        Complex complex2 = this.domainGrid(d, d2);
        this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
        this.helperArray[0][0] = new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        if (this.iFirstInHelper) {
            for (n3 = 0; n3 < this.ucount - 1; ++n3) {
                complex = this.domainGrid(d += this.du, d2);
                this.helperArray[n3 + 1][0] = this.helperArray[n3][0].plus(this.ComplexVectorIntegrator(complex2, complex, n4));
                complex2 = complex;
                this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
            }
            d = this.umin.getValue();
            for (n3 = 0; n3 < this.ucount; ++n3) {
                complex2 = this.domainGrid(d, d2);
                for (n2 = 1; n2 < this.vcount; ++n2) {
                    complex = this.domainGrid(d, d2 += this.dv);
                    this.helperArray[n3][n2] = n3 == 0 || n3 == this.ucount - 1 ? this.helperArray[n3][n2 - 1].plus(this.ComplexVectorIntegrator(complex2, complex, n4)) : this.helperArray[n3][n2 - 1].plus(this.ComplexVectorOneStepIntegrator(complex2, complex));
                    complex2 = complex;
                    this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
                }
                d2 = this.vmin.getValue();
                complex2 = this.domainGrid(d, d2);
                d += this.du;
            }
        } else if (!this.iBeginMiddleInHelper) {
            for (n3 = 0; n3 < this.vcount - 1; ++n3) {
                complex = this.domainGrid(d, d2 += this.dv);
                this.helperArray[0][n3 + 1] = this.helperArray[0][n3].plus(this.ComplexVectorIntegrator(complex2, complex, n4));
                complex2 = complex;
                this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
            }
            d2 = this.vmin.getValue();
            for (n3 = 0; n3 < this.vcount; ++n3) {
                complex2 = this.domainGrid(d, d2);
                for (n2 = 1; n2 < this.ucount; ++n2) {
                    complex = this.domainGrid(d += this.du, d2);
                    this.helperArray[n2][n3] = n3 == 0 || n3 == this.vcount - 1 ? this.helperArray[n2 - 1][n3].plus(this.ComplexVectorIntegrator(complex2, complex, n4)) : this.helperArray[n2 - 1][n3].plus(this.ComplexVectorOneStepIntegrator(complex2, complex));
                    complex2 = complex;
                    this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
                }
                d = this.umin.getValue();
                complex2 = this.domainGrid(d, d2);
                d2 += this.dv;
            }
        } else {
            n3 = (int)Math.floor(0.5 * (double)(this.ucount - 1));
            n2 = (int)Math.floor(0.5 * (double)(this.vcount - 1));
            this.helperArray[0][n2] = new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
            d = this.umin.getValue();
            d2 = this.vmin.getValue() + this.dv * (double)n2;
            complex2 = this.domainGrid(d, d2);
            for (n = 0; n < this.ucount - 1; ++n) {
                complex = this.domainGrid(d += this.du, d2);
                this.helperArray[n + 1][n2] = this.helperArray[n][n2].plus(this.ComplexVectorIntegrator(complex2, complex, 2 * n4));
                complex2 = complex;
                this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
            }
            d = this.umin.getValue();
            for (n = 0; n < this.ucount; ++n) {
                int n5;
                d2 = this.vmin.getValue() + this.dv * (double)n2;
                complex2 = this.domainGrid(d, d2);
                for (n5 = n2 + 1; n5 < this.vcount; ++n5) {
                    complex = this.domainGrid(d, d2 += this.dv);
                    this.helperArray[n][n5] = complex.r() < 0.125 || n == this.ucount - 1 ? this.helperArray[n][n5 - 1].plus(this.ComplexVectorIntegrator(complex2, complex, n4)) : this.helperArray[n][n5 - 1].plus(this.ComplexVectorOneStepIntegrator(complex2, complex));
                    complex2 = complex;
                    this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
                }
                d2 = this.vmin.getValue() + this.dv * (double)n2;
                complex2 = this.domainGrid(d, d2);
                for (n5 = n2 - 1; n5 >= 0; --n5) {
                    complex = this.domainGrid(d, d2 -= this.dv);
                    this.helperArray[n][n5] = complex.r() < 0.125 || n == this.ucount - 1 ? this.helperArray[n][n5 + 1].plus(this.ComplexVectorIntegrator(complex2, complex, n4)) : this.helperArray[n][n5 + 1].plus(this.ComplexVectorOneStepIntegrator(complex2, complex));
                    complex2 = complex;
                    this.distFrom0 = Math.min(complex2.r(), this.distFrom0);
                }
                d += this.du;
            }
        }
        ComplexVector3D complexVector3D = this.getCenter();
        for (n2 = 0; n2 < this.ucount; ++n2) {
            for (n = 0; n < this.vcount; ++n) {
                this.helperArray[n2][n].assignMinus(complexVector3D);
            }
        }
    }

    public void computeHalfPeriod() {
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.AssociateMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(1);
                WeierstrassMinimalSurface.this.needsValueArray = true;
                WeierstrassMinimalSurface.this.createHelperArray();
                basicAnimator.setUseFilmstrip(WeierstrassMinimalSurface.this.getUseFilmstripForMorphing());
                final int n = WeierstrassMinimalSurface.this.getFramesForMorphing();
                WeierstrassMinimalSurface.this.setFramesForMorphing(24);
                basicAnimator.setFrames(WeierstrassMinimalSurface.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomLimits(WeierstrassMinimalSurface.this.afp, 0.0, Math.PI * 2);
                view.setShowAxes(true);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((BasicAnimator)changeEvent.getSource()).isRunning()) {
                            WeierstrassMinimalSurface.this.inAssociateMorph = true;
                        } else {
                            WeierstrassMinimalSurface.this.inAssociateMorph = false;
                            WeierstrassMinimalSurface.this.needsValueArray = true;
                            WeierstrassMinimalSurface.this.createHelperArray();
                            WeierstrassMinimalSurface.this.setFramesForMorphing(n);
                            view.setShowAxes(false);
                        }
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public int getNumberOfPieces() {
        return this.numberOfPieces;
    }

    public void setNumberOfPieces(int n) {
        block9: {
            block8: {
                if (this.multipleCopyOptions == null || n == this.numberOfPieces) {
                    return;
                }
                boolean bl = false;
                if (n == 1) {
                    bl = true;
                }
                for (int n2 : this.multipleCopyOptions) {
                    if (n != n2) continue;
                    bl = true;
                }
                if (!bl) {
                    return;
                }
                this.numberOfPieces = n;
                if (this.multipleCopyOptions.length != 1) break block8;
                if (this.numberOfPiecesToggle == null) break block9;
                this.numberOfPiecesToggle.setState(n > 1);
                break block9;
            }
            if (this.numberOfPiecesSelect != null) {
                if (n == 1) {
                    this.numberOfPiecesSelect.setSelectedIndex(0);
                } else {
                    for (int i = 0; i < this.multipleCopyOptions.length; ++i) {
                        if (n != this.multipleCopyOptions[i]) continue;
                        this.numberOfPiecesSelect.setSelectedIndex(i + 1);
                        break;
                    }
                }
            }
        }
        this.forceRedraw();
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        if (this.showConjugateSurfaceToggle != null && parameter == this.afp) {
            this.showConjugateSurfaceToggle.setState(Math.abs(1.5707963267948966 - this.afp.getValue()) < 0.001);
        }
        this.AFP = this.afp.getValue();
        if (parameter != this.afp) {
            this.needsValueArray = true;
        }
    }

    public View getDefaultView() {
        return new WMSView();
    }

    public class WMSView
    extends SurfaceView {
        public ActionList getActions() {
            ActionList actionList = super.getActions();
            if (WeierstrassMinimalSurface.this.canShowConjugateSurface || WeierstrassMinimalSurface.this.multipleCopyOptions != null) {
                actionList.add(null);
            }
            if (WeierstrassMinimalSurface.this.canShowConjugateSurface) {
                if (WeierstrassMinimalSurface.this.showConjugateSurfaceToggle == null) {
                    WeierstrassMinimalSurface.this.showConjugateSurfaceToggle = new ToggleAction(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.ShowConjugateSurface")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (this.getState()) {
                                WeierstrassMinimalSurface.this.afp.reset("pi/2");
                            } else {
                                WeierstrassMinimalSurface.this.afp.reset(0.0);
                            }
                        }
                    };
                }
                actionList.add(WeierstrassMinimalSurface.this.showConjugateSurfaceToggle);
            }
            if (WeierstrassMinimalSurface.this.multipleCopyOptions != null) {
                if (WeierstrassMinimalSurface.this.multipleCopyOptions.length == 1) {
                    if (WeierstrassMinimalSurface.this.numberOfPiecesToggle == null) {
                        WeierstrassMinimalSurface.this.numberOfPiecesToggle = new ToggleAction(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.ShowMoreCopies")){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (this.getState()) {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(WeierstrassMinimalSurface.this.multipleCopyOptions[0]);
                                } else {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(1);
                                }
                            }
                        };
                        WeierstrassMinimalSurface.this.numberOfPiecesToggle.setState(WeierstrassMinimalSurface.this.numberOfPieces > 1);
                    }
                    actionList.add(WeierstrassMinimalSurface.this.numberOfPiecesToggle);
                } else {
                    if (WeierstrassMinimalSurface.this.numberOfPiecesSelect == null) {
                        WeierstrassMinimalSurface.this.numberOfPiecesSelect = new ActionRadioGroup(){

                            public void optionSelected(int n) {
                                if (n == 0) {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(1);
                                } else {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(WeierstrassMinimalSurface.this.multipleCopyOptions[n - 1]);
                                }
                            }
                        };
                        WeierstrassMinimalSurface.this.numberOfPiecesSelect.addItem(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies.Default"));
                        for (int n : WeierstrassMinimalSurface.this.multipleCopyOptions) {
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.addItem(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies.NTimesDefault", "" + n));
                        }
                        if (WeierstrassMinimalSurface.this.numberOfPieces == 1) {
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.setSelectedIndex(0);
                        }
                        for (int i = 0; i < WeierstrassMinimalSurface.this.multipleCopyOptions.length; ++i) {
                            if (WeierstrassMinimalSurface.this.numberOfPieces != WeierstrassMinimalSurface.this.multipleCopyOptions[i]) continue;
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.setSelectedIndex(i + 1);
                            break;
                        }
                    }
                    ActionList actionList2 = new ActionList(I18n.tr("vmm.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies"));
                    actionList2.add(WeierstrassMinimalSurface.this.numberOfPiecesSelect);
                    actionList.add(actionList2);
                }
            }
            return actionList;
        }
    }
}

