/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class WavyEnneper_Weierstrass
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.WavyEnneper_Weierstrass.MainEx", 2);
    private IntegerParam higherExponent = new IntegerParam("vmm.surface.parametric.WavyEnneper_Weierstrass.HighP", 20);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.WavyEnneper_Weierstrass.CoeffA", 0.4, 0.4, 0.4);
    private RealParamAnimateable cc = new RealParamAnimateable("vmm.surface.parametric.WavyEnneper_Weierstrass.CoeffP", Math.PI, 0.0, Math.PI * 2);
    private boolean wantsCartesianGrid = false;
    private double ee;
    private double ff;
    private Complex b;

    public WavyEnneper_Weierstrass() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.higherExponent);
        this.addParameter(this.exponent);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-0.95);
        this.umax.reset(0.95);
        this.vmin.reset(-0.95);
        this.vmax.reset(0.95);
        this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 20.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        if (!this.wantsCartesianGrid) {
            this.uPatchCount.setValueAndDefault(8);
            this.vPatchCount.setValueAndDefault(20);
            this.setDefaultWindow(-1.4, 1.4, -1.4, 1.4);
            this.umin.reset(-2.0);
            this.umax.reset(0.0);
            this.vmin.reset(0.0);
            this.vmax.reset(Math.PI * 2);
        }
        this.canShowConjugateSurface = true;
    }

    protected Complex domainGrid(double d, double d2) {
        Complex complex;
        if (this.wantsCartesianGrid) {
            complex = new Complex(d, d2);
        } else {
            double d3 = Math.exp(d);
            complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        }
        return complex;
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        Complex complex4 = new Complex();
        complex2.assignPow(complex, this.ee);
        complex3.assignPow(complex, this.ff);
        complex3.assignTimes(this.b);
        complex4.assignPlus(complex2, complex3);
        return complex4;
    }

    protected Complex hPrime(Complex complex) {
        return this.gauss(complex);
    }

    protected Complex gaussTimesHPrime(Complex complex) {
        Complex complex2 = this.gauss(complex);
        return complex2.times(complex2);
    }

    protected Complex gaussInverseTimesHPrime(Complex complex) {
        return new Complex(1.0, 0.0);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.ee = 1.0 * (double)this.exponent.getValue();
        this.ff = 1.0 * (double)this.higherExponent.getValue();
        this.b = new Complex(this.bb.getValue() * Math.cos(this.cc.getValue()), this.bb.getValue() * Math.sin(this.cc.getValue()));
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[0][(int)Math.floor(this.vcount / 2)]);
        return complexVector3D.plus(this.helperArray[0][0]).times(0.5);
    }
}

