/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.core3D.UserExhibit3D;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class UserSurfaceParametric
extends SurfaceParametric
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo xFunc;
    private UserExhibit.FunctionInfo yFunc;
    private UserExhibit.FunctionInfo zFunc;

    public UserSurfaceParametric() {
        this.umin.reset(-2.0);
        this.umax.reset(2.0);
        this.vmin.reset(-2.0);
        this.vmax.reset(2.0);
        this.setDefaultWindow(-3.0, 3.0, -2.6, 2.6);
        this.setDefaultViewpoint(new Vector3D(5.0, -5.5, 3.0));
        this.userExhibitSupport = new UserExhibit3D.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 14.0, 0.0, 14.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 0.5, 0.25, 0.5));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("c", 2.0, 1.0, 2.0));
        this.xFunc = this.userExhibitSupport.addRealFunction("x", "u", "u", "v");
        this.yFunc = this.userExhibitSupport.addRealFunction("y", "v", "u", "v");
        this.zFunc = this.userExhibitSupport.addRealFunction("z", "c * sin(a/sqrt(1+u^2+v^2)) * exp(-b*(u^2+v^2))", "u", "v");
    }

    public Vector3D surfacePoint(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        double d3 = this.xFunc.realFunctionValue(dArray);
        double d4 = this.yFunc.realFunctionValue(dArray);
        double d5 = this.zFunc.realFunctionValue(dArray);
        if (Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5)) {
            return null;
        }
        return new Vector3D(d3, d4, d5);
    }

    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

