/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Torus
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.75", "1.2", "1.2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "0.4", "0.3", "1.2");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "0.4", "0.3", "1.2");

    public Torus() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = this.cc.getValue();
        double d6 = (d3 + d4 * Math.cos(d)) * Math.cos(d2);
        double d7 = (d3 + d4 * Math.cos(d)) * Math.sin(d2);
        double d8 = d5 * Math.sin(d);
        return new Vector3D(d6, d7, d8);
    }
}

