/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Symmetric_K_Noid
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Symmetric_K_Noid.MainEx", 6);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Symmetric_K_Noid.aa", 0.0, 0.0, 1.0);
    private int ex;
    private int ex_;
    private int e_odd;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private Complex q1;

    public Symmetric_K_Noid() {
        this.addParameter(this.aa);
        this.aa.setMinimumValueForInput(0.0);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(3);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(-26.0, 10.0, -43.0));
        this.setDefaultWindow(-7.0, 7.0, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(8);
        this.umin.reset(-2.5);
        this.umax.reset(2.5);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(0.0);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.canShowConjugateSurface = true;
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        if (!this.inAssociateMorph) {
            int n;
            GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[this.ex * 2];
            gridTransformMatrixArray[0] = new GridTransformMatrix();
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            } else if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            }
            if (this.flag0 || this.flag05) {
                for (n = 2; n < this.ex; ++n) {
                    gridTransformMatrixArray[n] = new GridTransformMatrix(gridTransformMatrixArray[n - 2]).rotateZ(-720.0 / (double)this.ex);
                    this.data.addGridTransform(gridTransformMatrixArray[n]);
                }
            }
            if (this.flag0) {
                for (n = 0; n < this.ex; ++n) {
                    gridTransformMatrixArray[this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(gridTransformMatrixArray[this.ex + n]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        Complex complex2 = new Complex(-complex.re + 1.0, -complex.im);
        Complex complex3 = new Complex(complex.re + 1.0, complex.im);
        complex2 = complex2.dividedBy(complex3);
        complex = complex2.logNearer(I_C);
        complex.assignTimes(2.0 / (double)this.ex);
        return complex.exponential();
    }

    protected Complex gauss(Complex complex) {
        if (this.e_odd > 0) {
            return complex.integerPower(this.e_odd);
        }
        Complex complex2 = complex.integerPower(this.ex_ - 1);
        Complex complex3 = complex.times(complex2);
        Complex complex4 = complex3.times(-this.rex);
        complex4.re += 1.0;
        complex3.re -= this.rex;
        complex3 = complex2.times(complex3).dividedBy(complex4);
        return complex3;
    }

    protected Complex hPrime(Complex complex) {
        if (this.e_odd > 0) {
            Complex complex2 = complex.integerPower(this.ex - 1);
            Complex complex3 = complex.times(complex2);
            complex3.re -= 1.0;
            complex3.assignTimes(complex3);
            return complex2.dividedBy(complex3.times(2.0 / (double)this.exponent.getValue()));
        }
        Complex complex4 = complex.integerPower(this.ex_ - 1);
        Complex complex5 = complex.times(complex4);
        Complex complex6 = complex5.times(complex5);
        complex6.re += 1.0;
        Complex complex7 = complex6.times(-this.re_e);
        complex7.assignPlus(complex5);
        complex7.assignTimes(complex4);
        complex6.re -= 2.0;
        complex6.assignTimes(complex6);
        return complex7.dividedBy(complex6.times(2.0 / (double)this.exponent.getValue()));
    }

    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(this.aa.getValue());
        this.ex = this.exponent.getValue();
        this.e_odd = 0;
        if ((double)this.ex / 2.0 - Math.floor((double)this.ex / 2.0) == 0.5) {
            this.e_odd = this.ex - 1;
            this.rex = 0.0;
        } else {
            this.ex_ = (int)Math.floor((double)this.ex / 2.0);
            this.rex = Math.pow(this.AA, this.ex_);
            this.re_e = this.rex / (this.rex * this.rex + 1.0);
        }
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[(int)Math.floor(this.ucount / 2)][this.vcount - 1]);
        complexVector3D.z = new Complex(this.helperArray[0][0].z.plus(this.helperArray[this.ucount - 1][0].z).times(0.5));
        return complexVector3D;
    }
}

