/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.RealParamAnimateable;
import vmm.core.SaveAndRestore;
import vmm.core.SettingsDialog;
import vmm.core.TaskManager;
import vmm.core.View;
import vmm.core3D.Grid3D;
import vmm.core3D.LightSettings;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DLit;
import vmm.functions.Function2;
import vmm.functions.ParseError;
import vmm.functions.Parser;
import vmm.functions.Variable;
import vmm.surface.Surface;

public abstract class SurfaceParametric
extends Surface {
    public static final int COLOR_WHITE = 0;
    public static final int COLOR_USER = 1;
    public static final int COLOR_TWO_SIDED_DEFAULT = 2;
    public static final int COLOR_TWO_SIDED_USER = 3;
    public static final int COLOR_GAUSS_CURVATURE = 5;
    public static final int COLOR_MEAN_CURVATURE = 6;
    public static final int COLOR_USER_FUNCTION_HSB = 7;
    public static final int COLOR_USER_FUNCTION_RGB = 8;
    private static final Color DEFAULT_FRONT_FACE_COLOR = new Color(229, 229, 178);
    private static final Color DEFAULT_BACK_FACE_COLOR = new Color(173, 166, 255);
    private int colorationType = 0;
    private Color twoSidedColor;
    private Color frontColor = DEFAULT_FRONT_FACE_COLOR;
    private Color backColor = DEFAULT_BACK_FACE_COLOR;
    private Variable uminVar = new Variable("umin");
    private Variable umaxVar = new Variable("umax");
    private Variable vminVar = new Variable("vmin");
    private Variable vmaxVar = new Variable("vmax");
    private Function2[] userColorExpressionHSB;
    private Function2[] userColorExpressionRGB;
    private String[] userColorExpressionHSBDefinitions;
    private String[] userColorExpressionRGBDefinitions;
    private TaskManager taskManager;
    private ActionRadioGroup surfaceColorationSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.surface.parametric.SurfaceParametric.color.WhitePaint"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.UserPaint"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.TwoSidedDefault"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.TwoSidedUser"), null, I18n.tr("vmm.surface.parametric.SurfaceParametric.color.GaussCurvature"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.MeanCurvature"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.UserHSB"), I18n.tr("vmm.surface.parametric.SurfaceParametric.color.UserRGB")}, 0){

        public void optionSelected(int n) {
            SurfaceParametric.this.doSurfaceColorationCommand(n);
        }
    };
    protected RealParamAnimateable umin = new RealParamAnimateable("vmm.surface.parametric.SurfaceParametric.Umin", -5.0);
    protected RealParamAnimateable umax = new RealParamAnimateable("vmm.surface.parametric.SurfaceParametric.Umax", 5.0);
    protected RealParamAnimateable vmin = new RealParamAnimateable("vmm.surface.parametric.SurfaceParametric.Vmin", -5.0);
    protected RealParamAnimateable vmax = new RealParamAnimateable("vmm.surface.parametric.SurfaceParametric.Vmax", 5.0);
    private static final double epsilon = 5.0E-5;

    public abstract Vector3D surfacePoint(double var1, double var3);

    public SurfaceParametric() {
        this.addParameter(this.vmax);
        this.addParameter(this.vmin);
        this.addParameter(this.umax);
        this.addParameter(this.umin);
        this.setFramesForMorphing(20);
    }

    public Vector3D deriv_u(double d, double d2) {
        return this.surfacePoint(d + 5.0E-5, d2).minus(this.surfacePoint(d - 5.0E-5, d2)).times(10000.0);
    }

    public Vector3D deriv_v(double d, double d2) {
        return this.surfacePoint(d, d2 + 5.0E-5).minus(this.surfacePoint(d, d2 - 5.0E-5)).times(10000.0);
    }

    public Vector3D surfaceNormal(double d, double d2) {
        Vector3D vector3D = this.deriv_u(d, d2);
        Vector3D vector3D2 = this.deriv_v(d, d2);
        return vector3D.cross(vector3D2);
    }

    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    protected void createData() {
        if (this.data == null || this.data.getUPatchCount() != this.uPatchCount.getValue() || this.data.getVPatchCount() != this.vPatchCount.getValue()) {
            this.data = new Grid3D(this.uPatchCount.getValue(), this.vPatchCount.getValue());
        }
        int n = this.data.getUCount();
        int n2 = this.data.getVCount();
        double d = this.umin.getValue();
        double d2 = this.umax.getValue();
        double d3 = this.vmin.getValue();
        double d4 = this.vmax.getValue();
        double d5 = (d2 - d) / (double)(n - 1);
        double d6 = (d4 - d3) / (double)(n2 - 1);
        this.uminVar.setVal(this.umin.getValue());
        this.umaxVar.setVal(this.umax.getValue());
        this.vminVar.setVal(this.vmin.getValue());
        this.vmaxVar.setVal(this.vmax.getValue());
        if (this.taskManager == null) {
            this.taskManager = new TaskManager();
        }
        ArrayList<ComputeOneRowOfGrid> arrayList = new ArrayList<ComputeOneRowOfGrid>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new ComputeOneRowOfGrid(this.data, i, d + (double)i * d5, d3, d6, n2));
        }
        this.taskManager.executeAndWait(arrayList);
        if (this.colorationType <= 3) {
            this.data.clearPatchColors();
            switch (this.colorationType) {
                case 0: {
                    this.data.setDefaultPatchColor(Color.WHITE);
                    this.data.setDefaultBackColor(null);
                    break;
                }
                case 1: {
                    this.data.setDefaultPatchColor(this.twoSidedColor);
                    this.data.setDefaultBackColor(null);
                    break;
                }
                case 2: 
                case 3: {
                    this.data.setDefaultPatchColor(this.frontColor);
                    this.data.setDefaultBackColor(this.backColor);
                }
            }
        }
    }

    private Color computePatchColor(double d, double d2) {
        switch (this.colorationType) {
            case 5: {
                double d3 = this.findGaussAndMeanCurvatureAt(d, d2)[1];
                double d4 = d3 - (double)((int)Math.floor(d3));
                return Color.getHSBColor((float)d4, 1.0f, 1.0f);
            }
            case 6: {
                double d5 = this.findGaussAndMeanCurvatureAt(d, d2)[0];
                double d6 = d5 - (double)((int)Math.floor(d5));
                return Color.getHSBColor((float)d6, 1.0f, 1.0f);
            }
        }
        try {
            if (this.colorationType == 7) {
                float f = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[0].value(d, d2)));
                float f2 = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[1].value(d, d2)));
                float f3 = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[2].value(d, d2)));
                return Color.getHSBColor(f, f2, f3);
            }
            float f = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[0].value(d, d2)));
            float f4 = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[1].value(d, d2)));
            float f5 = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[2].value(d, d2)));
            return new Color(f, f4, f5);
        }
        catch (NullPointerException nullPointerException) {
            return Color.WHITE;
        }
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        if (!(view instanceof View3DLit)) {
            return actionList;
        }
        ActionList actionList2 = new ActionList(I18n.tr("vmm.surface.parametric.SurfaceParametric.SurfaceColoration"));
        actionList2.add(this.surfaceColorationSelect);
        actionList.add(null);
        actionList.add(actionList2);
        return actionList;
    }

    public void addExtraXML(Document document, Element element) {
        super.addExtraXML(document, element);
        if (this.colorationType != 0) {
            Element element2 = document.createElement("surface_coloration");
            element2.setAttribute("type", "" + this.colorationType);
            switch (this.colorationType) {
                case 1: {
                    SaveAndRestore.addElement(document, element2, "user_color", this.twoSidedColor);
                    break;
                }
                case 3: {
                    SaveAndRestore.addElement(document, element2, "front_color", this.frontColor);
                    SaveAndRestore.addElement(document, element2, "back_color", this.backColor);
                    break;
                }
                case 7: {
                    SaveAndRestore.addElement(document, element2, "user_color_1", this.userColorExpressionHSBDefinitions[0]);
                    SaveAndRestore.addElement(document, element2, "user_color_2", this.userColorExpressionHSBDefinitions[1]);
                    SaveAndRestore.addElement(document, element2, "user_color_3", this.userColorExpressionHSBDefinitions[2]);
                    break;
                }
                case 8: {
                    SaveAndRestore.addElement(document, element2, "user_color_1", this.userColorExpressionRGBDefinitions[0]);
                    SaveAndRestore.addElement(document, element2, "user_color_2", this.userColorExpressionRGBDefinitions[1]);
                    SaveAndRestore.addElement(document, element2, "user_color_3", this.userColorExpressionRGBDefinitions[2]);
                }
            }
            element.appendChild(element2);
        }
    }

    public void readExtraXML(Element element) throws IOException {
        super.readExtraXML(element);
        try {
            NodeList nodeList = element.getElementsByTagName("surface_coloration");
            if (nodeList.getLength() == 0) {
                return;
            }
            Element element2 = (Element)nodeList.item(0);
            int n = Integer.parseInt(element2.getAttribute("type"));
            switch (n) {
                case 1: {
                    this.twoSidedColor = (Color)SaveAndRestore.getChildElementValue(element2, "user_color", Color.class);
                    if (this.twoSidedColor != null) break;
                    return;
                }
                case 3: {
                    this.frontColor = (Color)SaveAndRestore.getChildElementValue(element2, "front_color", Color.class);
                    this.backColor = (Color)SaveAndRestore.getChildElementValue(element2, "back_color", Color.class);
                    if (this.frontColor != null && this.backColor != null) break;
                    return;
                }
                case 7: 
                case 8: {
                    Parser parser = new Parser();
                    parser.add(this.uminVar);
                    parser.add(this.umaxVar);
                    parser.add(this.vminVar);
                    parser.add(this.vmaxVar);
                    Function2[] function2Array = new Function2[3];
                    String[] stringArray = new String[]{(String)SaveAndRestore.getChildElementValue(element2, "user_color_1", String.class), (String)SaveAndRestore.getChildElementValue(element2, "user_color_2", String.class), (String)SaveAndRestore.getChildElementValue(element2, "user_color_3", String.class)};
                    function2Array[0] = parser.parseFunction2(null, stringArray[0], "u", "v");
                    function2Array[1] = parser.parseFunction2(null, stringArray[1], "u", "v");
                    function2Array[2] = parser.parseFunction2(null, stringArray[2], "u", "v");
                    if (n == 7) {
                        this.userColorExpressionHSB = function2Array;
                        this.userColorExpressionHSBDefinitions = stringArray;
                        break;
                    }
                    this.userColorExpressionRGB = function2Array;
                    this.userColorExpressionRGBDefinitions = stringArray;
                }
            }
            this.colorationType = n;
            this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector3D gaussMap(double d, double d2) {
        Vector3D vector3D = this.deriv_u(d, d2).cross(this.deriv_v(d, d2));
        double d3 = vector3D.norm();
        if (Double.isInfinite(d3) || Double.isNaN(d3) || d3 == 0.0) {
            vector3D.x = 1.0;
            vector3D.y = 0.0;
            vector3D.z = 0.0;
        } else {
            vector3D.normalize();
        }
        return vector3D;
    }

    private Vector3D gaussMap_u(double d, double d2) {
        return this.gaussMap(d + 5.0E-5, d2).minus(this.gaussMap(d - 5.0E-5, d2)).times(10000.0);
    }

    private Vector3D gaussMap_v(double d, double d2) {
        return this.gaussMap(d, d2 + 5.0E-5).minus(this.gaussMap(d, d2 - 5.0E-5)).times(10000.0);
    }

    private double[] findGaussAndMeanCurvatureAt(double d, double d2) {
        Vector3D vector3D = this.deriv_u(d, d2);
        Vector3D vector3D2 = this.deriv_v(d, d2);
        Vector3D vector3D3 = this.gaussMap_u(d, d2);
        Vector3D vector3D4 = this.gaussMap_v(d, d2);
        Vector3D vector3D5 = vector3D.normalized();
        double d3 = vector3D2.dot(vector3D5);
        Vector3D vector3D6 = vector3D5.times(d3);
        Vector3D vector3D7 = vector3D2.minus(vector3D6);
        Vector3D vector3D8 = vector3D7.normalized();
        Vector3D vector3D9 = vector3D5.plus(vector3D8);
        Vector3D vector3D10 = vector3D3.times(1.0 / vector3D.norm());
        Vector3D vector3D11 = vector3D10.times(d3);
        Vector3D vector3D12 = vector3D4.minus(vector3D11);
        Vector3D vector3D13 = vector3D12.times(1.0 / vector3D7.norm());
        Vector3D vector3D14 = vector3D10.plus(vector3D13);
        double d4 = -vector3D10.dot(vector3D5);
        double d5 = -vector3D13.dot(vector3D8);
        double d6 = 0.5 * (-vector3D14.dot(vector3D9) - d4 - d5);
        double d7 = d4 + d5;
        double d8 = d4 * d5 - d6 * d6;
        return new double[]{d7, d8};
    }

    private void doSurfaceColorationCommand(int n) {
        ArrayList<View> arrayList = this.getViews();
        switch (n) {
            case 0: {
                this.twoSidedColor = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)arrayList.get(i)).setLightSettings(new LightSettings());
                }
                break;
            }
            case 2: {
                this.frontColor = DEFAULT_FRONT_FACE_COLOR;
                this.backColor = DEFAULT_BACK_FACE_COLOR;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)arrayList.get(i)).setLightSettings(new LightSettings(1));
                }
                break;
            }
            case 1: 
            case 3: {
                ColorDialog colorDialog = new ColorDialog(n == 3);
                colorDialog.setVisible(true);
                if (!colorDialog.canceled()) break;
                this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
                return;
            }
            case 7: 
            case 8: {
                UserFunctionDialog userFunctionDialog = new UserFunctionDialog(n == 8);
                userFunctionDialog.setVisible(true);
                if (!userFunctionDialog.canceled()) break;
                this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
                return;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof View3DLit)) continue;
            ((View3DLit)arrayList.get(i)).setLightingEnabled(n <= 3);
        }
        this.surfaceColorationSelect.setSelectedIndex(n);
        this.colorationType = n;
        this.forceRedraw();
    }

    static /* synthetic */ Function2[] access$902(SurfaceParametric surfaceParametric, Function2[] function2Array) {
        surfaceParametric.userColorExpressionRGB = function2Array;
        return function2Array;
    }

    static /* synthetic */ String[] access$402(SurfaceParametric surfaceParametric, String[] stringArray) {
        surfaceParametric.userColorExpressionRGBDefinitions = stringArray;
        return stringArray;
    }

    static /* synthetic */ Function2[] access$1002(SurfaceParametric surfaceParametric, Function2[] function2Array) {
        surfaceParametric.userColorExpressionHSB = function2Array;
        return function2Array;
    }

    static /* synthetic */ String[] access$302(SurfaceParametric surfaceParametric, String[] stringArray) {
        surfaceParametric.userColorExpressionHSBDefinitions = stringArray;
        return stringArray;
    }

    private class ColorDialog
    extends SettingsDialog {
        private boolean twoSided;
        private RealParam[] params;
        private ParameterInput[] inputs;
        private JButton setButton;
        private JButton setButton2;
        private ActionListener setListener;

        ColorDialog(boolean bl) {
            super((Component)null, I18n.tr("vmm.surface.parametric.SurfaceParametric.dialog.UserColor"));
            this.setListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == ColorDialog.this.setButton || actionEvent.getSource() == ColorDialog.this.setButton2) {
                        Color color = Color.GRAY;
                        try {
                            color = actionEvent.getSource() == ColorDialog.this.setButton ? new Color((float)ColorDialog.this.params[0].getValue(), (float)ColorDialog.this.params[1].getValue(), (float)ColorDialog.this.params[2].getValue()) : new Color((float)ColorDialog.this.params[3].getValue(), (float)ColorDialog.this.params[4].getValue(), (float)ColorDialog.this.params[5].getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        color = JColorChooser.showDialog(ColorDialog.this, "", color);
                        if (color == null) {
                            return;
                        }
                        double d = (double)color.getRed() / 255.0;
                        double d2 = (double)color.getGreen() / 255.0;
                        double d3 = (double)color.getBlue() / 255.0;
                        d = (double)((int)(d * 100000.0 + 0.499)) / 100000.0;
                        d2 = (double)((int)(d2 * 100000.0 + 0.499)) / 100000.0;
                        d3 = (double)((int)(d3 * 100000.0 + 0.499)) / 100000.0;
                        if (actionEvent.getSource() == ColorDialog.this.setButton) {
                            ColorDialog.this.inputs[0].setText("" + d);
                            ColorDialog.this.inputs[1].setText("" + d2);
                            ColorDialog.this.inputs[2].setText("" + d3);
                        } else {
                            ColorDialog.this.inputs[3].setText("" + d);
                            ColorDialog.this.inputs[4].setText("" + d2);
                            ColorDialog.this.inputs[5].setText("" + d3);
                        }
                    }
                }
            };
            this.twoSided = bl;
            if (bl) {
                this.params = new RealParam[6];
                this.inputs = new ParameterInput[6];
                this.params[0] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Red"), (double)SurfaceParametric.this.frontColor.getRed() / 255.0);
                this.params[1] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Green"), (double)SurfaceParametric.this.frontColor.getGreen() / 255.0);
                this.params[2] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Blue"), (double)SurfaceParametric.this.frontColor.getBlue() / 255.0);
                this.params[3] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Red"), (double)SurfaceParametric.this.backColor.getRed() / 255.0);
                this.params[4] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Green"), (double)SurfaceParametric.this.backColor.getGreen() / 255.0);
                this.params[5] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Blue"), (double)SurfaceParametric.this.backColor.getBlue() / 255.0);
                this.params[0].setDefaultValue(0.898);
                this.params[1].setDefaultValue(0.898);
                this.params[2].setDefaultValue(0.698);
                this.params[3].setDefaultValue(0.6784);
                this.params[4].setDefaultValue(0.651);
                this.params[5].setDefaultValue(1.0);
            } else {
                this.params = new RealParam[3];
                this.inputs = new ParameterInput[3];
                Color color = SurfaceParametric.this.twoSidedColor;
                if (color == null) {
                    color = Color.WHITE;
                }
                this.params[0] = new RealParam(I18n.tr("common.Red"), (double)color.getRed() / 255.0);
                this.params[1] = new RealParam(I18n.tr("common.Green"), (double)color.getGreen() / 255.0);
                this.params[2] = new RealParam(I18n.tr("common.Blue"), (double)color.getBlue() / 255.0);
                this.params[0].setDefaultValue(1.0);
                this.params[1].setDefaultValue(1.0);
                this.params[2].setDefaultValue(1.0);
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].setMinimumValueForInput(0.0);
                this.params[i].setMaximumValueForInput(1.0);
                this.inputs[i] = new ParameterInput(this.params[i]);
                this.inputs[i].setColumns(6);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, bl ? 5 : 4, 5, 5));
            if (bl) {
                jPanel.add(new JLabel());
            }
            jPanel.add(new JLabel(I18n.tr("common.Red"), 0));
            jPanel.add(new JLabel(I18n.tr("common.Green"), 0));
            jPanel.add(new JLabel(I18n.tr("common.Blue"), 0));
            jPanel.add(new JLabel());
            if (bl) {
                jPanel.add(new JLabel(I18n.tr("common.Front") + ": ", 4));
            }
            jPanel.add(this.inputs[0]);
            jPanel.add(this.inputs[1]);
            jPanel.add(this.inputs[2]);
            this.setButton = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.SetColorButton"));
            this.setButton.addActionListener(this.setListener);
            jPanel.add(this.setButton);
            if (bl) {
                jPanel.add(new JLabel(I18n.tr("common.Back") + ": ", 4));
                jPanel.add(this.inputs[3]);
                jPanel.add(this.inputs[4]);
                jPanel.add(this.inputs[5]);
                this.setButton2 = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.SetColorButton"));
                this.setButton2.addActionListener(this.setListener);
                jPanel.add(this.setButton2);
            }
            this.addInputPanel(jPanel);
        }

        protected void doApply() {
            if (this.doOK()) {
                int n;
                ArrayList<View> arrayList = SurfaceParametric.this.getViews();
                SurfaceParametric.this.colorationType = this.twoSided ? 3 : 1;
                for (n = 0; n < arrayList.size(); ++n) {
                    if (!(arrayList.get(n) instanceof View3DLit)) continue;
                    ((View3DLit)arrayList.get(n)).setLightingEnabled(true);
                }
                if (this.twoSided) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (!(arrayList.get(n) instanceof View3DLit)) continue;
                        ((View3DLit)arrayList.get(n)).setLightSettings(new LightSettings(1));
                    }
                } else {
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (!(arrayList.get(n) instanceof View3DLit)) continue;
                        ((View3DLit)arrayList.get(n)).setLightSettings(new LightSettings());
                    }
                }
                SurfaceParametric.this.forceRedraw();
            }
        }

        protected boolean doOK() {
            for (int i = 0; i < this.inputs.length; ++i) {
                String string = this.inputs[i].checkContents();
                if (string != null) {
                    JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
                    return false;
                }
                this.inputs[i].setValueFromContents();
            }
            if (this.twoSided) {
                SurfaceParametric.this.frontColor = new Color((float)this.params[0].getValue(), (float)this.params[1].getValue(), (float)this.params[2].getValue());
                SurfaceParametric.this.backColor = new Color((float)this.params[3].getValue(), (float)this.params[4].getValue(), (float)this.params[5].getValue());
            } else {
                SurfaceParametric.this.twoSidedColor = new Color((float)this.params[0].getValue(), (float)this.params[1].getValue(), (float)this.params[2].getValue());
            }
            return true;
        }

        protected void doDefaults() {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i].defaultVal();
            }
        }

        boolean canceled() {
            return this.canceled;
        }
    }

    private class UserFunctionDialog
    extends SettingsDialog {
        private boolean useRGB;
        private JTextField[] inputs;

        UserFunctionDialog(boolean bl) {
            super((Component)null, I18n.tr("vmm.surface.parametric.SurfaceParametric.dialog.UserColorFunctions"));
            this.inputs = new JTextField[3];
            this.useRGB = bl;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(5, 5));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel2.add(new JLabel(I18n.tr(bl ? "common.Red" : "common.Hue") + "(u,v) = ", 4));
            jPanel2.add(new JLabel(I18n.tr(bl ? "common.Green" : "common.Saturation") + "(u,v) = ", 4));
            jPanel2.add(new JLabel(I18n.tr(bl ? "common.Blue" : "common.Brightness") + "(u,v) = ", 4));
            jPanel.add((Component)jPanel2, "West");
            this.inputs[0] = new JTextField(30);
            this.inputs[1] = new JTextField(30);
            this.inputs[2] = new JTextField(30);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel3.add(this.inputs[0]);
            jPanel3.add(this.inputs[1]);
            jPanel3.add(this.inputs[2]);
            jPanel.add((Component)jPanel3, "Center");
            if (!bl) {
                if (SurfaceParametric.this.userColorExpressionHSBDefinitions == null) {
                    this.doDefaults();
                } else {
                    this.inputs[0].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[0]);
                    this.inputs[1].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[1]);
                    this.inputs[2].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[2]);
                }
            } else if (SurfaceParametric.this.userColorExpressionRGBDefinitions == null) {
                this.doDefaults();
            } else {
                this.inputs[0].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[0]);
                this.inputs[1].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[1]);
                this.inputs[2].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[2]);
            }
            this.addInputPanel(jPanel);
        }

        protected boolean doOK() {
            Parser parser = new Parser();
            parser.add(SurfaceParametric.this.uminVar);
            parser.add(SurfaceParametric.this.umaxVar);
            parser.add(SurfaceParametric.this.vminVar);
            parser.add(SurfaceParametric.this.vmaxVar);
            Function2[] function2Array = new Function2[3];
            String[] stringArray = new String[3];
            for (int i = 0; i < 3; ++i) {
                stringArray[i] = this.inputs[i].getText();
                try {
                    function2Array[i] = parser.parseFunction2(null, stringArray[i], "u", "v");
                    continue;
                }
                catch (ParseError parseError) {
                    String string = I18n.tr("vmm.surface.parametric.SurfaceParametric.error.BadExpression", parseError.getMessage());
                    JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
                    this.inputs[i].selectAll();
                    this.inputs[i].requestFocus();
                    return false;
                }
            }
            if (this.useRGB) {
                SurfaceParametric.access$902(SurfaceParametric.this, function2Array);
                SurfaceParametric.access$402(SurfaceParametric.this, stringArray);
            } else {
                SurfaceParametric.access$1002(SurfaceParametric.this, function2Array);
                SurfaceParametric.access$302(SurfaceParametric.this, stringArray);
            }
            return true;
        }

        protected void doApply() {
            if (this.doOK()) {
                SurfaceParametric.this.colorationType = this.useRGB ? 8 : 7;
                ArrayList<View> arrayList = SurfaceParametric.this.getViews();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)arrayList.get(i)).setLightingEnabled(false);
                }
                SurfaceParametric.this.forceRedraw();
            }
        }

        protected void doDefaults() {
            if (this.useRGB) {
                this.inputs[0].setText("0.5");
                this.inputs[1].setText("(u - umin) / (umax - umin)");
                this.inputs[2].setText("(v - vmin) / (vmax - vmin)");
            } else {
                this.inputs[0].setText("(v - vmin) / (vmax - vmin)");
                this.inputs[1].setText("1");
                this.inputs[2].setText("1");
            }
        }

        boolean canceled() {
            return this.canceled;
        }
    }

    private class ComputeOneRowOfGrid
    implements Runnable {
        Grid3D data;
        int row;
        double u;
        double v1;
        double dv;
        int vCount;

        ComputeOneRowOfGrid(Grid3D grid3D, int n, double d, double d2, double d3, int n2) {
            this.row = n;
            this.u = d;
            this.data = grid3D;
            this.v1 = d2;
            this.dv = d3;
            this.vCount = n2;
        }

        public void run() {
            for (int i = 0; i < this.vCount; ++i) {
                double d = this.v1 + (double)i * this.dv;
                this.data.setVertex(this.row, i, SurfaceParametric.this.surfacePoint(this.u, d));
                if (SurfaceParametric.this.colorationType > 3) {
                    this.data.setPatchColor(this.row, i, SurfaceParametric.this.computePatchColor(this.u, d));
                }
                Vector3D vector3D = SurfaceParametric.this.surfaceNormal(this.u, d);
                this.data.setNormal(this.row, i, vector3D);
            }
        }
    }
}

