/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.SurfaceView;
import vmm.surface.parametric.SurfaceParametric;

public class SnailShell
extends SurfaceParametric {
    private RealParamAnimateable a = new RealParamAnimateable("a", 1.0, 1.0, 1.0);
    private RealParamAnimateable b = new RealParamAnimateable("b", 1.4, 1.0, 1.4);
    private RealParamAnimateable c = new RealParamAnimateable("c", 0.05, 0.1, 0.05);
    private RealParamAnimateable d = new RealParamAnimateable("d", 6.0, 2.0, 6.0);

    public SnailShell() {
        this.addParameter(this.d);
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultViewpoint(new Vector3D(-40.0, 20.0, 0.0));
        this.setDefaultWindow(-3.5, 3.5, -3.5, 3.5);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset(-2.0);
        this.vmax.reset(25.0);
        this.uPatchCount.setValueAndDefault(30);
        this.vPatchCount.setValueAndDefault(40);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.a.getValue();
        double d4 = this.b.getValue();
        double d5 = this.c.getValue();
        double d6 = this.d.getValue();
        double d7 = d2 + (d2 - this.vmin.getValue()) * (d2 - this.vmin.getValue()) / 16.0;
        double d8 = Math.exp(-d5 * d7);
        double d9 = d8 * (d3 + d4 * Math.cos(d));
        return new Vector3D(d9 * Math.cos(d7), d6 - d8 * (d6 + d4 * Math.sin(d)), d9 * Math.sin(d7));
    }

    public View getDefaultView() {
        SurfaceView surfaceView = new SurfaceView();
        surfaceView.setGridSpacing(0);
        surfaceView.setAntialiased(true);
        return surfaceView;
    }
}

